/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.node.stream;

import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Stream;

public abstract class FlatteningStream<K, E>
implements Stream<E> {
    private Stream<? extends K> in;
    private Stream<? extends E> out;
    private E next;

    public FlatteningStream(Stream<? extends K> in) {
        this.in = in;
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    @Override
    public E next() throws DocumentException {
        try {
            E e;
            while (this.out == null || (e = this.out.next()) == null) {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
                if (this.in == null) {
                    return null;
                }
                K k = this.in.next();
                if (k != null) {
                    this.out = this.getOutStream(k);
                    continue;
                }
                this.in.close();
                this.in = null;
                return null;
            }
            return e;
        }
        catch (DocumentException e) {
            this.close();
            throw e;
        }
    }

    protected abstract Stream<? extends E> getOutStream(K var1) throws DocumentException;
}

