/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.operator;

import io.brackit.query.BrackitQueryContext;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.Str;
import io.brackit.query.compiler.translator.Reference;
import io.brackit.query.expr.RangeExpr;
import io.brackit.query.expr.SequenceExpr;
import io.brackit.query.operator.Check;
import io.brackit.query.operator.Cursor;
import io.brackit.query.operator.ForBind;
import io.brackit.query.operator.Operator;
import io.brackit.query.operator.Print;
import io.brackit.query.operator.Start;
import io.brackit.query.operator.TupleImpl;
import io.brackit.query.util.aggregator.Aggregate;
import io.brackit.query.util.aggregator.Grouping;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class GroupBy
extends Check
implements Operator {
    final Operator in;
    final int[] groupSpecs;
    final int[] addAggSpecs;
    final Aggregate defaultAgg;
    final Aggregate[] addAggs;
    final boolean sequential;

    public GroupBy(Operator in, Aggregate dftAgg, Aggregate[] addAggs, int grpSpecCnt, boolean sequential) {
        this.in = in;
        this.defaultAgg = dftAgg;
        this.addAggs = addAggs;
        this.groupSpecs = new int[grpSpecCnt];
        this.addAggSpecs = new int[addAggs.length];
        this.sequential = sequential;
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) throws QueryException {
        Cursor c = this.in.create(ctx, tuple);
        int tupleSize = this.in.tupleWidth(tuple.getSize());
        if (this.groupSpecs.length == 0) {
            return new AllGroupBy(c, tupleSize);
        }
        if (this.sequential) {
            return new SequentialGroupBy(c, tupleSize);
        }
        return new HashGroupBy(c, tupleSize);
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) throws QueryException {
        Cursor c = this.in.create(ctx, buf, len);
        int tupleSize = this.in.tupleWidth(buf[0].getSize());
        if (this.groupSpecs.length == 0) {
            return new AllGroupBy(c, tupleSize);
        }
        if (this.sequential) {
            return new SequentialGroupBy(c, tupleSize);
        }
        return new HashGroupBy(c, tupleSize);
    }

    @Override
    public int tupleWidth(int initSize) {
        return this.in.tupleWidth(initSize) + this.addAggs.length;
    }

    public Reference group(int groupSpecNo) {
        return pos -> {
            this.groupSpecs[groupSpecNo] = pos;
        };
    }

    public Reference aggregate(int addAggNo) {
        return pos -> {
            this.addAggSpecs[addAggNo] = pos;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Start s = new Start();
        ForBind forBind = new ForBind(s, new RangeExpr(new Int32(1), new Int32(10)), false);
        ForBind forBind2 = new ForBind(forBind, new SequenceExpr(new Str("a"), new Str("b"), new Str("c")), false);
        forBind.bindVariable(true);
        GroupBy groupBy = new GroupBy(forBind2, Aggregate.SEQUENCE, new Aggregate[]{Aggregate.AVG, Aggregate.SUM}, 1, true);
        groupBy.group(0).setPos(1);
        Print p = new Print(groupBy, System.out);
        BrackitQueryContext ctx = new BrackitQueryContext();
        Cursor c = p.create(ctx, TupleImpl.EMPTY_TUPLE);
        c.open(ctx);
        try {
            while (c.next(ctx) != null) {
            }
        }
        finally {
            c.close(ctx);
        }
    }

    private class AllGroupBy
    implements Cursor {
        final Cursor c;
        final Grouping grp;
        Tuple next;

        public AllGroupBy(Cursor c, int tupleSize) {
            this.c = c;
            this.grp = new Grouping(GroupBy.this.groupSpecs, GroupBy.this.addAggSpecs, GroupBy.this.defaultAgg, GroupBy.this.addAggs, tupleSize);
        }

        @Override
        public void open(QueryContext ctx) throws QueryException {
            this.c.open(ctx);
        }

        @Override
        public void close(QueryContext ctx) {
            this.grp.clear();
            this.c.close(ctx);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Tuple next(QueryContext ctx) throws QueryException {
            block0: while (true) {
                if (this.grp.getSize() > 0) {
                    emit = this.grp.emit();
                    this.grp.clear();
                    return emit;
                }
                t = this.next;
                if (t == null && (t = this.c.next(ctx)) == null) break;
                if (GroupBy.this.check && GroupBy.this.dead(t)) {
                    if (this.grp.getSize() != 0) continue;
                    this.next = null;
                    return this.grp.singleEmit(t);
                }
                this.grp.add(null, t);
                while (true) {
                    if (!((this.next = this.c.next(ctx)) == null || GroupBy.this.check && GroupBy.this.separate(t, this.next))) ** break;
                    continue block0;
                    this.grp.add(null, this.next);
                }
                break;
            }
            return null;
        }
    }

    private class SequentialGroupBy
    implements Cursor {
        final Cursor c;
        final Grouping grp;
        Tuple next;

        public SequentialGroupBy(Cursor c, int tupleSize) {
            this.c = c;
            this.grp = new Grouping(GroupBy.this.groupSpecs, GroupBy.this.addAggSpecs, GroupBy.this.defaultAgg, GroupBy.this.addAggs, tupleSize);
        }

        @Override
        public void open(QueryContext ctx) throws QueryException {
            this.c.open(ctx);
        }

        @Override
        public void close(QueryContext ctx) {
            this.grp.clear();
            this.c.close(ctx);
        }

        @Override
        public Tuple next(QueryContext ctx) throws QueryException {
            Tuple t = this.next;
            if (t == null && (t = this.c.next(ctx)) == null) {
                return null;
            }
            this.next = null;
            if (GroupBy.this.check && GroupBy.this.dead(t)) {
                return this.grp.singleEmit(t);
            }
            this.grp.add(t);
            while (!((this.next = this.c.next(ctx)) == null || GroupBy.this.check && GroupBy.this.separate(t, this.next) || !this.grp.add(this.next))) {
            }
            Tuple emit = this.grp.emit();
            this.grp.clear();
            return emit;
        }
    }

    private class HashGroupBy
    implements Cursor {
        final Cursor c;
        final int tupleSize;
        final Map<Key, Grouping> map;
        Tuple next;
        Iterator<Key> it;

        public HashGroupBy(Cursor c, int tupleSize) {
            this.c = c;
            this.tupleSize = tupleSize;
            this.map = new LinkedHashMap<Key, Grouping>();
        }

        @Override
        public void open(QueryContext ctx) throws QueryException {
            this.c.open(ctx);
        }

        @Override
        public void close(QueryContext ctx) {
            this.map.clear();
            this.c.close(ctx);
        }

        @Override
        public Tuple next(QueryContext ctx) throws QueryException {
            while (true) {
                Tuple t;
                if (this.it != null) {
                    if (this.it.hasNext()) {
                        Key key = this.it.next();
                        Grouping grp = this.map.get(key);
                        this.it.remove();
                        return this.emit(grp);
                    }
                    this.it = null;
                    this.map.clear();
                }
                if ((t = this.next) == null && (t = this.c.next(ctx)) == null) break;
                if (GroupBy.this.check && GroupBy.this.dead(t)) {
                    if (this.map.isEmpty()) {
                        this.next = null;
                        Grouping grp = new Grouping(GroupBy.this.groupSpecs, GroupBy.this.addAggSpecs, GroupBy.this.defaultAgg, GroupBy.this.addAggs, this.tupleSize);
                        grp.add(t);
                        return grp.emit();
                    }
                    this.it = this.map.keySet().iterator();
                    continue;
                }
                this.add(t);
                while (!((this.next = this.c.next(ctx)) == null || GroupBy.this.check && GroupBy.this.separate(t, this.next))) {
                    this.add(this.next);
                }
                this.it = this.map.keySet().iterator();
            }
            return null;
        }

        private void add(Tuple t) throws QueryException {
            Atomic[] gks = Grouping.groupingKeys(GroupBy.this.groupSpecs, t);
            Key key = new Key(gks);
            Grouping grp = this.map.get(key);
            if (grp == null) {
                grp = new Grouping(GroupBy.this.groupSpecs, GroupBy.this.addAggSpecs, GroupBy.this.defaultAgg, GroupBy.this.addAggs, this.tupleSize);
                this.map.put(key, grp);
            }
            grp.add(gks, t);
        }

        private Tuple emit(Grouping grp) throws QueryException {
            Tuple t = grp.emit();
            grp.clear();
            return t;
        }
    }

    private static class Key {
        final int hash;
        final Atomic[] val;

        Key(Atomic[] val) {
            this.val = val;
            this.hash = Arrays.hashCode(val);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return Arrays.toString(this.val);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Key) {
                Key k = (Key)obj;
                for (int i = 0; i < this.val.length; ++i) {
                    Atomic a1 = this.val[i];
                    Atomic a2 = k.val[i];
                    if ((a1 != null || a2 == null) && a2 != null && a1.atomicCmp(a2) == 0) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

