/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.operator;

import io.brackit.query.QueryContext;
import io.brackit.query.Tuple;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Stream;
import io.brackit.query.operator.Check;
import io.brackit.query.operator.Cursor;
import io.brackit.query.operator.Operator;
import io.brackit.query.util.sort.Ordering;

public class OrderBy
extends Check
implements Operator {
    final Operator in;
    final Expr[] orderByExprs;
    final Ordering.OrderModifier[] modifier;

    public OrderBy(Operator in, Expr[] orderByExprs, Ordering.OrderModifier[] orderBySpec) {
        this.in = in;
        this.orderByExprs = orderByExprs;
        this.modifier = orderBySpec;
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) {
        return new OrderByCursor(this.in.create(ctx, tuple));
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) {
        return new OrderByCursor(this.in.create(ctx, buf, len));
    }

    @Override
    public int tupleWidth(int initSize) {
        return this.in.tupleWidth(initSize);
    }

    private class OrderByCursor
    implements Cursor {
        private final Cursor c;
        private Stream<? extends Tuple> sorted;
        private Tuple next;

        public OrderByCursor(Cursor c) {
            this.c = c;
        }

        @Override
        public void close(QueryContext ctx) {
            if (this.sorted != null) {
                this.sorted.close();
            }
            this.c.close(ctx);
        }

        @Override
        public Tuple next(QueryContext ctx) {
            Tuple t;
            if (this.sorted != null) {
                t = this.sorted.next();
                if (t != null) {
                    return t;
                }
                this.sorted.close();
            }
            if ((t = this.next) == null && (t = this.c.next(ctx)) == null) {
                return null;
            }
            this.next = null;
            if (OrderBy.this.check && OrderBy.this.dead(t)) {
                return t;
            }
            Ordering sort = new Ordering(OrderBy.this.orderByExprs, OrderBy.this.modifier);
            sort.add(ctx, t);
            while (!((this.next = this.c.next(ctx)) == null || OrderBy.this.check && OrderBy.this.separate(t, this.next))) {
                sort.add(ctx, this.next);
            }
            this.sorted = sort.sorted();
            t = this.sorted.next();
            return t;
        }

        @Override
        public void open(QueryContext ctx) {
            this.c.open(ctx);
        }
    }
}

