/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.operator;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.compiler.translator.Reference;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.operator.Check;
import io.brackit.query.operator.Cursor;
import io.brackit.query.operator.Operator;
import io.brackit.query.util.Cmp;
import io.brackit.query.util.join.FastList;
import io.brackit.query.util.join.MultiTypeJoinTable;
import java.util.Arrays;

public final class TableJoin
extends Check
implements Operator {
    final Operator left;
    final Operator right;
    int leftSize;
    int rightSize;
    final Expr rightExpr;
    final Expr leftExpr;
    final boolean leftJoin;
    final Cmp cmp;
    final boolean isGCmp;
    final boolean skipSort;
    int groupVar = -1;

    public TableJoin(Cmp cmp, boolean isGCmsp, boolean leftJoin, boolean skipSort, Operator l, Expr lExpr, Operator r, Expr rExpr) {
        this.cmp = cmp;
        this.isGCmp = isGCmsp;
        this.leftJoin = leftJoin;
        this.skipSort = skipSort;
        this.left = l;
        this.right = r;
        this.rightExpr = rExpr;
        this.leftExpr = lExpr;
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple tuple) throws QueryException {
        this.leftSize = this.left.tupleWidth(tuple.getSize());
        this.rightSize = this.right.tupleWidth(tuple.getSize());
        int lPad = this.leftSize - tuple.getSize();
        int rPad = this.rightSize - tuple.getSize();
        if (this.leftSize >= this.rightSize) {
            return new TableJoinCursor(this.left.create(ctx, tuple), this.leftSize, rPad);
        }
        return new TableJoinCursor(this.right.create(ctx, tuple), this.rightSize, lPad);
    }

    @Override
    public Cursor create(QueryContext ctx, Tuple[] buf, int len) throws QueryException {
        this.leftSize = this.left.tupleWidth(buf[0].getSize());
        this.rightSize = this.right.tupleWidth(buf[0].getSize());
        int lPad = this.leftSize - buf[0].getSize();
        int rPad = this.rightSize - buf[0].getSize();
        if (this.leftSize >= this.rightSize) {
            return new TableJoinCursor(this.left.create(ctx, buf, len), this.leftSize, rPad);
        }
        return new TableJoinCursor(this.right.create(ctx, buf, len), this.rightSize, lPad);
    }

    @Override
    public int tupleWidth(int initSize) {
        return this.left.tupleWidth(initSize) + this.right.tupleWidth(initSize) - initSize;
    }

    public Reference group() {
        return pos -> {
            this.groupVar = pos;
        };
    }

    private class TableJoinCursor
    implements Cursor {
        final Cursor cursor;
        final Sequence[] padding;
        final int size;
        private Tuple prev;
        private Tuple next;
        MultiTypeJoinTable table;
        Atomic tgk;
        Tuple tuple;
        FastList<Sequence[]> it;
        int itPos = 0;
        int itSize = 0;

        public TableJoinCursor(Cursor cursor, int size, int pad) {
            this.cursor = cursor;
            this.size = size;
            this.padding = new Sequence[pad];
        }

        @Override
        public void open(QueryContext ctx) throws QueryException {
            this.cursor.open(ctx);
            this.it = null;
        }

        @Override
        public void close(QueryContext ctx) {
            this.cursor.close(ctx);
            this.it = null;
        }

        @Override
        public Tuple next(QueryContext ctx) throws QueryException {
            if (this.it != null && this.itPos < this.itSize) {
                return this.tuple.concat(this.it.get(this.itPos++));
            }
            while ((this.tuple = this.next) != null || (this.tuple = this.cursor.next(ctx)) != null) {
                this.next = null;
                if (TableJoin.this.check && TableJoin.this.dead(this.tuple)) {
                    this.prev = this.tuple.concat(this.padding);
                    return this.prev;
                }
                if (TableJoin.this.groupVar >= 0) {
                    Atomic gk = (Atomic)this.tuple.get(TableJoin.this.groupVar);
                    if (this.tgk != null && this.tgk.atomicCmp(gk) != 0) {
                        this.table = null;
                    }
                }
                if (this.table == null) {
                    this.buildTable(ctx, this.tuple);
                }
                Sequence keys = TableJoin.this.isGCmp ? TableJoin.this.leftExpr.evaluate(ctx, this.tuple) : TableJoin.this.leftExpr.evaluateToItem(ctx, this.tuple);
                FastList<Sequence[]> matches = this.table.probe(keys);
                this.it = matches;
                this.itPos = 0;
                this.itSize = matches.getSize();
                if (this.itPos < this.itSize) {
                    this.prev = this.tuple.concat(matches.get(this.itPos++));
                    return this.prev;
                }
                if (!TableJoin.this.leftJoin) continue;
                if (TableJoin.this.check) {
                    if (this.prev != null && !TableJoin.this.separate(this.prev, this.tuple)) continue;
                    this.next = this.cursor.next(ctx);
                    if (this.next != null && !TableJoin.this.separate(this.tuple, this.next)) continue;
                    this.prev = this.tuple.conreplace(this.padding, TableJoin.this.local(), null);
                } else {
                    this.prev = this.tuple.concat(this.padding);
                }
                return this.prev;
            }
            this.table = null;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void buildTable(QueryContext ctx, Tuple tuple) throws QueryException {
            this.table = new MultiTypeJoinTable(TableJoin.this.cmp, TableJoin.this.isGCmp, TableJoin.this.skipSort);
            if (TableJoin.this.groupVar >= 0) {
                this.tgk = (Atomic)tuple.get(TableJoin.this.groupVar);
            }
            int pos = 1;
            boolean isLeftSizeBiggerOrEqualToRightSize = TableJoin.this.leftSize >= TableJoin.this.rightSize;
            Cursor cursor1 = isLeftSizeBiggerOrEqualToRightSize ? TableJoin.this.right.create(ctx, tuple) : TableJoin.this.left.create(ctx, tuple);
            try {
                Tuple cursorTuple;
                cursor1.open(ctx);
                while ((cursorTuple = cursor1.next(ctx)) != null) {
                    Sequence keys;
                    if (isLeftSizeBiggerOrEqualToRightSize) {
                        keys = TableJoin.this.isGCmp ? TableJoin.this.rightExpr.evaluate(ctx, cursorTuple) : TableJoin.this.rightExpr.evaluateToItem(ctx, cursorTuple);
                    } else {
                        Sequence sequence = keys = TableJoin.this.isGCmp ? TableJoin.this.leftExpr.evaluate(ctx, cursorTuple) : TableJoin.this.leftExpr.evaluateToItem(ctx, cursorTuple);
                    }
                    if (keys == null) continue;
                    Sequence[] tmp = cursorTuple.array();
                    Sequence[] bindings = Arrays.copyOfRange(tmp, this.size, tmp.length);
                    this.table.add(keys, bindings, pos++);
                }
            }
            finally {
                cursor1.close(ctx);
            }
        }
    }
}

