/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.sequence;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.IntNumeric;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.sequence.AbstractSequence;
import io.brackit.query.sequence.BaseIter;

public class ItemSequence
extends AbstractSequence {
    protected final Item[] items;

    public ItemSequence(Item ... items) {
        this.items = items;
    }

    @Override
    public boolean booleanValue() {
        if (this.items.length == 0) {
            return false;
        }
        if (this.items[0] instanceof Node) {
            return true;
        }
        if (this.items.length > 1) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Effective boolean value is undefined for sequences with two or more items not starting with a node");
        }
        return this.items[0].booleanValue();
    }

    @Override
    public IntNumeric size() {
        return new Int32(this.items.length);
    }

    @Override
    public Item get(IntNumeric pos) {
        if (Int32.ZERO.cmp(pos) >= 0 || this.size().cmp(pos) < 0) {
            return null;
        }
        return this.items[pos.intValue() - 1];
    }

    @Override
    public Iter iterate() {
        return new BaseIter(){
            int pos = 0;

            @Override
            public Item next() {
                return this.pos < ItemSequence.this.items.length ? ItemSequence.this.items[this.pos++] : null;
            }

            @Override
            public void close() {
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.items.length > 0) {
            sb.append(this.items[0]);
            for (int i = 1; i < this.items.length; ++i) {
                sb.append(",");
                sb.append(this.items[i]);
            }
        }
        return sb.toString();
    }
}

