/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.update;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.update.op.DeleteOp;

public class Delete
implements Expr {
    private final Expr expr;

    public Delete(Expr expr) {
        this.expr = expr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence result = this.expr.evaluate(ctx, tuple);
        if (result == null) {
            return null;
        }
        if (result instanceof Item) {
            this.handleItem(ctx, (Item)result);
            return null;
        }
        try (Iter it = result.iterate();){
            Item item;
            while ((item = it.next()) != null) {
                this.handleItem(ctx, item);
            }
        }
        return null;
    }

    private void handleItem(QueryContext ctx, Item item) {
        if (!(item instanceof Node)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_DELETE_TARGET_NOT_A_NODE_SEQUENCE, "Target item for delete is not a node: %s", item);
        }
        ctx.addPendingUpdate(new DeleteOp((Node)item));
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

