/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.update;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Una;
import io.brackit.query.expr.ConstructedNodeBuilder;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.update.op.ReplaceElementContentOp;
import io.brackit.query.update.op.ReplaceValueOp;
import java.util.EnumSet;

public class ReplaceValue
extends ConstructedNodeBuilder
implements Expr {
    private static final EnumSet<Kind> replaceValueKind = EnumSet.of(Kind.ELEMENT, Kind.ATTRIBUTE, Kind.TEXT, Kind.COMMENT, Kind.PROCESSING_INSTRUCTION);
    private final Expr sourceExpr;
    private final Expr targetExpr;

    public ReplaceValue(Expr sourceExpr, Expr targetExpr) {
        this.sourceExpr = sourceExpr;
        this.targetExpr = targetExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) throws QueryException {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) throws QueryException {
        Item targetItem;
        Sequence target = this.targetExpr.evaluate(ctx, tuple);
        if (target == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
        }
        if (target instanceof Item) {
            targetItem = (Item)target;
        } else {
            try (Iter it = target.iterate();){
                targetItem = it.next();
                if (targetItem == null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
                }
                if (it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE);
                }
            }
        }
        if (!(targetItem instanceof Node)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE, "Target item is atomic value %s", targetItem);
        }
        Node node = (Node)targetItem;
        if (!replaceValueKind.contains((Object)node.getKind())) {
            throw new QueryException(ErrorCode.ERR_UPDATE_REPLACE_TARGET_NOT_A_EATCP_NODE, "Target node kind %s is not allowed for replace node: %", new Object[]{node.getKind()});
        }
        Sequence source = this.sourceExpr.evaluate(ctx, tuple);
        String text = this.buildTextContent(source);
        if (node.getKind() == Kind.ELEMENT) {
            ctx.addPendingUpdate(new ReplaceElementContentOp(node, new Una(text)));
        } else {
            if (text != null && !text.isEmpty()) {
                if (node.getKind() == Kind.COMMENT) {
                    if (text.contains("''") || text.endsWith("'")) {
                        throw new QueryException(ErrorCode.ERR_COMMENT_WOULD_CONTAIN_ILLEGAL_HYPHENS);
                    }
                } else if (node.getKind() == Kind.PROCESSING_INSTRUCTION && text.contains("?>")) {
                    throw new QueryException(ErrorCode.ERR_PI_WOULD_CONTAIN_ILLEGAL_STRING);
                }
            }
            ctx.addPendingUpdate(new ReplaceValueOp(node, new Una(text)));
        }
        return null;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

