/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.update;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.expr.ConstructedNodeBuilder;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.update.UpdateList;
import io.brackit.query.update.op.UpdateOp;
import java.util.ArrayList;

public class Transform
extends ConstructedNodeBuilder
implements Expr {
    private final Expr[] copyBindings;
    private final Expr modifyExpr;
    private final Expr returnExpr;
    private final boolean[] referenced;

    public Transform(Expr[] copyBindings, boolean[] referenced, Expr modifyExpr, Expr returnExpr) {
        this.copyBindings = copyBindings;
        this.referenced = referenced;
        this.modifyExpr = modifyExpr;
        this.returnExpr = returnExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.returnExpr.evaluate(ctx, this.copyAndModify(ctx, tuple));
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        return this.returnExpr.evaluateToItem(ctx, this.copyAndModify(ctx, tuple));
    }

    private Tuple copyAndModify(QueryContext ctx, Tuple tuple) {
        UpdateList saved = ctx.getUpdateList();
        UpdateList mods = new UpdateList();
        ctx.setUpdateList(mods);
        ArrayList nodeCoies = new ArrayList(this.copyBindings.length);
        for (int i = 0; i < this.copyBindings.length; ++i) {
            if (!this.referenced[i]) continue;
            Item item = this.copyBindings[i].evaluateToItem(ctx, tuple);
            if (!(item instanceof Node)) {
                throw new QueryException(ErrorCode.ERR_TRANSFORM_SOURCE_EXPRESSION_NOT_SINGLE_NODE, "Source expression must evaluate to single node.");
            }
            Node<?> copy = this.copy(ctx, (Node)item);
            nodeCoies.add(copy);
            tuple = tuple.concat(copy);
        }
        this.modifyExpr.evaluateToItem(ctx, tuple);
        for (UpdateOp op : mods.list()) {
            if (!(op.getTarget() instanceof Node)) continue;
            boolean ok = false;
            for (Node node : nodeCoies) {
                if (!node.isAncestorOrSelfOf((Node)op.getTarget())) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            throw new QueryException(ErrorCode.ERR_TRANSFORM_MODIFIES_EXISTING_NODE, "Modify clause update expressions may not affect existing nodes.");
        }
        ctx.applyUpdates();
        ctx.setUpdateList(saved);
        return tuple;
    }

    @Override
    public boolean isUpdating() {
        return false;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

