/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.update.json;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.update.json.op.InsertIntoArrayOp;

public final class AppendJsonArrayValue
implements Expr {
    private final Expr sourceExpr;
    private final Expr targetExpr;

    public AppendJsonArrayValue(Expr sourceExpr, Expr targetExpr) {
        this.sourceExpr = sourceExpr;
        this.targetExpr = targetExpr;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        this.insertInto(ctx, tuple);
        return null;
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }

    private void insertInto(QueryContext ctx, Tuple tuple) {
        Item targetItem;
        Sequence target = this.targetExpr.evaluate(ctx, tuple);
        if (target == null) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
        }
        if (target instanceof Item) {
            targetItem = (Item)target;
        } else {
            try (Iter it = target.iterate();){
                targetItem = it.next();
                if (targetItem == null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_IS_EMPTY_SEQUENCE);
                }
                if (it.next() != null) {
                    throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_NOT_A_SINGLE_ED_NODE);
                }
            }
        }
        if (!(targetItem instanceof Array)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_INSERT_TARGET_NOT_A_SINGLE_ED_NODE, "Target item is atomic value %s", targetItem);
        }
        Item source = this.sourceExpr.evaluateToItem(ctx, tuple);
        ctx.addPendingUpdate(new InsertIntoArrayOp((Array)targetItem, source, -1));
    }
}

