/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.update.json;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Int32;
import io.brackit.query.atomic.QNm;
import io.brackit.query.atomic.Str;
import io.brackit.query.jdm.Expr;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.jdm.json.JsonItem;
import io.brackit.query.jdm.json.Object;
import io.brackit.query.update.json.op.DeleteArrayIndexOp;
import io.brackit.query.update.json.op.DeleteRecordFieldOp;

public final class DeleteJson
implements Expr {
    private final Expr expr;
    private final Expr fieldOrIndex;

    public DeleteJson(Expr expr, Expr fieldOrIndex) {
        this.expr = expr;
        this.fieldOrIndex = fieldOrIndex;
    }

    @Override
    public Sequence evaluate(QueryContext ctx, Tuple tuple) {
        return this.evaluateToItem(ctx, tuple);
    }

    @Override
    public Item evaluateToItem(QueryContext ctx, Tuple tuple) {
        Sequence result = this.expr.evaluate(ctx, tuple);
        if (result == null) {
            return null;
        }
        if (result instanceof Item) {
            this.handleItem(ctx, (Item)result, tuple);
            return null;
        }
        try (Iter it = result.iterate();){
            Item item;
            while ((item = it.next()) != null) {
                this.handleItem(ctx, item, tuple);
            }
        }
        return null;
    }

    private void handleItem(QueryContext ctx, Item item, Tuple tuple) {
        if (!(item instanceof JsonItem)) {
            throw new QueryException(ErrorCode.ERR_UPDATE_DELETE_TARGET_NOT_A_NODE_SEQUENCE, "Target item for delete is not a json item: %s", item);
        }
        if (item instanceof Array) {
            ctx.addPendingUpdate(new DeleteArrayIndexOp((Array)item, ((Int32)this.fieldOrIndex.evaluateToItem(ctx, tuple)).intValue()));
        } else {
            Item evaluatedItem = this.fieldOrIndex.evaluateToItem(ctx, tuple);
            if (evaluatedItem instanceof QNm) {
                QNm qNm = (QNm)evaluatedItem;
                ctx.addPendingUpdate(new DeleteRecordFieldOp((Object)item, qNm));
            } else if (evaluatedItem instanceof Str) {
                ctx.addPendingUpdate(new DeleteRecordFieldOp((Object)item, new QNm(evaluatedItem.toString())));
            }
        }
    }

    @Override
    public boolean isUpdating() {
        return true;
    }

    @Override
    public boolean isVacuous() {
        return false;
    }
}

