/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.update.op;

import io.brackit.query.QueryException;
import io.brackit.query.jdm.DocumentException;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.OperationNotSupportedException;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.update.op.OpType;
import io.brackit.query.update.op.UpdateOp;
import java.util.Arrays;

public class ReplaceNodeOp
implements UpdateOp {
    private final Node<?> target;
    private Node<?>[] content;
    private int size;

    public ReplaceNodeOp(Node<?> target) {
        this.target = target;
        this.content = new Node[1];
    }

    @Override
    public void apply() throws QueryException {
        if (this.target.getKind() == Kind.ATTRIBUTE) {
            Object parentElement = this.target.getParent();
            parentElement.deleteAttribute(this.target.getName());
            for (int i = 0; i < this.size; ++i) {
                parentElement.setAttribute(this.content[i]);
            }
        } else {
            Object ancorNode;
            boolean insertAfter;
            if (this.target.getPreviousSibling() != null) {
                insertAfter = true;
                ancorNode = this.target.getPreviousSibling();
            } else {
                insertAfter = false;
                ancorNode = this.target.getParent();
            }
            if (this.target.getKind() == Kind.TEXT || this.target.isRoot()) {
                this.deleteAndThenInsert((Node<?>)ancorNode, insertAfter);
            } else {
                this.insertAndThenDelete((Node<?>)ancorNode, insertAfter);
            }
        }
    }

    private void insertAndThenDelete(Node<?> ancorNode, boolean insertAfter) throws OperationNotSupportedException, DocumentException {
        this.insert(ancorNode, insertAfter);
        this.target.delete();
    }

    private void deleteAndThenInsert(Node<?> ancorNode, boolean insertAfter) throws DocumentException, OperationNotSupportedException {
        this.target.delete();
        this.insert(ancorNode, insertAfter);
    }

    private void insert(Node<?> ancorNode, boolean insertAfter) throws OperationNotSupportedException, DocumentException {
        for (int i = 0; i < this.size; ++i) {
            if (insertAfter) {
                ancorNode.insertAfter(this.content[i]);
                continue;
            }
            ancorNode.prepend(this.content[i]);
        }
    }

    @Override
    public Node<?> getTarget() {
        return this.target;
    }

    @Override
    public OpType getType() {
        return OpType.REPLACE_NODE;
    }

    public void addContent(Node<?> node) {
        if (this.size == this.content.length) {
            this.content = Arrays.copyOf(this.content, this.content.length * 3 / 2 + 1);
        }
        this.content[this.size++] = node;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append((Object)this.getType());
        out.append(" ");
        out.append(this.target);
        out.append(" with {");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                out.append(", ");
            }
            out.append(this.content[i]);
        }
        out.append("}");
        return out.toString();
    }
}

