/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class Cfg {
    public static final String DEFAULTS_FILE = "defaults.properties";
    public static final String CONFIG_FILE = "config.properties";
    protected static Properties defaults = new Properties();
    protected static Properties properties = new Properties();

    public static void set(String key, String val) {
        System.setProperty(key, val);
    }

    public static String asString(String key) {
        String val = Cfg.getValue(key);
        if (val == null) {
            throw new RuntimeException("no property value found for key: " + key);
        }
        return val;
    }

    public static String asString(String key, String dflt) {
        String s = Cfg.getValue(key);
        return s != null ? s : dflt;
    }

    public static String check(String key) {
        return Cfg.getValue(key);
    }

    private static String getValue(String key) {
        String val = System.getProperty(key);
        if (val != null) {
            return val;
        }
        val = properties.getProperty(key);
        if (val != null) {
            return val;
        }
        return defaults.getProperty(key);
    }

    public static void set(String key, int val) {
        System.setProperty(key, Integer.toString(val));
    }

    public static int asInt(String key) {
        return Integer.parseInt(Cfg.asString(key));
    }

    public static int asInt(String key, int dflt) {
        String s = Cfg.getValue(key);
        return s != null ? Integer.parseInt(s) : dflt;
    }

    public static void set(String key, long val) {
        System.setProperty(key, Long.toString(val));
    }

    public static long asLong(String key) {
        return Long.parseLong(Cfg.asString(key));
    }

    public static long asLong(String key, long dflt) {
        String s = Cfg.getValue(key);
        return s != null ? Long.parseLong(s) : dflt;
    }

    public static void set(String key, boolean val) {
        System.setProperty(key, Boolean.toString(val));
    }

    public static boolean asBool(String key) {
        return Boolean.parseBoolean(Cfg.asString(key));
    }

    public static boolean asBool(String key, boolean dflt) {
        String s = Cfg.getValue(key);
        return s != null ? Boolean.parseBoolean(s) : dflt;
    }

    public static void set(String key, double val) {
        System.setProperty(key, Double.toString(val));
    }

    public static double asDouble(String key) {
        return Double.parseDouble(Cfg.asString(key));
    }

    public static double asDouble(String key, double dflt) {
        String s = Cfg.getValue(key);
        return s != null ? Double.parseDouble(s) : dflt;
    }

    static {
        try {
            properties.load(new FileInputStream(CONFIG_FILE));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

