/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util;

import io.brackit.query.QueryContext;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Bool;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.Str;
import io.brackit.query.atomic.Una;
import io.brackit.query.expr.Cast;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;

public enum Cmp {
    eq,
    ne,
    lt,
    le,
    gt,
    ge;


    public Cmp swap() {
        switch (this.ordinal()) {
            case 5: {
                return le;
            }
            case 4: {
                return lt;
            }
            case 3: {
                return ge;
            }
            case 2: {
                return gt;
            }
        }
        return this;
    }

    public boolean aCmp(QueryContext ctx, Atomic left, Atomic right) throws QueryException {
        if (this == eq) {
            return left.eq(right);
        }
        if (this == ne) {
            return !left.eq(right);
        }
        int compare = left.cmp(right);
        boolean res = compare == 0 ? this == ge || this == le : (compare < 0 ? this == le || this == lt : this == ge || this == gt);
        return res;
    }

    public boolean vCmp(QueryContext ctx, Item left, Item right) throws QueryException {
        left = left.atomize();
        right = right.atomize();
        if (left instanceof Una) {
            left = new Str(((Una)left).str);
        }
        if (right instanceof Una) {
            right = new Str(((Una)right).str);
        }
        boolean res = this.aCmp(ctx, (Atomic)left, (Atomic)right);
        return res;
    }

    public Bool vCmpAsBool(QueryContext ctx, Item left, Item right) throws QueryException {
        if (left == null || right == null) {
            return null;
        }
        boolean res = this.vCmp(ctx, left, right);
        return res ? Bool.TRUE : Bool.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean gCmp(QueryContext ctx, Sequence left, Sequence right) throws QueryException {
        if (left instanceof Item && right instanceof Item) {
            return this.compareLeftAndRightAtomic(ctx, ((Item)left).atomize(), ((Item)right).atomize());
        }
        Iter ls = left.iterate();
        Iter rs = null;
        try {
            Item lItem;
            while ((lItem = ls.next()) != null) {
                Item rItem;
                Atomic lAtomic = lItem.atomize();
                rs = right.iterate();
                while ((rItem = rs.next()) != null) {
                    Atomic rAtomic = rItem.atomize();
                    boolean res = this.compareLeftAndRightAtomic(ctx, lAtomic, rAtomic);
                    if (!res) continue;
                    boolean bl = true;
                    return bl;
                }
                rs.close();
                rs = null;
            }
        }
        finally {
            ls.close();
            if (rs != null) {
                rs.close();
            }
        }
        return false;
    }

    public Bool gCmpAsBool(QueryContext ctx, Sequence left, Sequence right) throws QueryException {
        if (left == null || right == null) {
            return null;
        }
        boolean res = this.gCmp(ctx, left, right);
        return res ? Bool.TRUE : Bool.FALSE;
    }

    private boolean compareLeftAndRightAtomic(QueryContext ctx, Atomic lAtomic, Atomic rAtomic) throws QueryException {
        Type lType = lAtomic.type();
        Type rType = rAtomic.type();
        if (lType.instanceOf(Type.UNA)) {
            if (rType.isNumeric()) {
                lAtomic = Dbl.parse(((Una)lAtomic).str);
            } else if (!rType.instanceOf(Type.UNA) && !rType.instanceOf(Type.STR)) {
                lAtomic = Cast.cast(null, lAtomic, rAtomic.type(), false);
            }
        } else if (rType.instanceOf(Type.UNA)) {
            if (lType.isNumeric()) {
                rAtomic = Dbl.parse(((Una)rAtomic).str);
            } else if (!lType.instanceOf(Type.STR)) {
                rAtomic = Cast.cast(null, rAtomic, lAtomic.type(), false);
            }
        }
        return this.aCmp(ctx, lAtomic, rAtomic);
    }
}

