/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.aggregator;

import io.brackit.query.QueryException;
import io.brackit.query.Tuple;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.expr.Cast;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import io.brackit.query.operator.TupleImpl;
import io.brackit.query.util.ExprUtil;
import io.brackit.query.util.aggregator.Aggregate;
import io.brackit.query.util.aggregator.Aggregator;

public class Grouping {
    final int[] groupSpecs;
    final int[] addAggsSpecs;
    final Aggregate defaultAgg;
    final Aggregate[] additionalAggs;
    volatile int tupleSize = -1;
    Aggregate[] aggSpecs;
    Atomic[] gk;
    Aggregator[] aggs;
    boolean[] onlyFirst;
    int size;

    public Grouping(int[] groupSpecs, int[] addAggsSpecs, Aggregate defaultAgg, Aggregate[] additionalAggs) {
        this.groupSpecs = groupSpecs;
        this.addAggsSpecs = addAggsSpecs;
        this.defaultAgg = defaultAgg;
        this.additionalAggs = additionalAggs;
    }

    public Grouping(int[] groupSpecs, int[] addAggsSpecs, Aggregate defaultAgg, Aggregate[] additionalAggs, int tupleSize) {
        this.groupSpecs = groupSpecs;
        this.addAggsSpecs = addAggsSpecs;
        this.defaultAgg = defaultAgg;
        this.additionalAggs = additionalAggs;
        this.init(tupleSize);
    }

    private synchronized void init(int tupleSize) {
        int pos;
        if (this.tupleSize != -1) {
            return;
        }
        int len = tupleSize + this.additionalAggs.length;
        this.aggSpecs = new Aggregate[len];
        this.aggs = new Aggregator[len];
        this.onlyFirst = new boolean[len];
        for (pos = 0; pos < tupleSize; ++pos) {
            this.aggSpecs[pos] = this.defaultAgg;
        }
        if (this.defaultAgg == Aggregate.SINGLE) {
            for (pos = 0; pos < tupleSize; ++pos) {
                this.onlyFirst[pos] = true;
            }
        }
        for (int pos2 : this.groupSpecs) {
            this.aggSpecs[pos2] = Aggregate.SINGLE;
            this.onlyFirst[pos2] = true;
        }
        for (int pos3 = tupleSize; pos3 < len; ++pos3) {
            this.aggSpecs[pos3] = this.additionalAggs[pos3 - tupleSize];
            this.onlyFirst[pos3] = this.aggSpecs[pos3] == Aggregate.SINGLE;
        }
        this.clear();
        this.tupleSize = tupleSize;
    }

    public int getSize() {
        return this.size;
    }

    public static Atomic[] groupingKeys(int[] groupSpecs, Tuple t) throws QueryException {
        Atomic[] gk = new Atomic[groupSpecs.length];
        for (int i = 0; i < groupSpecs.length; ++i) {
            Item item;
            Sequence seq = t.get(groupSpecs[i]);
            if (seq == null || (item = ExprUtil.asItem(seq)) == null) continue;
            gk[i] = item.atomize();
            if (!gk[i].type().instanceOf(Type.UNA)) continue;
            gk[i] = Cast.cast(null, gk[i], Type.STR);
        }
        return gk;
    }

    public boolean cmp(Atomic[] gk1, Atomic[] gk2) {
        for (int i = 0; i < this.groupSpecs.length; ++i) {
            if (!(gk1[i] == null ? gk2[i] != null : gk2[i] == null || gk1[i].atomicCmp(gk2[i]) != 0)) continue;
            return false;
        }
        return true;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.aggSpecs.length; ++i) {
            if (this.aggs[i] != null) {
                this.aggs[i].clear();
                continue;
            }
            this.aggs[i] = this.aggSpecs[i].aggregator();
        }
        this.size = 0;
    }

    public boolean add(Tuple t) throws QueryException {
        if (this.tupleSize == -1) {
            this.init(t.getSize());
        }
        Atomic[] pgk = this.gk;
        this.gk = Grouping.groupingKeys(this.groupSpecs, t);
        if (pgk != null && !this.cmp(pgk, this.gk)) {
            return false;
        }
        this.addInternal(t);
        return true;
    }

    public boolean add(Atomic[] gk, Tuple t) throws QueryException {
        Atomic[] pgk;
        if (this.tupleSize == -1) {
            this.init(t.getSize());
        }
        if ((pgk = this.gk) != null && !this.cmp(pgk, gk)) {
            return false;
        }
        this.gk = gk;
        this.addInternal(t);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInternal(Tuple t) throws QueryException {
        Aggregator aggregator;
        Sequence s;
        int i;
        for (i = 0; i < this.tupleSize; ++i) {
            if (this.size > 0 && this.onlyFirst[i] || (s = t.get(i)) == null) continue;
            aggregator = this.aggs[i];
            synchronized (aggregator) {
                this.aggs[i].add(s);
                continue;
            }
        }
        for (i = 0; i < this.addAggsSpecs.length; ++i) {
            if (this.size > 0 && this.onlyFirst[this.tupleSize + i] || (s = t.get(this.addAggsSpecs[i])) == null) continue;
            aggregator = this.aggs[this.tupleSize + i];
            synchronized (aggregator) {
                this.aggs[this.tupleSize + i].add(s);
                continue;
            }
        }
        ++this.size;
    }

    public Tuple emit() throws QueryException {
        Sequence[] groupings = new Sequence[this.aggs.length];
        for (int i = 0; i < this.aggs.length; ++i) {
            groupings[i] = this.aggs[i].getAggregate();
        }
        return new TupleImpl(groupings);
    }

    public Tuple singleEmit(Tuple t) throws QueryException {
        if (this.tupleSize == -1) {
            this.init(t.getSize());
        }
        Sequence[] padding = new Sequence[this.additionalAggs.length];
        for (int i = 0; i < this.additionalAggs.length; ++i) {
            padding[i] = this.aggs[this.tupleSize + i].getAggregate();
        }
        return t.concat(padding);
    }
}

