/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.aggregator;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.DTD;
import io.brackit.query.atomic.Dbl;
import io.brackit.query.atomic.Int64;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.atomic.YMD;
import io.brackit.query.expr.Cast;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import io.brackit.query.util.aggregator.Aggregator;

public class SumAvgAggregator
implements Aggregator {
    final boolean avg;
    final Sequence defaultValue;
    long count;
    Atomic sum = null;
    AggType aggType = null;

    public SumAvgAggregator(boolean avg, Sequence defaultValue) {
        this.avg = avg;
        this.defaultValue = defaultValue;
    }

    @Override
    public Sequence getAggregate() throws QueryException {
        if (this.sum == null) {
            return this.avg ? null : this.defaultValue;
        }
        if (this.aggType == AggType.NUMERIC) {
            this.sum = this.numericAggCalc((Numeric)this.sum, this.count);
        } else if (this.aggType == AggType.YMD) {
            this.sum = this.ymdAggCalc((YMD)this.sum, this.count);
        } else if (this.aggType == AggType.DTD) {
            this.sum = this.dtdAggCalc((DTD)this.sum, this.count);
        }
        return this.sum;
    }

    @Override
    public void clear() {
        this.count = 0L;
        this.sum = null;
        this.aggType = null;
    }

    @Override
    public void add(Sequence seq) throws QueryException {
        if (seq == null) {
            return;
        }
        if (seq instanceof Item) {
            this.addItem((Item)seq, this.sum == null);
        } else {
            this.addSequence(seq, this.sum == null);
        }
    }

    private void addSequence(Sequence seq, boolean first) throws QueryException {
        try (Iter in = seq.iterate();){
            if (first) {
                Item item = in.next();
                if (item != null) {
                    this.addItem(item, first);
                } else {
                    return;
                }
            }
            if (this.aggType == AggType.NUMERIC) {
                this.sum = this.numericSum(in, (Numeric)this.sum);
            } else if (this.aggType == AggType.YMD) {
                this.sum = this.ymdSum(in, (YMD)this.sum);
            } else if (this.aggType == AggType.DTD) {
                this.sum = this.dtdSum(in, (DTD)this.sum);
            }
        }
    }

    private void addItem(Item item, boolean first) throws QueryException {
        ++this.count;
        if (!first) {
            if (this.aggType == AggType.NUMERIC) {
                this.sum = this.numericSum((Numeric)this.sum, item);
            } else if (this.aggType == AggType.YMD) {
                this.sum = this.ymdSum((YMD)this.sum, item);
            } else if (this.aggType == AggType.DTD) {
                this.sum = this.dtdSum((DTD)this.sum, item);
            }
        } else {
            this.sum = item.atomize();
            Type type = this.sum.type();
            if (type == Type.UNA) {
                this.sum = Cast.cast(null, this.sum, Type.DBL, false);
                type = Type.DBL;
            }
            if (type.isNumeric()) {
                this.aggType = AggType.NUMERIC;
            } else if (type.instanceOf(Type.YMD)) {
                this.aggType = AggType.YMD;
            } else if (type.instanceOf(Type.DTD)) {
                this.aggType = AggType.DTD;
            } else {
                throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Cannot compute sum/avg for items of type: %s", type);
            }
        }
    }

    private Atomic numericSum(Iter in, Numeric sum) throws QueryException {
        Item item;
        while ((item = in.next()) != null) {
            sum = this.numericSum(sum, item);
            ++this.count;
        }
        return sum;
    }

    private Numeric numericSum(Numeric sum, Item item) throws QueryException {
        Atomic s = item.atomize();
        Type type = s.type();
        if (type == Type.UNA) {
            s = Cast.cast(null, s, Type.DBL, false);
            type = Type.DBL;
        } else if (!(s instanceof Numeric)) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Incompatible types in aggregate function: %s and %s.", sum, type);
        }
        sum = sum.add((Numeric)s);
        return sum;
    }

    private Numeric numericAggCalc(Numeric sum, long count) throws QueryException {
        return this.avg ? sum.div(new Int64(count)) : sum;
    }

    private Atomic ymdSum(Iter in, YMD sum) throws QueryException {
        Item item;
        while ((item = in.next()) != null) {
            sum = this.ymdSum(sum, item);
            ++this.count;
        }
        return sum;
    }

    private YMD ymdSum(YMD sum, Item item) throws QueryException {
        Atomic s = item.atomize();
        Type type = s.type();
        if (type == Type.UNA) {
            s = Cast.cast(null, s, Type.YMD, false);
        } else if (!type.instanceOf(Type.YMD)) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Incompatible types in aggregate function: %s and %s.", Type.YMD, type);
        }
        sum = sum.add((YMD)s);
        return sum;
    }

    private YMD ymdAggCalc(YMD agg, long count) throws QueryException {
        return this.avg ? agg.divide(new Dbl(count)) : agg;
    }

    private Atomic dtdSum(Iter in, DTD sum) throws QueryException {
        Item item;
        while ((item = in.next()) != null) {
            sum = this.dtdSum(sum, item);
            ++this.count;
        }
        return sum;
    }

    private DTD dtdSum(DTD sum, Item item) throws QueryException {
        Atomic s = item.atomize();
        Type type = s.type();
        if (type == Type.UNA) {
            s = Cast.cast(null, s, Type.DTD, false);
        } else if (!type.instanceOf(Type.DTD)) {
            throw new QueryException(ErrorCode.ERR_INVALID_ARGUMENT_TYPE, "Incompatible types in aggregate function: %s and %s.", Type.DTD, type);
        }
        sum = sum.add((DTD)s);
        return sum;
    }

    private DTD dtdAggCalc(DTD agg, long count) throws QueryException {
        return this.avg ? agg.divide(new Dbl(count)) : agg;
    }

    private static enum AggType {
        NUMERIC,
        YMD,
        DTD;

    }
}

