/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.dot;

import io.brackit.query.util.dot.DotEdge;
import io.brackit.query.util.dot.DotNode;
import io.brackit.query.util.log.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class DotContext {
    private static final Logger log = Logger.getLogger(DotContext.class);
    List<DotNode> nodes = new ArrayList<DotNode>();
    List<DotEdge> edges = new ArrayList<DotEdge>();
    Stack<DotNode> stack = new Stack();

    public DotNode addNode(String name) {
        DotNode node = new DotNode(name);
        this.nodes.add(node);
        return node;
    }

    public DotNode pushChildNode(String name) {
        DotNode node = new DotNode(name);
        if (!this.stack.isEmpty()) {
            this.addEdge(this.stack.peek().name, name);
        }
        this.stack.push(node);
        this.nodes.add(node);
        return node;
    }

    public void popChildNode() {
        this.stack.pop();
    }

    public void addEdge(String src, String dest) {
        DotEdge edge = new DotEdge(src, dest);
        this.edges.add(edge);
    }

    public String toDotString() {
        StringBuilder out = new StringBuilder();
        out.append("digraph g {\n");
        out.append("node [shape = plaintext]\n");
        for (DotNode n : this.nodes) {
            out.append(n.toDotString());
            out.append("\n");
        }
        for (DotEdge r : this.edges) {
            out.append(r.toDotString());
            out.append("\n");
        }
        out.append("}");
        return out.toString();
    }

    public void write(File file) {
        try {
            FileWriter fout = new FileWriter(file);
            fout.append(this.toDotString());
            fout.close();
        }
        catch (IOException e) {
            log.error(e);
        }
    }

    static String maskHTML(String valueString) {
        return valueString.replace(">", "&gt;").replace("<", "&lt;").replace("&", "&amp;").replace("'", "&apos;").replace("\"", "&quot;");
    }
}

