/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.dot;

import io.brackit.query.util.log.Logger;
import java.io.File;
import java.io.FileWriter;

public class DotUtil {
    public static final String PLOT_TYPE = "svg";
    private static final Logger log = Logger.getLogger(DotUtil.class);

    public static void drawDotToFile(String dotString, String dir, String name) {
        String svgFile = dir + name + ".svg";
        try {
            File f = File.createTempFile("ast", "dot");
            f.deleteOnExit();
            FileWriter outputStream = new FileWriter(f);
            outputStream.write(dotString);
            outputStream.close();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Drawing AST '%s' with dot to SVG '%s'", name, svgFile));
            }
            Process proc = Runtime.getRuntime().exec("dot -Tsvg -o" + svgFile + " " + String.valueOf(f));
            proc.waitFor();
            f.delete();
        }
        catch (Exception e) {
            log.error(String.format("Creating dot plan '%s' failed.", svgFile), e);
        }
    }
}

