/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.forkjoin;

import io.brackit.query.util.forkjoin.Worker;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;

public abstract class Task {
    private static final AtomicIntegerFieldUpdater<Task> STATUS_CAS = AtomicIntegerFieldUpdater.newUpdater(Task.class, "status");
    private static final AtomicIntegerFieldUpdater<Task> PROCESS_CAS = AtomicIntegerFieldUpdater.newUpdater(Task.class, "process");
    private static final int NOTIFY = -1;
    private static final int NEW = 0;
    private static final int SUCCESS = 1;
    private static final int ERROR = 2;
    volatile Thread join;
    volatile int status = 0;
    volatile int process = 0;
    Throwable throwable;

    public abstract void compute() throws Throwable;

    boolean exec() {
        if (!PROCESS_CAS.compareAndSet(this, 0, 1)) {
            return false;
        }
        try {
            int s = this.status;
            if (s > 0) {
                throw new RuntimeException("Illegal state: " + s);
            }
            this.compute();
            this.setStatus(1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.throwable = e;
            this.setStatus(2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setStatus(int newStatus) {
        int s;
        do {
            if ((s = this.status) <= 0) continue;
            return s;
        } while (!STATUS_CAS.compareAndSet(this, s, newStatus));
        if (s < 0) {
            Task task = this;
            synchronized (task) {
                this.notifyAll();
                if (this.join != null) {
                    LockSupport.unpark(this.join);
                }
            }
        }
        return s;
    }

    public void fork() {
        ((Worker)Thread.currentThread()).fork(this);
    }

    public void join() {
        Thread me = Thread.currentThread();
        if (me instanceof Worker) {
            Worker w = (Worker)me;
            w.join(this, false);
        } else {
            this.externalWaitForFinish();
        }
    }

    public void joinSerial() {
        Thread me = Thread.currentThread();
        if (me instanceof Worker) {
            Worker w = (Worker)me;
            w.join(this, true);
        } else {
            this.externalWaitForFinish();
        }
    }

    public boolean finished() {
        int s = this.status;
        return s > 0;
    }

    public Throwable getError() {
        return this.throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void externalWaitForFinish() {
        int s = this.status;
        if (s <= 0) {
            Task task = this;
            synchronized (task) {
                while ((s = this.status) <= 0) {
                    if (s == 0) {
                        this.setStatus(-1);
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void park(Thread t) {
        int s = this.status;
        if (s <= 0) {
            return;
        }
        Task task = this;
        synchronized (task) {
            if (this.status <= 0) {
                Thread o = this.join;
                this.join = t;
                LockSupport.park();
                if (o != null) {
                    this.join = o;
                    LockSupport.unpark(o);
                }
            }
        }
    }
}

