/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.join;

import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.util.join.FastList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractJoinTable {
    protected final FastList<Sequence[]> sortAndDeduplicate(FastList<TValue> in) throws QueryException {
        in.sort();
        FastList<Sequence[]> out = new FastList<Sequence[]>();
        TValue p = null;
        int inSize = in.getSize();
        for (int i = 0; i < inSize; ++i) {
            TValue v = in.get(i);
            if (p == null || p.pos < v.pos) {
                out.add(v.bindings);
            }
            p = v;
        }
        return out;
    }

    protected abstract void add(Atomic var1, int var2, Sequence[] var3) throws QueryException;

    protected abstract void lookup(FastList<TValue> var1, Atomic var2) throws QueryException;

    protected abstract List<TEntry> entries();

    static class TValue
    implements Comparable<TValue> {
        final Sequence[] bindings;
        final int pos;
        TValue next;

        TValue(Sequence[] bindings, int pos) {
            this.bindings = bindings;
            this.pos = pos;
        }

        @Override
        public int compareTo(TValue o) {
            return Integer.compare(this.pos, o.pos);
        }

        public String toString() {
            return Arrays.toString(this.bindings) + "@" + this.pos;
        }
    }

    static class TEntry
    implements Comparable<TEntry> {
        final TKey key;
        final TValue value;

        public TEntry(TKey key, TValue value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(TEntry o) {
            int res = 0;
            return this.key == o.key || (res = this.key.compareTo(o.key)) != 0 ? res : this.value.compareTo(o.value);
        }
    }

    static class TKey
    implements Comparable<TKey> {
        final Atomic atomic;

        TKey(Atomic atomic) {
            this.atomic = atomic;
        }

        public boolean equals(Object obj) {
            return obj instanceof TKey && ((TKey)obj).atomic.atomicCmp(this.atomic) == 0;
        }

        @Override
        public int compareTo(TKey k) {
            return this.atomic.atomicCmp(k.atomic);
        }

        public int hashCode() {
            return this.atomic.hashCode();
        }

        public String toString() {
            return this.atomic.toString();
        }
    }
}

