/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.join;

import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.util.join.AbstractJoinTable;
import io.brackit.query.util.join.FastList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HashJoinTable
extends AbstractJoinTable {
    private final Map<AbstractJoinTable.TKey, AbstractJoinTable.TValue> table = new HashMap<AbstractJoinTable.TKey, AbstractJoinTable.TValue>();

    @Override
    protected void add(Atomic key, int pos, Sequence[] bindings) throws QueryException {
        AbstractJoinTable.TKey htKey = new AbstractJoinTable.TKey(key);
        AbstractJoinTable.TValue htValue = new AbstractJoinTable.TValue(bindings, pos);
        AbstractJoinTable.TValue chain = this.table.get(htKey);
        if (chain == null) {
            this.table.put(htKey, htValue);
        } else {
            AbstractJoinTable.TValue p = null;
            while (chain != null) {
                if (chain.pos == pos) {
                    return;
                }
                p = chain;
                chain = chain.next;
            }
            p.next = htValue;
        }
    }

    @Override
    protected void lookup(FastList<AbstractJoinTable.TValue> matches, Atomic key) throws QueryException {
        AbstractJoinTable.TKey htKey = new AbstractJoinTable.TKey(key);
        AbstractJoinTable.TValue htValue = this.table.get(htKey);
        if (htValue != null) {
            while (htValue != null) {
                matches.add(htValue);
                htValue = htValue.next;
            }
        }
    }

    @Override
    protected List<AbstractJoinTable.TEntry> entries() {
        ArrayList<AbstractJoinTable.TEntry> entries = new ArrayList<AbstractJoinTable.TEntry>();
        for (Map.Entry<AbstractJoinTable.TKey, AbstractJoinTable.TValue> entry : this.table.entrySet()) {
            AbstractJoinTable.TValue v = entry.getValue();
            while (v != null) {
                entries.add(new AbstractJoinTable.TEntry(entry.getKey(), v));
                v = v.next;
            }
        }
        return entries;
    }
}

