/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.path;

import io.brackit.query.atomic.QNm;
import io.brackit.query.compiler.parser.Tokenizer;
import io.brackit.query.util.path.Path;
import io.brackit.query.util.path.PathException;
import java.util.Map;
import java.util.TreeMap;

public final class PathParser
extends Tokenizer {
    private final Type type;
    private final Path<QNm> p = new Path();
    private Map<String, String> namespaces;

    public PathParser(String s) {
        super(s);
        this.type = Type.XML;
    }

    public PathParser(String s, Type type) {
        super(s);
        this.type = type;
    }

    public Path<QNm> parse() {
        try {
            this.nsPreamble();
            this.attemptS();
            this.startStep();
            while (this.axisStep()) {
            }
            if (this.type == Type.XML) {
                this.attributeStep();
            }
            this.consumeEOF();
            return this.p;
        }
        catch (Tokenizer.TokenizerException e) {
            throw new PathException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    private void nsPreamble() throws Tokenizer.TokenizerException, PathException {
        Tokenizer.Token la = this.laSymSkipS("namespace");
        while (la != null) {
            this.consume(la);
            Tokenizer.Token pfx = this.laNCNameSkipS();
            if (pfx == null) {
                throw (Tokenizer)this.new Tokenizer.MismatchException("NCName");
            }
            String prefix = pfx.toString();
            this.consume(pfx);
            if (!this.attemptSkipS("=")) {
                throw (Tokenizer)this.new Tokenizer.MismatchException("=");
            }
            this.attemptS();
            Tokenizer.Token uriToken = this.laString(false);
            if (uriToken == null) {
                throw (Tokenizer)this.new Tokenizer.MismatchException("URI");
            }
            String uri = uriToken.toString();
            this.consume(uriToken);
            if (!this.attemptSkipS(";")) {
                throw (Tokenizer)this.new Tokenizer.MismatchException(";");
            }
            if (this.namespaces == null) {
                this.namespaces = new TreeMap<String, String>();
            }
            if (this.namespaces.put(prefix, uri) != null) {
                throw new PathException("Multiple declaration of namespace prefix: '%s'", prefix);
            }
            la = this.laSymSkipS("namespace");
        }
    }

    private void startStep() throws PathException {
        if (this.attempt("..")) {
            this.p.parent();
        } else if (this.attempt(".")) {
            this.p.self();
        } else {
            Tokenizer.Token token;
            try {
                token = this.laStringSkipWS(true);
            }
            catch (Tokenizer.TokenizerException e) {
                throw new PathException((Throwable)e, e.getMessage(), new Object[0]);
            }
            if (token != null) {
                this.consume(token);
                this.p.self().child(new QNm(token.string()));
            } else {
                Tokenizer.EQNameToken la = this.laQName();
                if (la != null) {
                    this.consume(la);
                    this.p.self().child(this.expand(la.qname()));
                }
            }
        }
    }

    private boolean axisStep() throws Tokenizer.TokenizerException, PathException {
        return this.parentStep() || this.selfStep() || this.namedStep();
    }

    private boolean parentStep() {
        if (this.attempt("/..")) {
            this.p.parent();
            return true;
        }
        return false;
    }

    private boolean selfStep() {
        if (this.attempt("/.")) {
            this.p.self();
            return true;
        }
        return false;
    }

    private boolean namedStep() throws Tokenizer.TokenizerException, PathException {
        QNm q = null;
        Tokenizer.Token la = this.la("//");
        if (la != null) {
            if (this.type == Type.XML && this.la(la, "@") != null) {
                return false;
            }
            this.consume(la);
            if (this.type == Type.JSON && (la = this.la("[]")) != null) {
                this.consume(la);
                this.p.descendantArray();
                return true;
            }
            if (!this.attempt("*")) {
                if (this.type == Type.XML) {
                    Tokenizer.Token token;
                    try {
                        token = this.laStringSkipWS(true);
                    }
                    catch (Tokenizer.TokenizerException e) {
                        throw new PathException((Throwable)e, e.getMessage(), new Object[0]);
                    }
                    if (token != null) {
                        this.consume(token);
                        q = new QNm(token.string());
                    } else {
                        Tokenizer.EQNameToken ela = this.laQName();
                        if (ela == null) {
                            throw (Tokenizer)this.new Tokenizer.MismatchException("Wildcard", "QName");
                        }
                        this.consume(ela);
                        q = ela.qname();
                    }
                } else {
                    q = this.name();
                }
            }
            if (this.type == Type.XML) {
                this.p.descendant(this.expand(q));
            } else {
                this.p.descendantObjectField(q);
            }
            return true;
        }
        la = this.la("/");
        if (la != null) {
            if (this.type == Type.XML && this.la(la, "@") != null) {
                return false;
            }
            this.consume(la);
            if (this.type == Type.JSON && (la = this.la("[]")) != null) {
                this.consume(la);
                this.p.childArray();
                return true;
            }
            if (!this.attempt("*")) {
                if (this.type == Type.XML) {
                    Tokenizer.Token token;
                    try {
                        token = this.laStringSkipWS(true);
                    }
                    catch (Tokenizer.TokenizerException e) {
                        throw new PathException((Throwable)e, e.getMessage(), new Object[0]);
                    }
                    if (token != null) {
                        this.consume(token);
                        q = new QNm(token.string());
                    } else {
                        Tokenizer.EQNameToken ela = this.laQName();
                        if (ela == null) {
                            throw (Tokenizer)this.new Tokenizer.MismatchException("Wildcard", "QName");
                        }
                        this.consume(ela);
                        q = ela.qname();
                    }
                } else {
                    q = this.name();
                }
            }
            if (this.type == Type.XML) {
                this.p.child(this.expand(q));
            } else {
                this.p.childObjectField(this.expand(q));
            }
            return true;
        }
        return false;
    }

    private QNm name() throws Tokenizer.TokenizerException {
        int pos = this.position();
        StringBuilder pathSegmentName = new StringBuilder(this.scanString(this.position(), '/'));
        int i = 0;
        boolean isEnd = false;
        while (pathSegmentName.toString().endsWith("\\")) {
            if (pos + pathSegmentName.length() + ++i > this.getEnd()) {
                isEnd = true;
                break;
            }
            this.resetTo(pos + pathSegmentName.length() + i);
            pathSegmentName.delete(pathSegmentName.length() - 1, pathSegmentName.length());
            String segment = this.scanString(this.position(), '/');
            if (segment != null) {
                pathSegmentName.append("/");
                pathSegmentName.append(segment);
                continue;
            }
            if (!this.attempt("/") && (this.position() != this.getEnd() || this.getInput()[this.position() - 1] != '/')) continue;
            pathSegmentName.append("/");
        }
        this.resetTo(pos);
        Tokenizer.EQNameToken token = new Tokenizer.EQNameToken(this, pos, isEnd ? this.getEnd() : pos + pathSegmentName.length() + i, null, null, pathSegmentName.toString().replaceAll("\\\\\\[", "[").replaceAll("\\\\\\]", "]"));
        this.consume(token);
        return token.qname();
    }

    private void attributeStep() throws Tokenizer.TokenizerException, PathException {
        QNm q = null;
        if (this.attempt("//@")) {
            if (!this.attempt("*")) {
                Tokenizer.EQNameToken la = this.laQName();
                if (la == null) {
                    throw (Tokenizer)this.new Tokenizer.MismatchException("Wildcard", "QName");
                }
                this.consume(la);
                q = la.qname();
            }
            this.p.descendantAttribute(this.expand(q));
        } else if (this.attempt("/@")) {
            if (!this.attempt("*")) {
                Tokenizer.EQNameToken la = this.laQName();
                if (la == null) {
                    throw (Tokenizer)this.new Tokenizer.MismatchException("Wildcard", "QName");
                }
                this.consume(la);
                q = la.qname();
            }
            this.p.attribute(this.expand(q));
        }
    }

    private String scanString(int pos, char escapeChar) {
        char c;
        int e;
        int s = e = pos;
        int len = 0;
        while (e < this.getEnd() && (c = this.getInput()[e++]) != escapeChar) {
            ++len;
        }
        if (len == 0) {
            return null;
        }
        return new String(this.getInput(), s, len);
    }

    private QNm expand(QNm qname) throws PathException {
        if (this.namespaces == null || qname.getPrefix() == null) {
            return qname;
        }
        String uri = this.namespaces.get(qname.getPrefix());
        if (uri == null) {
            throw new PathException("Undefined namespace prefix: %s", qname.getPrefix());
        }
        return new QNm(uri, qname.getPrefix(), qname.getLocalName());
    }

    public static enum Type {
        JSON,
        XML;

    }
}

