/*
 * Decompiled with CFR 0.152.
 */
package io.brackit.query.util.serialize;

import io.brackit.query.ErrorCode;
import io.brackit.query.QueryException;
import io.brackit.query.atomic.Atomic;
import io.brackit.query.atomic.Null;
import io.brackit.query.atomic.Numeric;
import io.brackit.query.jdm.Item;
import io.brackit.query.jdm.Iter;
import io.brackit.query.jdm.Kind;
import io.brackit.query.jdm.Sequence;
import io.brackit.query.jdm.Type;
import io.brackit.query.jdm.json.Array;
import io.brackit.query.jdm.json.JsonItem;
import io.brackit.query.jdm.json.Object;
import io.brackit.query.jdm.node.Node;
import io.brackit.query.util.serialize.Serializer;
import io.brackit.query.util.serialize.SubtreePrinter;
import java.io.PrintStream;
import java.io.PrintWriter;

public class StringSerializer
implements Serializer {
    private static final String EOL = System.lineSeparator();
    private final PrintWriter out;
    private boolean format;
    private String indent = "  ";

    public StringSerializer(PrintWriter out) {
        this.out = out;
    }

    public StringSerializer(PrintStream out) {
        this.out = new PrintWriter(out);
    }

    public boolean isFormat() {
        return this.format;
    }

    public Serializer setFormat(boolean format) {
        this.format = format;
        return this;
    }

    public String getIndent() {
        return this.indent;
    }

    public Serializer setIndent(String indent) {
        this.indent = indent;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Sequence s) throws QueryException {
        if (s == null) {
            return;
        }
        SubtreePrinter printer = new SubtreePrinter(this.out);
        boolean first = true;
        int depth = 0;
        printer.setPrettyPrint(this.format);
        printer.setIndent(this.indent);
        printer.setAutoFlush(false);
        if (this.printJson(s, printer, depth)) {
            return;
        }
        try (Iter it = s.iterate();){
            Item item;
            while ((item = it.next()) != null) {
                if (item instanceof Node) {
                    Node node = (Node)item;
                    Kind kind = node.getKind();
                    if (kind == Kind.ATTRIBUTE) {
                        throw new QueryException(ErrorCode.ERR_SERIALIZE_ATTRIBUTE_OR_NAMESPACE_NODE);
                    }
                    if (kind == Kind.DOCUMENT && (node = node.getFirstChild()) != null) {
                        while (node.getKind() != Kind.ELEMENT) {
                            node = node.getNextSibling();
                        }
                    }
                    if (node != null) {
                        printer.print(node);
                    }
                    first = true;
                    continue;
                }
                if (item instanceof Atomic) {
                    if (!first) {
                        this.out.write(" ");
                    }
                    if (item instanceof JsonItem) {
                        this.json(item, printer, false, depth);
                    } else {
                        this.out.write(item.toString());
                    }
                    first = false;
                    continue;
                }
                if (item instanceof Array) {
                    if (!first) {
                        this.out.write(" ");
                    }
                    this.json(item, printer, true, depth);
                    first = false;
                    continue;
                }
                if (item instanceof Object) {
                    if (!first) {
                        this.out.write(" ");
                    }
                    this.json(item, printer, false, depth);
                    first = false;
                    continue;
                }
                throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR, "Serialization of item type '%s' not implemented yet.", item.itemType());
            }
        }
        finally {
            printer.flush();
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean printJson(Sequence s, SubtreePrinter printer, int depth) {
        if (s instanceof Array) {
            try {
                this.json(s, printer, true, depth);
                boolean bl = true;
                return bl;
            }
            finally {
                printer.flush();
                this.out.flush();
            }
        }
        if (s instanceof Object) {
            try {
                this.json(s, printer, false, depth);
                boolean bl = true;
                return bl;
            }
            finally {
                printer.flush();
                this.out.flush();
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void json(Sequence sequence, SubtreePrinter p, boolean isArrayContent, int depth) throws QueryException {
        if (sequence == null || sequence instanceof Null) {
            this.out.print("null");
            return;
        }
        if (sequence instanceof Item) {
            if (sequence instanceof Atomic) {
                if (sequence instanceof Numeric) {
                    this.out.write(sequence.toString());
                    return;
                } else if (((Atomic)sequence).type() == Type.BOOL) {
                    this.out.write(sequence.booleanValue() ? "true" : "false");
                    return;
                } else if (((Atomic)sequence).type() == Type.NULL) {
                    this.out.write("null");
                    return;
                } else {
                    this.out.write("\"");
                    this.out.write(sequence.toString());
                    this.out.write("\"");
                }
                return;
            } else if (sequence instanceof Array) {
                Array array = (Array)sequence;
                int arrayDepth = depth + 1;
                this.out.write("[");
                if (this.format && array.len() > 0) {
                    this.out.write(EOL);
                    this.out.write(this.indent(arrayDepth));
                }
                for (int i = 0; i < array.len(); ++i) {
                    if (i > 0) {
                        this.out.append(",");
                        if (this.format) {
                            this.out.append(EOL);
                            this.out.write(this.indent(arrayDepth));
                        }
                    }
                    this.json(array.at(i), p, true, arrayDepth);
                }
                if (this.format && array.len() > 0) {
                    this.out.write(EOL);
                    this.out.write(this.indent(depth));
                }
                this.out.write("]");
                return;
            } else if (sequence instanceof Object) {
                Object object = (Object)sequence;
                int objDepth = depth + 1;
                this.out.write("{");
                if (this.format && object.len() > 0) {
                    this.out.write(EOL);
                    this.out.write(this.indent(objDepth));
                }
                for (int i = 0; i < object.len(); ++i) {
                    if (i > 0) {
                        this.out.write(",");
                        if (this.format) {
                            this.out.write(EOL);
                            this.out.write(this.indent(objDepth));
                        }
                    }
                    this.out.write("\"");
                    this.out.write(object.name(i).stringValue());
                    this.out.write("\":");
                    if (this.format) {
                        this.out.write(" ");
                    }
                    Sequence value = object.value(i);
                    this.json(value, p, value instanceof Array, objDepth);
                }
                if (this.format && object.len() > 0) {
                    this.out.write(EOL);
                    this.out.write(this.indent(objDepth - 1));
                }
                this.out.write("}");
                return;
            } else {
                if (!(sequence instanceof Node)) throw new QueryException(ErrorCode.BIT_DYN_RT_NOT_IMPLEMENTED_YET_ERROR, "Serialization of item type '%sequence' not implemented yet.", ((Item)sequence).itemType());
                Node node = (Node)sequence;
                StringSerializer.serializeNode(node, p, this.out);
            }
            return;
        }
        if (!isArrayContent) {
            this.out.write("[");
            if (this.format && sequence.getSize() > 0) {
                this.out.write(EOL);
                this.out.write(this.indent(depth));
            }
        }
        try (Iter it = sequence.iterate();){
            Item i;
            boolean first = true;
            while ((i = it.next()) != null) {
                if (!first) {
                    this.out.write(",");
                    if (this.format) {
                        this.out.write(EOL);
                        this.out.write(this.indent(depth));
                    }
                }
                this.json(i, p, i instanceof Array, depth);
                first = false;
            }
        }
        if (isArrayContent) return;
        if (this.format && sequence.getSize() > 0) {
            this.out.write(EOL);
        }
        this.out.write("]");
    }

    static void serializeNode(Node<?> sequence, SubtreePrinter p, PrintWriter out) {
        Node<?> node = sequence;
        Kind kind = node.getKind();
        if (kind == Kind.ATTRIBUTE) {
            throw new QueryException(ErrorCode.ERR_SERIALIZE_ATTRIBUTE_OR_NAMESPACE_NODE);
        }
        if (kind == Kind.DOCUMENT) {
            node = node.getFirstChild();
            while (node.getKind() != Kind.ELEMENT) {
                node = node.getNextSibling();
            }
        }
        out.write("\"");
        p.print(node);
        out.write("\"");
    }

    private String indent(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Depth must be >= 0");
        }
        return String.valueOf(this.indent).repeat(depth);
    }
}

