/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access;

import io.sirix.access.DaggerDatabaseManager;
import io.sirix.access.DatabaseConfiguration;
import io.sirix.access.DatabaseManager;
import io.sirix.access.DatabaseType;
import io.sirix.access.User;
import io.sirix.api.Database;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.ResourceSession;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.cache.BufferManager;
import io.sirix.exception.SirixIOException;
import io.sirix.exception.SirixUsageException;
import io.sirix.utils.LogWrapper;
import io.sirix.utils.SirixFiles;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.LoggerFactory;

public final class Databases {
    private static final LogWrapper logger = new LogWrapper(LoggerFactory.getLogger(Databases.class));
    private static final ConcurrentMap<Path, ConcurrentMap<Path, BufferManager>> BUFFER_MANAGERS = new ConcurrentHashMap<Path, ConcurrentMap<Path, BufferManager>>();
    static final DatabaseManager MANAGER = DaggerDatabaseManager.create();

    private Databases() {
        throw new AssertionError((Object)"May not be instantiated!");
    }

    public static DatabaseType getDatabaseType(Path file) {
        return DatabaseConfiguration.deserialize(file).getDatabaseType();
    }

    public static synchronized boolean createXmlDatabase(DatabaseConfiguration dbConfig) {
        return Databases.createTheDatabase(dbConfig.setDatabaseType(DatabaseType.XML));
    }

    public static synchronized boolean createJsonDatabase(DatabaseConfiguration dbConfig) {
        return Databases.createTheDatabase(dbConfig.setDatabaseType(DatabaseType.JSON));
    }

    private static boolean createTheDatabase(DatabaseConfiguration dbConfig) {
        boolean returnVal = true;
        Path databaseFile = dbConfig.getDatabaseFile();
        if (Files.exists(databaseFile, new LinkOption[0]) && !SirixFiles.isDirectoryEmpty(databaseFile)) {
            returnVal = false;
        } else {
            try {
                Files.createDirectories(databaseFile, new FileAttribute[0]);
            }
            catch (IOException | SecurityException | UnsupportedOperationException e) {
                returnVal = false;
            }
            if (returnVal) {
                for (DatabaseConfiguration.DatabasePaths paths : DatabaseConfiguration.DatabasePaths.values()) {
                    Path toCreate = databaseFile.resolve(paths.getFile());
                    if (paths.isFolder()) {
                        try {
                            Files.createDirectory(toCreate, new FileAttribute[0]);
                        }
                        catch (IOException | SecurityException | UnsupportedOperationException e) {
                            returnVal = false;
                        }
                    } else {
                        try {
                            if (!toCreate.getFileName().equals(DatabaseConfiguration.DatabasePaths.LOCK.getFile().getFileName())) {
                                Files.createFile(toCreate, new FileAttribute[0]);
                            }
                        }
                        catch (IOException e) {
                            SirixFiles.recursiveRemove(databaseFile);
                            throw new SirixIOException(e);
                        }
                    }
                    if (!returnVal) break;
                }
            }
            DatabaseConfiguration.serialize(dbConfig);
            if (!returnVal) {
                SirixFiles.recursiveRemove(databaseFile);
            }
        }
        return returnVal;
    }

    public static synchronized void removeDatabase(Path dbFile) {
        if (!MANAGER.sessions().containsAnyEntry(dbFile) && Files.exists(dbFile, new LinkOption[0])) {
            ConcurrentMap bufferManagers;
            if (DatabaseConfiguration.DatabasePaths.compareStructure(dbFile) == 0) {
                DatabaseConfiguration databaseConfiguration = DatabaseConfiguration.deserialize(dbFile);
                DatabaseType databaseType = databaseConfiguration.getDatabaseType();
                switch (databaseType) {
                    case XML: {
                        Databases.removeXmlResources(dbFile);
                        break;
                    }
                    case JSON: {
                        Databases.removeJsonResources(dbFile);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Database type unknown!");
                    }
                }
            }
            if ((bufferManagers = (ConcurrentMap)BUFFER_MANAGERS.remove(dbFile)) != null && !bufferManagers.isEmpty()) {
                bufferManagers.values().forEach(BufferManager::clearAllCaches);
            }
            SirixFiles.recursiveRemove(dbFile);
        }
    }

    private static void removeJsonResources(Path dbFile) {
        try (Database<JsonResourceSession> database = Databases.openJsonDatabase(dbFile);){
            Databases.removeResources(database);
        }
    }

    private static void removeXmlResources(Path dbFile) {
        try (Database<XmlResourceSession> database = Databases.openXmlDatabase(dbFile);){
            Databases.removeResources(database);
        }
    }

    private static void removeResources(Database<?> database) {
        List<Path> resourcePaths = database.listResources();
        for (Path resourcePath : resourcePaths) {
            database.removeResource(resourcePath.getFileName().toString());
        }
    }

    public static synchronized Database<XmlResourceSession> openXmlDatabase(Path file, User user) {
        return Databases.openDatabase(file, user, DatabaseType.XML);
    }

    public static synchronized Database<JsonResourceSession> openJsonDatabase(Path file, User user) {
        return Databases.openDatabase(file, user, DatabaseType.JSON);
    }

    public static synchronized Database<JsonResourceSession> openJsonDatabase(Path file) {
        return Databases.openDatabase(file, Databases.createAdminUser(), DatabaseType.JSON);
    }

    private static User createAdminUser() {
        return new User("admin", UUID.randomUUID());
    }

    public static synchronized Database<XmlResourceSession> openXmlDatabase(Path file) {
        return Databases.openDatabase(file, Databases.createAdminUser(), DatabaseType.XML);
    }

    private static <M extends ResourceSession<R, W>, R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor> Database<M> openDatabase(Path file, User user, DatabaseType databaseType) {
        Objects.requireNonNull(file);
        if (!Files.exists(file, new LinkOption[0])) {
            throw new SirixUsageException("DB could not be opened (since it was not created?) at location", file.toString());
        }
        DatabaseConfiguration dbConfig = DatabaseConfiguration.deserialize(file);
        if (dbConfig == null) {
            throw new IllegalStateException("Configuration may not be null!");
        }
        return databaseType.createDatabase(dbConfig, user);
    }

    public static synchronized boolean existsDatabase(Path dbPath) {
        return Files.exists(dbPath, new LinkOption[0]) && DatabaseConfiguration.DatabasePaths.compareStructure(dbPath) == 0;
    }

    public static ConcurrentMap<Path, BufferManager> getBufferManager(Path databaseFile) {
        return BUFFER_MANAGERS.computeIfAbsent(databaseFile, unused -> new ConcurrentHashMap());
    }
}

