/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.sirix.BinaryEncodingVersion;
import io.sirix.access.DatabaseConfiguration;
import io.sirix.access.trx.node.HashType;
import io.sirix.exception.SirixIOException;
import io.sirix.io.StorageType;
import io.sirix.io.bytepipe.ByteHandler;
import io.sirix.io.bytepipe.ByteHandlerKind;
import io.sirix.io.bytepipe.ByteHandlerPipeline;
import io.sirix.io.bytepipe.LZ4Compressor;
import io.sirix.node.NodeSerializerImpl;
import io.sirix.node.interfaces.RecordSerializer;
import io.sirix.settings.VersioningType;
import io.sirix.utils.OS;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import net.openhft.hashing.LongHashFunction;
import org.checkerframework.checker.index.qual.NonNegative;

public final class ResourceConfiguration {
    private static final StorageType STORAGE;
    private static final VersioningType VERSIONING;
    private static final HashType HASH_TYPE;
    private static final int VERSIONS_TO_RESTORE = 3;
    private static final RecordSerializer NODE_SERIALIZER;
    public static final BinaryEncodingVersion BINARY_ENCODING_VERSION;
    public final StorageType storageType;
    public final VersioningType versioningType;
    public final HashType hashType;
    public final int maxNumberOfRevisionsToRestore;
    public final ByteHandlerPipeline byteHandlePipeline;
    public Path resourcePath;
    private DatabaseConfiguration databaseConfig;
    public final boolean useTextCompression;
    public final boolean withPathSummary;
    public final RecordSerializer recordPersister;
    private long id;
    public final boolean areDeweyIDsStored;
    public final LongHashFunction nodeHashFunction;
    private final String resourceName;
    private final boolean storeChildCount;
    private final boolean storeDiffs;
    private final boolean customCommitTimestamps;
    private final boolean storeNodeHistory;
    private final BinaryEncodingVersion binaryVersion;
    private static final String[] JSONNAMES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Builder newBuilder(String resource) {
        return new Builder(resource);
    }

    private ResourceConfiguration(Builder builder) {
        this.storageType = builder.type;
        this.byteHandlePipeline = builder.byteHandler;
        this.versioningType = builder.revisionKind;
        this.hashType = builder.hashType;
        this.maxNumberOfRevisionsToRestore = builder.maxNumberOfRevisionsToRestore;
        this.useTextCompression = builder.useTextCompression;
        this.withPathSummary = builder.pathSummary;
        this.areDeweyIDsStored = builder.useDeweyIDs;
        this.recordPersister = builder.persistenter;
        this.resourceName = builder.resource;
        this.nodeHashFunction = builder.hashFunction;
        this.storeChildCount = builder.storeChildCount;
        this.storeDiffs = builder.storeDiffs;
        this.customCommitTimestamps = builder.customCommitTimestamps;
        this.storeNodeHistory = builder.storeNodeHistory;
        this.binaryVersion = builder.binaryEncodingVersion;
    }

    public BinaryEncodingVersion getBinaryEncodingVersion() {
        return this.binaryVersion;
    }

    public boolean customCommitTimestamps() {
        return this.customCommitTimestamps;
    }

    ResourceConfiguration setDatabaseConfiguration(DatabaseConfiguration config) {
        this.databaseConfig = Objects.requireNonNull(config);
        this.resourcePath = this.databaseConfig.getDatabaseFile().resolve(DatabaseConfiguration.DatabasePaths.DATA.getFile()).resolve(this.resourceName);
        return this;
    }

    public ResourceConfiguration setID(@NonNegative long id) {
        Preconditions.checkArgument((boolean)true, (Object)"The ID must be >= 0!");
        this.id = id;
        return this;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public long getID() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.storageType, this.versioningType, this.hashType, this.resourcePath, this.databaseConfig});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceConfiguration)) {
            return false;
        }
        ResourceConfiguration other = (ResourceConfiguration)obj;
        return Objects.equals((Object)this.storageType, (Object)other.storageType) && Objects.equals((Object)this.versioningType, (Object)other.versioningType) && Objects.equals((Object)this.hashType, (Object)other.hashType) && Objects.equals(this.resourcePath, other.resourcePath) && Objects.equals(this.databaseConfig, other.databaseConfig);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Resource", (Object)this.resourcePath).add("Type", (Object)this.storageType).add("Revision", (Object)this.versioningType).add("HashKind", (Object)this.hashType).toString();
    }

    public Path getResource() {
        return this.resourcePath;
    }

    public String getName() {
        return this.resourceName;
    }

    public boolean storeDiffs() {
        return this.storeDiffs;
    }

    public Path getConfigFile() {
        return this.resourcePath.resolve(ResourcePaths.CONFIG_BINARY.getPath());
    }

    public boolean storeChildCount() {
        return this.storeChildCount;
    }

    public boolean storeNodeHistory() {
        return this.storeNodeHistory;
    }

    public static void serialize(ResourceConfiguration config) throws SirixIOException {
        Path configFile = config.getConfigFile();
        try (FileWriter fileWriter = new FileWriter(configFile.toFile());
             JsonWriter jsonWriter = new JsonWriter((Writer)fileWriter);){
            jsonWriter.beginObject();
            jsonWriter.name(JSONNAMES[0]).value(config.binaryVersion.name());
            jsonWriter.name(JSONNAMES[1]);
            jsonWriter.beginObject();
            jsonWriter.name(JSONNAMES[2]).value(config.versioningType.name());
            jsonWriter.name(JSONNAMES[3]).value((long)config.maxNumberOfRevisionsToRestore);
            jsonWriter.endObject();
            jsonWriter.name(JSONNAMES[4]);
            jsonWriter.beginArray();
            for (ByteHandler handler : config.byteHandlePipeline.getComponents()) {
                ByteHandlerKind.getKind(handler.getClass()).serialize(handler, jsonWriter);
            }
            jsonWriter.endArray();
            jsonWriter.name(JSONNAMES[5]).value(config.storageType.name());
            jsonWriter.name(JSONNAMES[6]).value(config.hashType.name());
            jsonWriter.name(JSONNAMES[7]).value(config.nodeHashFunction.toString());
            jsonWriter.name(JSONNAMES[8]).value(config.useTextCompression);
            jsonWriter.name(JSONNAMES[9]).value(config.withPathSummary);
            jsonWriter.name(JSONNAMES[10]).value(config.id);
            jsonWriter.name(JSONNAMES[11]).value(config.areDeweyIDsStored);
            jsonWriter.name(JSONNAMES[12]).value(config.recordPersister.getClass().getName());
            jsonWriter.name(JSONNAMES[13]).value(config.storeDiffs);
            jsonWriter.name(JSONNAMES[14]).value(config.customCommitTimestamps);
            jsonWriter.name(JSONNAMES[15]).value(config.storeNodeHistory);
            jsonWriter.name(JSONNAMES[16]).value(config.storeChildCount);
            jsonWriter.endObject();
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
        DatabaseConfiguration.serialize(config.databaseConfig);
    }

    public static ResourceConfiguration deserialize(Path file) throws SirixIOException {
        try {
            Path configFile = file.resolve(ResourcePaths.CONFIG_BINARY.getPath());
            FileReader fileReader = new FileReader(configFile.toFile());
            JsonReader jsonReader = new JsonReader((Reader)fileReader);
            jsonReader.beginObject();
            String name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[0])) {
                throw new AssertionError();
            }
            BinaryEncodingVersion binaryEncodingVersion = BinaryEncodingVersion.valueOf(jsonReader.nextString());
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[1])) {
                throw new AssertionError();
            }
            jsonReader.beginObject();
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[2])) {
                throw new AssertionError();
            }
            VersioningType revisioning = VersioningType.valueOf(jsonReader.nextString());
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[3])) {
                throw new AssertionError();
            }
            int revisionToRestore = jsonReader.nextInt();
            jsonReader.endObject();
            ArrayList<ByteHandler> handlerList = new ArrayList<ByteHandler>();
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[4])) {
                throw new AssertionError();
            }
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                jsonReader.beginObject();
                Class<?> clazzName = Class.forName(jsonReader.nextName());
                handlerList.add(ByteHandlerKind.getKind(clazzName).deserialize(jsonReader));
                jsonReader.endObject();
            }
            jsonReader.endArray();
            ByteHandlerPipeline pipeline = new ByteHandlerPipeline(handlerList.toArray(new ByteHandler[0]));
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[5])) {
                throw new AssertionError();
            }
            StorageType storage = StorageType.valueOf(jsonReader.nextString());
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[6])) {
                throw new AssertionError();
            }
            HashType hashing = HashType.valueOf(jsonReader.nextString());
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[7])) {
                throw new AssertionError();
            }
            jsonReader.nextString();
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[8])) {
                throw new AssertionError();
            }
            boolean compression = jsonReader.nextBoolean();
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[9])) {
                throw new AssertionError();
            }
            boolean pathSummary = jsonReader.nextBoolean();
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[10])) {
                throw new AssertionError();
            }
            int ID = jsonReader.nextInt();
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[11])) {
                throw new AssertionError();
            }
            boolean deweyIDsStored = jsonReader.nextBoolean();
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[12])) {
                throw new AssertionError();
            }
            Class<?> persistenterClazz = Class.forName(jsonReader.nextString());
            Constructor<?> persistenterConstr = persistenterClazz.getConstructors()[0];
            RecordSerializer serializer = (RecordSerializer)persistenterConstr.newInstance(new Object[0]);
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[13])) {
                throw new AssertionError();
            }
            boolean storeDiffs = jsonReader.nextBoolean();
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[14])) {
                throw new AssertionError();
            }
            boolean customCommitTimestamps = jsonReader.nextBoolean();
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[15])) {
                throw new AssertionError();
            }
            boolean storeNodeHistory = jsonReader.nextBoolean();
            name = jsonReader.nextName();
            if (!$assertionsDisabled && !name.equals(JSONNAMES[16])) {
                throw new AssertionError();
            }
            boolean storeChildCount = jsonReader.nextBoolean();
            jsonReader.endObject();
            jsonReader.close();
            fileReader.close();
            DatabaseConfiguration dbConfig = DatabaseConfiguration.deserialize(file.getParent().getParent());
            Builder builder = ResourceConfiguration.newBuilder(file.getFileName().toString());
            builder.binaryEncodingVersion(binaryEncodingVersion).byteHandlerPipeline(pipeline).hashKind(hashing).versioningApproach(revisioning).maxNumberOfRevisionsToRestore(revisionToRestore).storageType(storage).persistenter(serializer).useTextCompression(compression).buildPathSummary(pathSummary).useDeweyIDs(deweyIDsStored).storeDiffs(storeDiffs).storeChildCount(storeChildCount).customCommitTimestamps(customCommitTimestamps).storeNodeHistory(storeNodeHistory);
            ResourceConfiguration config = new ResourceConfiguration(builder);
            config.setDatabaseConfiguration(dbConfig);
            return config.setID(ID);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new SirixIOException(e);
        }
    }

    static {
        boolean bl = $assertionsDisabled = !ResourceConfiguration.class.desiredAssertionStatus();
        STORAGE = OS.isWindows() ? StorageType.FILE_CHANNEL : (OS.is64Bit() ? StorageType.MEMORY_MAPPED : StorageType.FILE_CHANNEL);
        VERSIONING = VersioningType.SLIDING_SNAPSHOT;
        HASH_TYPE = HashType.ROLLING;
        NODE_SERIALIZER = new NodeSerializerImpl();
        BINARY_ENCODING_VERSION = BinaryEncodingVersion.V0;
        JSONNAMES = new String[]{"binaryEncoding", "revisioning", "revisioningClass", "numbersOfRevisiontoRestore", "byteHandlerClasses", "storageKind", "hashKind", "hashFunction", "compression", "pathSummary", "resourceID", "deweyIDsStored", "persistenter", "storeDiffs", "customCommitTimestamps", "storeNodeHistory", "storeChildCount"};
    }

    public static final class Builder {
        public boolean storeDiffs = true;
        private final LongHashFunction hashFunction = LongHashFunction.xx3();
        private StorageType type = STORAGE;
        private VersioningType revisionKind = VERSIONING;
        private HashType hashType = HASH_TYPE;
        private int maxNumberOfRevisionsToRestore = 3;
        private RecordSerializer persistenter = NODE_SERIALIZER;
        private final String resource;
        private boolean useTextCompression;
        private ByteHandlerPipeline byteHandler;
        private boolean useDeweyIDs = false;
        private boolean pathSummary;
        private boolean storeChildCount;
        private boolean customCommitTimestamps;
        private boolean storeNodeHistory;
        private BinaryEncodingVersion binaryEncodingVersion = BINARY_ENCODING_VERSION;

        public Builder(String resource) {
            this.resource = Objects.requireNonNull(resource);
            this.pathSummary = true;
            this.storeChildCount = true;
            this.byteHandler = new ByteHandlerPipeline(new LZ4Compressor());
        }

        public Builder storageType(StorageType type) {
            this.type = Objects.requireNonNull(type);
            return this;
        }

        public Builder persistenter(RecordSerializer persistenter) {
            this.persistenter = Objects.requireNonNull(persistenter);
            return this;
        }

        public Builder storeDiffs(boolean storeDiffs) {
            this.storeDiffs = storeDiffs;
            return this;
        }

        public Builder versioningApproach(VersioningType versioning) {
            this.revisionKind = Objects.requireNonNull(versioning);
            return this;
        }

        public Builder hashKind(HashType hashKind) {
            this.hashType = Objects.requireNonNull(hashKind);
            return this;
        }

        public Builder byteHandlerPipeline(ByteHandlerPipeline byteHandler) {
            this.byteHandler = Objects.requireNonNull(byteHandler);
            return this;
        }

        public Builder maxNumberOfRevisionsToRestore(@NonNegative int revisionsToRestore) {
            Preconditions.checkArgument((revisionsToRestore > 0 ? 1 : 0) != 0, (Object)"revisionsToRestore must be > 0!");
            this.maxNumberOfRevisionsToRestore = revisionsToRestore;
            return this;
        }

        public Builder useDeweyIDs(boolean useDeweyIDs) {
            this.useDeweyIDs = useDeweyIDs;
            return this;
        }

        public Builder useTextCompression(boolean useTextCompression) {
            this.useTextCompression = useTextCompression;
            return this;
        }

        public Builder buildPathSummary(boolean buildPathSummary) {
            this.pathSummary = buildPathSummary;
            return this;
        }

        public Builder storeChildCount(boolean storeChildCount) {
            this.storeChildCount = storeChildCount;
            return this;
        }

        public Builder customCommitTimestamps(boolean customCommitTimestamps) {
            this.customCommitTimestamps = customCommitTimestamps;
            return this;
        }

        public Builder storeNodeHistory(boolean storeNodeHistory) {
            this.storeNodeHistory = storeNodeHistory;
            return this;
        }

        public Builder binaryEncodingVersion(BinaryEncodingVersion binaryEncodingVersion) {
            this.binaryEncodingVersion = Objects.requireNonNull(binaryEncodingVersion);
            return this;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("binaryEncodingVersion", (Object)this.binaryEncodingVersion).add("Type", (Object)this.type).add("RevisionKind", (Object)this.revisionKind).add("HashKind", (Object)this.hashType).add("HashFunction", (Object)this.hashFunction).add("PathSummary", this.pathSummary).add("TextCompression", this.useTextCompression).add("Store diffs", this.storeDiffs).add("Store child count", this.storeChildCount).add("Store node history", this.storeNodeHistory).add("Custom commit timestamps", this.customCommitTimestamps).add("Max number of revisions to restore", this.maxNumberOfRevisionsToRestore).add("Use deweyIDs", this.useDeweyIDs).add("Byte handler pipeline", (Object)this.byteHandler).toString();
        }

        public ResourceConfiguration build() {
            return new ResourceConfiguration(this);
        }
    }

    public static enum ResourcePaths {
        DATA(Paths.get("data", new String[0]), true),
        TRANSACTION_INTENT_LOG(Paths.get("log", new String[0]), true),
        CONFIG_BINARY(Paths.get("ressetting.obj", new String[0]), false),
        INDEXES(Paths.get("indexes", new String[0]), true),
        ENCRYPTION_KEY(Paths.get("encryption", new String[0]), true),
        UPDATE_OPERATIONS(Paths.get("update-operations", new String[0]), true);

        private final Path path;
        private final boolean isFolder;

        private ResourcePaths(Path path, boolean isFolder) {
            this.path = path;
            this.isFolder = isFolder;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isFolder() {
            return this.isFolder;
        }

        public static int compareStructure(Path file) {
            int existing = 0;
            for (ResourcePaths paths : ResourcePaths.values()) {
                Path currentFile = file.resolve(paths.getPath());
                if (!Files.exists(currentFile, new LinkOption[0])) continue;
                ++existing;
            }
            return existing - ResourcePaths.values().length;
        }
    }
}

