/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node;

import io.sirix.api.NodeCursor;
import io.sirix.api.NodeTrx;
import io.sirix.node.SirixDeweyID;

public abstract class AbstractDeweyIDManager<W extends NodeTrx & NodeCursor> {
    private final W nodeTrx;

    protected AbstractDeweyIDManager(W nodeTrx) {
        this.nodeTrx = nodeTrx;
    }

    public SirixDeweyID newFirstChildID() {
        SirixDeweyID id = null;
        if (this.nodeTrx.storeDeweyIDs()) {
            if (((NodeCursor)this.nodeTrx).hasFirstChild()) {
                ((NodeCursor)this.nodeTrx).moveToFirstChild();
                id = SirixDeweyID.newBetween(null, this.nodeTrx.getDeweyID());
            } else {
                id = this.nodeTrx.getDeweyID().getNewChildID();
            }
        }
        return id;
    }

    public SirixDeweyID newLastChildID() {
        SirixDeweyID id = null;
        if (this.nodeTrx.storeDeweyIDs()) {
            if (((NodeCursor)this.nodeTrx).hasLastChild()) {
                ((NodeCursor)this.nodeTrx).moveToLastChild();
                id = SirixDeweyID.newBetween(this.nodeTrx.getDeweyID(), null);
            } else {
                id = this.nodeTrx.getDeweyID().getNewChildID();
            }
        }
        return id;
    }

    public SirixDeweyID newLeftSiblingID() {
        SirixDeweyID id = null;
        if (this.nodeTrx.storeDeweyIDs()) {
            SirixDeweyID currID = this.nodeTrx.getDeweyID();
            if (((NodeCursor)this.nodeTrx).hasLeftSibling()) {
                ((NodeCursor)this.nodeTrx).moveToLeftSibling();
                id = SirixDeweyID.newBetween(this.nodeTrx.getDeweyID(), currID);
                ((NodeCursor)this.nodeTrx).moveToRightSibling();
            } else {
                id = SirixDeweyID.newBetween(null, currID);
            }
        }
        return id;
    }

    public SirixDeweyID newRightSiblingID() {
        SirixDeweyID id = null;
        if (this.nodeTrx.storeDeweyIDs()) {
            SirixDeweyID currID = this.nodeTrx.getDeweyID();
            if (((NodeCursor)this.nodeTrx).hasRightSibling()) {
                ((NodeCursor)this.nodeTrx).moveToRightSibling();
                id = SirixDeweyID.newBetween(currID, this.nodeTrx.getDeweyID());
                ((NodeCursor)this.nodeTrx).moveToLeftSibling();
            } else {
                id = SirixDeweyID.newBetween(currID, null);
            }
        }
        return id;
    }
}

