/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.sirix.access.User;
import io.sirix.access.trx.node.AbstractNodeHashing;
import io.sirix.access.trx.node.AfterCommitState;
import io.sirix.access.trx.node.CommitCredentials;
import io.sirix.access.trx.node.HashType;
import io.sirix.access.trx.node.IndexController;
import io.sirix.access.trx.node.InternalNodeReadOnlyTrx;
import io.sirix.access.trx.node.InternalNodeTrx;
import io.sirix.access.trx.node.InternalResourceSession;
import io.sirix.access.trx.node.NodeFactory;
import io.sirix.access.trx.node.RecordToRevisionsIndex;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.PageTrx;
import io.sirix.api.PostCommitHook;
import io.sirix.api.PreCommitHook;
import io.sirix.axis.IncludeSelf;
import io.sirix.axis.PostOrderAxis;
import io.sirix.diff.DiffTuple;
import io.sirix.exception.SirixIOException;
import io.sirix.exception.SirixThreadedException;
import io.sirix.exception.SirixUsageException;
import io.sirix.index.IndexDef;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.index.path.summary.PathSummaryWriter;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.page.UberPage;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractNodeTrxImpl<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor, NF extends NodeFactory, N extends ImmutableNode, IN extends InternalNodeReadOnlyTrx<N>>
implements NodeReadOnlyTrx,
InternalNodeTrx<W>,
NodeCursor {
    private final int maxNodeCount;
    private final ScheduledExecutorService commitScheduler;
    private final HashType hashType;
    protected final IN nodeReadOnlyTrx;
    private final R typeSpecificTrx;
    protected final InternalResourceSession<R, W> resourceSession;
    protected PathSummaryWriter<R> pathSummaryWriter;
    protected NF nodeFactory;
    protected final boolean buildPathSummary;
    protected final SortedMap<SirixDeweyID, DiffTuple> updateOperationsOrdered;
    protected final Map<Long, DiffTuple> updateOperationsUnordered;
    protected final @Nullable Lock lock;
    private volatile State state;
    private final AfterCommitState afterCommitState;
    private long modificationCount;
    protected PageTrx pageTrx;
    protected IndexController<R, W> indexController;
    protected final RecordToRevisionsIndex nodeToRevisionsIndex;
    private final List<PreCommitHook> preCommitHooks = new ArrayList<PreCommitHook>();
    private final List<PostCommitHook> postCommitHooks = new ArrayList<PostCommitHook>();
    protected AbstractNodeHashing<N, R> nodeHashing;

    protected AbstractNodeTrxImpl(ThreadFactory threadFactory, HashType hashType, IN nodeReadOnlyTrx, R typeSpecificTrx, InternalResourceSession<R, W> resourceManager, AfterCommitState afterCommitState, AbstractNodeHashing<N, R> nodeHashing, PathSummaryWriter<R> pathSummaryWriter, NF nodeFactory, RecordToRevisionsIndex nodeToRevisionsIndex, @Nullable Lock transactionLock, Duration afterCommitDelay, @NonNegative int maxNodeCount) {
        Preconditions.checkArgument((maxNodeCount >= 0 ? 1 : 0) != 0, (Object)"Negative argument for maxNodeCount is not accepted.");
        Preconditions.checkArgument((!afterCommitDelay.isNegative() ? 1 : 0) != 0, (Object)"After commit delay cannot be negative");
        this.commitScheduler = Executors.newScheduledThreadPool(1, threadFactory);
        this.hashType = hashType;
        this.nodeReadOnlyTrx = (InternalNodeReadOnlyTrx)Objects.requireNonNull(nodeReadOnlyTrx);
        this.typeSpecificTrx = typeSpecificTrx;
        this.resourceSession = Objects.requireNonNull(resourceManager);
        this.lock = transactionLock;
        this.afterCommitState = Objects.requireNonNull(afterCommitState);
        this.nodeHashing = Objects.requireNonNull(nodeHashing);
        this.buildPathSummary = resourceManager.getResourceConfig().withPathSummary;
        this.nodeFactory = (NodeFactory)Objects.requireNonNull(nodeFactory);
        this.pathSummaryWriter = pathSummaryWriter;
        this.indexController = resourceManager.getWtxIndexController(nodeReadOnlyTrx.getPageTrx().getRevisionNumber());
        this.nodeToRevisionsIndex = Objects.requireNonNull(nodeToRevisionsIndex);
        this.updateOperationsOrdered = new TreeMap<SirixDeweyID, DiffTuple>();
        this.updateOperationsUnordered = new HashMap<Long, DiffTuple>();
        this.pageTrx = (PageTrx)nodeReadOnlyTrx.getPageTrx();
        this.maxNodeCount = maxNodeCount;
        this.modificationCount = 0L;
        this.state = State.RUNNING;
        if (!afterCommitDelay.isZero()) {
            this.commitScheduler.scheduleWithFixedDelay(() -> this.commit("autoCommit", null), afterCommitDelay.toMillis(), afterCommitDelay.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    protected abstract W self();

    protected void assertRunning() {
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("Transaction state is not running: " + String.valueOf((Object)this.state));
        }
    }

    @Override
    public Optional<User> getUser() {
        return this.getResourceSession().getUser();
    }

    @Override
    public W setBulkInsertion(boolean bulkInsertion) {
        this.nodeHashing.setBulkInsert(bulkInsertion);
        return this.self();
    }

    protected N getCurrentNode() {
        return this.nodeReadOnlyTrx.getCurrentNode();
    }

    protected void postOrderTraversalHashes() {
        PostOrderAxis axis = new PostOrderAxis(this, IncludeSelf.YES);
        while (axis.hasNext()) {
            axis.nextLong();
            this.nodeHashing.addHashAndDescendantCount();
        }
    }

    @Override
    public void adaptHashesInPostorderTraversal() {
        if (this.hashType != HashType.NONE) {
            long nodeKey = this.getCurrentNode().getNodeKey();
            this.postOrderTraversalHashes();
            N startNode = this.getCurrentNode();
            this.moveToParent();
            while (this.getCurrentNode().hasParent()) {
                this.moveToParent();
                this.nodeHashing.addParentHash((ImmutableNode)startNode);
            }
            this.moveTo(nodeKey);
        }
    }

    protected void runLocked(Runnable runnable) {
        if (this.lock != null) {
            this.lock.lock();
        }
        runnable.run();
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    public W commit(@Nullable String commitMessage, @Nullable Instant commitTimestamp) {
        this.nodeReadOnlyTrx.assertNotClosed();
        if (commitTimestamp != null && !this.resourceSession.getResourceConfig().customCommitTimestamps()) {
            throw new IllegalStateException("Custom commit timestamps are not enabled for the resource.");
        }
        this.runLocked(() -> {
            this.state = State.COMMITTING;
            for (PreCommitHook hook : this.preCommitHooks) {
                hook.preCommit(this);
            }
            this.modificationCount = 0L;
            int preCommitRevision = this.getRevisionNumber();
            UberPage uberPage = this.pageTrx.commit(commitMessage, commitTimestamp);
            this.resourceSession.setLastCommittedUberPage(uberPage);
            if (this.resourceSession.getResourceConfig().storeDiffs()) {
                this.serializeUpdateDiffs(preCommitRevision);
            }
            if (this.afterCommitState == AfterCommitState.KEEP_OPEN) {
                this.reInstantiate(this.getId(), preCommitRevision);
                this.state = State.RUNNING;
            } else {
                this.state = State.COMMITTED;
            }
        });
        for (PostCommitHook hook : this.postCommitHooks) {
            hook.postCommit(this);
        }
        return this.self();
    }

    protected void checkAccessAndCommit() {
        this.nodeReadOnlyTrx.assertNotClosed();
        this.assertRunning();
        ++this.modificationCount;
        this.intermediateCommitIfRequired();
    }

    private void intermediateCommitIfRequired() {
        this.nodeReadOnlyTrx.assertNotClosed();
        if (this.maxNodeCount > 0 && this.modificationCount > (long)this.maxNodeCount) {
            this.commit("autoCommit");
        }
    }

    protected abstract void serializeUpdateDiffs(int var1);

    private void reInstantiate(@NonNegative long trxID, @NonNegative int revNumber) {
        this.resourceSession.closeNodePageWriteTransaction(this.getId());
        this.pageTrx = this.resourceSession.createPageTransaction(trxID, revNumber, revNumber, InternalResourceSession.Abort.NO, true);
        this.nodeReadOnlyTrx.setPageReadTransaction(null);
        this.nodeReadOnlyTrx.setPageReadTransaction(this.pageTrx);
        this.resourceSession.setNodePageWriteTransaction(this.getId(), this.pageTrx);
        this.nodeFactory = this.reInstantiateNodeFactory(this.pageTrx);
        boolean isBulkInsert = this.nodeHashing.isBulkInsert();
        this.nodeHashing = this.reInstantiateNodeHashing(this.pageTrx);
        this.nodeHashing.setBulkInsert(isBulkInsert);
        this.updateOperationsUnordered.clear();
        this.updateOperationsOrdered.clear();
        this.reInstantiateIndexes();
    }

    protected abstract AbstractNodeHashing<N, R> reInstantiateNodeHashing(PageTrx var1);

    protected abstract NF reInstantiateNodeFactory(PageTrx var1);

    private void reInstantiateIndexes() {
        if (this.buildPathSummary) {
            this.pathSummaryWriter = new PathSummaryWriter<R>(this.pageTrx, this.resourceSession, (NodeFactory)this.nodeFactory, this.typeSpecificTrx);
        }
        Set<IndexDef> indexDefs = this.indexController.getIndexes().getIndexDefs();
        this.indexController = this.resourceSession.getWtxIndexController(this.nodeReadOnlyTrx.getPageTrx().getRevisionNumber());
        this.indexController.createIndexListeners(indexDefs, this.self());
        this.nodeToRevisionsIndex.setPageTrx(this.pageTrx);
    }

    public synchronized W rollback() {
        if (this.lock != null) {
            this.lock.lock();
        }
        this.nodeReadOnlyTrx.assertNotClosed();
        this.modificationCount = 0L;
        long trxID = this.getId();
        int revision = this.getRevisionNumber();
        int revNumber = this.pageTrx.getUberPage().isBootstrap() ? 0 : revision - 1;
        UberPage uberPage = this.pageTrx.rollback();
        this.resourceSession.setLastCommittedUberPage(uberPage);
        this.resourceSession.closeNodePageWriteTransaction(this.getId());
        this.nodeReadOnlyTrx.setPageReadTransaction(null);
        this.removeCommitFile();
        this.pageTrx = this.resourceSession.createPageTransaction(trxID, revNumber, revNumber, InternalResourceSession.Abort.YES, true);
        this.nodeReadOnlyTrx.setPageReadTransaction(this.pageTrx);
        this.resourceSession.setNodePageWriteTransaction(this.getId(), this.pageTrx);
        this.nodeFactory = this.reInstantiateNodeFactory(this.pageTrx);
        this.reInstantiateIndexes();
        if (this.lock != null) {
            this.lock.unlock();
        }
        return this.self();
    }

    private void removeCommitFile() {
        try {
            Files.deleteIfExists(this.resourceSession.getCommitFile());
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public W revertTo(int revision) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.nodeReadOnlyTrx.assertNotClosed();
            this.resourceSession.assertAccess(revision);
            long trxID = this.getId();
            int revNumber = this.getRevisionNumber();
            this.resourceSession.closeNodePageWriteTransaction(this.getId());
            this.pageTrx = this.resourceSession.createPageTransaction(trxID, revision, revNumber - 1, InternalResourceSession.Abort.NO, true);
            this.nodeReadOnlyTrx.setPageReadTransaction(null);
            this.nodeReadOnlyTrx.setPageReadTransaction(this.pageTrx);
            this.resourceSession.setNodePageWriteTransaction(this.getId(), this.pageTrx);
            this.nodeHashing = this.reInstantiateNodeHashing(this.pageTrx);
            this.nodeFactory = this.reInstantiateNodeFactory(this.pageTrx);
            this.reInstantiateIndexes();
            this.modificationCount = 0L;
            this.moveToDocumentRoot();
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
        return this.self();
    }

    public W addPreCommitHook(PreCommitHook hook) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.preCommitHooks.add(Objects.requireNonNull(hook));
            W w = this.self();
            return w;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    public W addPostCommitHook(PostCommitHook hook) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.postCommitHooks.add(Objects.requireNonNull(hook));
            W w = this.self();
            return w;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    public W truncateTo(int revision) {
        this.nodeReadOnlyTrx.assertNotClosed();
        return this.self();
    }

    @Override
    public PathSummaryReader getPathSummary() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            PathSummaryReader pathSummaryReader = this.pathSummaryWriter.getPathSummary();
            return pathSummaryReader;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public PageTrx getPageWtx() {
        this.nodeReadOnlyTrx.assertNotClosed();
        return (PageTrx)this.nodeReadOnlyTrx.getPageTrx();
    }

    @Override
    public Optional<User> getUserOfRevisionToRepresent() {
        return this.nodeReadOnlyTrx.getUser();
    }

    @Override
    public synchronized void close() {
        this.runLocked(() -> {
            if (!this.isClosed()) {
                if (this.modificationCount > 0L) {
                    throw new SirixUsageException(new String[]{"Must commit/rollback transaction first!"});
                }
                long trxId = this.getId();
                this.nodeReadOnlyTrx.close();
                this.resourceSession.closeWriteTransaction(trxId);
                this.removeCommitFile();
                this.pathSummaryWriter = null;
                this.nodeFactory = null;
                this.commitScheduler.shutdown();
                try {
                    this.commitScheduler.awaitTermination(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new SirixThreadedException(e);
                }
            }
        });
    }

    @Override
    public CommitCredentials getCommitCredentials() {
        this.nodeReadOnlyTrx.assertNotClosed();
        return this.nodeReadOnlyTrx.getCommitCredentials();
    }

    @Override
    public SirixDeweyID getDeweyID() {
        this.nodeReadOnlyTrx.assertNotClosed();
        return this.getCurrentNode().getDeweyID();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNodeTrxImpl that = (AbstractNodeTrxImpl)o;
        return this.nodeReadOnlyTrx.equals(that.nodeReadOnlyTrx);
    }

    public int hashCode() {
        return Objects.hash(this.nodeReadOnlyTrx);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("hashType", (Object)this.hashType).add("nodeReadOnlyTrx", this.nodeReadOnlyTrx).toString();
    }

    private static enum State {
        RUNNING,
        COMMITTING,
        COMMITTED,
        CLOSED;

    }
}

