/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node;

import io.sirix.api.PageTrx;
import io.sirix.index.IndexType;
import io.sirix.node.RevisionReferencesNode;
import java.util.Objects;

public final class RecordToRevisionsIndex {
    private PageTrx pageTrx;

    public RecordToRevisionsIndex(PageTrx pageTrx) {
        this.pageTrx = Objects.requireNonNull(pageTrx);
    }

    public void setPageTrx(PageTrx pageTrx) {
        this.pageTrx = pageTrx;
    }

    public void addToRecordToRevisionsIndex(long recordKey) {
        int[] revisions = new int[]{this.pageTrx.getRevisionNumber()};
        this.pageTrx.createRecord(new RevisionReferencesNode(recordKey, revisions), IndexType.RECORD_TO_REVISIONS, 0);
    }

    public void addRevisionToRecordToRevisionsIndex(long recordKey) {
        RevisionReferencesNode revisionReferencesNode = (RevisionReferencesNode)this.pageTrx.prepareRecordForModification(recordKey, IndexType.RECORD_TO_REVISIONS, 0);
        revisionReferencesNode.addRevision(this.pageTrx.getRevisionNumber());
    }
}

