/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node.json;

import io.brackit.query.atomic.QNm;
import io.brackit.query.util.path.Path;
import io.brackit.query.util.path.PathException;
import io.brackit.query.util.path.PathParser;
import io.sirix.access.trx.node.AbstractIndexController;
import io.sirix.api.PageTrx;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.api.visitor.JsonNodeVisitor;
import io.sirix.index.ChangeListener;
import io.sirix.index.IndexBuilder;
import io.sirix.index.IndexDef;
import io.sirix.index.Indexes;
import io.sirix.index.cas.json.JsonCASIndexImpl;
import io.sirix.index.name.json.JsonNameIndexImpl;
import io.sirix.index.path.PathFilter;
import io.sirix.index.path.json.JsonPCRCollector;
import io.sirix.index.path.json.JsonPathIndexImpl;
import io.sirix.index.path.summary.PathSummaryReader;
import java.util.HashSet;
import java.util.Set;

public final class JsonIndexController
extends AbstractIndexController<JsonNodeReadOnlyTrx, JsonNodeTrx> {
    public JsonIndexController() {
        super(new Indexes(), new HashSet<ChangeListener>(), new JsonPathIndexImpl(), new JsonCASIndexImpl(), new JsonNameIndexImpl());
    }

    @Override
    protected Path<QNm> parsePath(String path) {
        return Path.parse((String)path, (PathParser.Type)PathParser.Type.JSON);
    }

    public JsonIndexController createIndexes(Set<IndexDef> indexDefs, JsonNodeTrx nodeWriteTrx) {
        IndexBuilder.build(nodeWriteTrx, this.createIndexBuilders(indexDefs, nodeWriteTrx));
        this.createIndexListeners(indexDefs, nodeWriteTrx);
        return this;
    }

    Set<JsonNodeVisitor> createIndexBuilders(Set<IndexDef> indexDefs, JsonNodeTrx nodeWriteTrx) {
        HashSet<JsonNodeVisitor> indexBuilders = new HashSet<JsonNodeVisitor>(indexDefs.size());
        for (IndexDef indexDef : indexDefs) {
            switch (indexDef.getType()) {
                case PATH: {
                    indexBuilders.add(this.createPathIndexBuilder(nodeWriteTrx.getPageWtx(), nodeWriteTrx.getPathSummary(), indexDef));
                    break;
                }
                case CAS: {
                    indexBuilders.add(this.createCASIndexBuilder(nodeWriteTrx, nodeWriteTrx.getPageWtx(), nodeWriteTrx.getPathSummary(), indexDef));
                    break;
                }
                case NAME: {
                    indexBuilders.add(this.createNameIndexBuilder(nodeWriteTrx.getPageWtx(), indexDef));
                }
            }
        }
        return indexBuilders;
    }

    @Override
    public PathFilter createPathFilter(Set<String> queryString, JsonNodeReadOnlyTrx rtx) throws PathException {
        HashSet<Path<QNm>> paths = new HashSet<Path<QNm>>(queryString.size());
        for (String path : queryString) {
            paths.add((Path<QNm>)Path.parse((String)path, (PathParser.Type)PathParser.Type.JSON));
        }
        return new PathFilter(paths, new JsonPCRCollector(rtx));
    }

    private JsonNodeVisitor createPathIndexBuilder(PageTrx pageWriteTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        return (JsonNodeVisitor)this.pathIndex.createBuilder(pageWriteTrx, pathSummaryReader, indexDef);
    }

    private JsonNodeVisitor createCASIndexBuilder(JsonNodeReadOnlyTrx nodeReadTrx, PageTrx pageWriteTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        return (JsonNodeVisitor)this.casIndex.createBuilder(nodeReadTrx, pageWriteTrx, pathSummaryReader, indexDef);
    }

    private JsonNodeVisitor createNameIndexBuilder(PageTrx pageWriteTrx, IndexDef indexDef) {
        return (JsonNodeVisitor)this.nameIndex.createBuilder(pageWriteTrx, indexDef);
    }
}

