/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node.json;

import io.brackit.query.atomic.QNm;
import io.sirix.access.trx.node.json.JsonNodeFactory;
import io.sirix.api.PageTrx;
import io.sirix.index.IndexType;
import io.sirix.index.path.summary.PathNode;
import io.sirix.node.DeweyIDNode;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NameNodeDelegate;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.delegates.StructNodeDelegate;
import io.sirix.node.delegates.ValueNodeDelegate;
import io.sirix.node.json.ArrayNode;
import io.sirix.node.json.BooleanNode;
import io.sirix.node.json.NullNode;
import io.sirix.node.json.NumberNode;
import io.sirix.node.json.ObjectBooleanNode;
import io.sirix.node.json.ObjectKeyNode;
import io.sirix.node.json.ObjectNode;
import io.sirix.node.json.ObjectNullNode;
import io.sirix.node.json.ObjectNumberNode;
import io.sirix.node.json.ObjectStringNode;
import io.sirix.node.json.StringNode;
import io.sirix.page.PathSummaryPage;
import io.sirix.settings.Fixed;
import io.sirix.utils.Compression;
import io.sirix.utils.NamePageHash;
import java.util.Objects;
import net.openhft.hashing.LongHashFunction;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

final class JsonNodeFactoryImpl
implements JsonNodeFactory {
    private final LongHashFunction hashFunction;
    private final PageTrx pageTrx;
    private final int revisionNumber;

    JsonNodeFactoryImpl(LongHashFunction hashFunction, PageTrx pageTrx) {
        this.hashFunction = Objects.requireNonNull(hashFunction);
        this.pageTrx = Objects.requireNonNull(pageTrx);
        this.revisionNumber = pageTrx.getRevisionNumber();
    }

    @Override
    public PathNode createPathNode(@NonNegative long parentKey, long leftSibKey, long rightSibKey, @NonNull QNm name, @NonNull NodeKind kind, @NonNegative int level) {
        int uriKey = -1;
        int prefixKey = -1;
        int localName = name.getLocalName() != null && !name.getLocalName().isEmpty() ? NamePageHash.generateHashForString(name.getLocalName()) : -1;
        NodeDelegate nodeDel = new NodeDelegate(((PathSummaryPage)this.pageTrx.getActualRevisionRootPage().getPathSummaryPageReference().getPage()).getMaxNodeKey(0) + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, (SirixDeweyID)null);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        NameNodeDelegate nameDel = new NameNodeDelegate(nodeDel, -1, -1, localName, 0L);
        return this.pageTrx.createRecord(new PathNode(name, nodeDel, structDel, nameDel, kind, 1, level), IndexType.PATH_SUMMARY, 0);
    }

    @Override
    public ArrayNode createJsonArrayNode(long parentKey, long leftSibKey, long rightSibKey, long pathNodeKey, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return this.pageTrx.createRecord(new ArrayNode(structDel, pathNodeKey), IndexType.DOCUMENT, -1);
    }

    @Override
    public ObjectNode createJsonObjectNode(long parentKey, long leftSibKey, long rightSibKey, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return this.pageTrx.createRecord(new ObjectNode(structDel), IndexType.DOCUMENT, -1);
    }

    @Override
    public NullNode createJsonNullNode(long parentKey, long leftSibKey, long rightSibKey, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return this.pageTrx.createRecord(new NullNode(structDel), IndexType.DOCUMENT, -1);
    }

    @Override
    public ObjectKeyNode createJsonObjectKeyNode(long parentKey, long leftSibKey, long rightSibKey, long pathNodeKey, String name, long objectValueKey, SirixDeweyID id) {
        int localNameKey = this.pageTrx.createNameKey(name, NodeKind.OBJECT_KEY);
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, objectValueKey, Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return this.pageTrx.createRecord(new ObjectKeyNode(structDel, localNameKey, name, pathNodeKey), IndexType.DOCUMENT, -1);
    }

    @Override
    public StringNode createJsonStringNode(long parentKey, long leftSibKey, long rightSibKey, byte[] value, boolean doCompress, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        boolean compression = doCompress && value.length > 10;
        byte[] compressedValue = compression ? Compression.compress(value, 2) : value;
        ValueNodeDelegate valDel = new ValueNodeDelegate(nodeDel, compressedValue, compression);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return this.pageTrx.createRecord(new StringNode(valDel, structDel), IndexType.DOCUMENT, -1);
    }

    @Override
    public BooleanNode createJsonBooleanNode(long parentKey, long leftSibKey, long rightSibKey, boolean boolValue, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return this.pageTrx.createRecord(new BooleanNode(boolValue, structDel), IndexType.DOCUMENT, -1);
    }

    @Override
    public NumberNode createJsonNumberNode(long parentKey, long leftSibKey, long rightSibKey, Number value, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), rightSibKey, leftSibKey, 0L, 0L);
        return this.pageTrx.createRecord(new NumberNode(value, structDel), IndexType.DOCUMENT, -1);
    }

    @Override
    public ObjectNullNode createJsonObjectNullNode(long parentKey, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, 0L);
        return this.pageTrx.createRecord(new ObjectNullNode(structDel), IndexType.DOCUMENT, -1);
    }

    @Override
    public ObjectStringNode createJsonObjectStringNode(long parentKey, byte[] value, boolean doCompress, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        boolean compression = doCompress && value.length > 40;
        byte[] compressedValue = compression ? Compression.compress(value, 9) : value;
        ValueNodeDelegate valDel = new ValueNodeDelegate(nodeDel, compressedValue, compression);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, 0L);
        return this.pageTrx.createRecord(new ObjectStringNode(valDel, structDel), IndexType.DOCUMENT, -1);
    }

    @Override
    public ObjectBooleanNode createJsonObjectBooleanNode(long parentKey, boolean boolValue, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, 0L);
        return this.pageTrx.createRecord(new ObjectBooleanNode(boolValue, structDel), IndexType.DOCUMENT, -1);
    }

    @Override
    public ObjectNumberNode createJsonObjectNumberNode(long parentKey, Number value, SirixDeweyID id) {
        NodeDelegate nodeDel = new NodeDelegate(this.pageTrx.getActualRevisionRootPage().getMaxNodeKeyInDocumentIndex() + 1L, parentKey, this.hashFunction, -1, this.revisionNumber, id);
        StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), 0L, 0L);
        return this.pageTrx.createRecord(new ObjectNumberNode(value, structDel), IndexType.DOCUMENT, -1);
    }

    @Override
    public DeweyIDNode createDeweyIdNode(long nodeKey, @NonNull SirixDeweyID id) {
        return this.pageTrx.createRecord(new DeweyIDNode(nodeKey, id), IndexType.DEWEYID_TO_RECORDID, 0);
    }
}

