/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import io.brackit.query.atomic.QNm;
import io.brackit.query.jdm.Item;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.trx.node.AbstractNodeHashing;
import io.sirix.access.trx.node.AbstractNodeTrxImpl;
import io.sirix.access.trx.node.AfterCommitState;
import io.sirix.access.trx.node.IndexController;
import io.sirix.access.trx.node.InternalResourceSession;
import io.sirix.access.trx.node.RecordToRevisionsIndex;
import io.sirix.access.trx.node.json.ForwardingJsonNodeReadOnlyTrx;
import io.sirix.access.trx.node.json.InternalJsonNodeReadOnlyTrx;
import io.sirix.access.trx.node.json.InternalJsonNodeTrx;
import io.sirix.access.trx.node.json.JsonDeweyIDManager;
import io.sirix.access.trx.node.json.JsonNodeFactory;
import io.sirix.access.trx.node.json.JsonNodeFactoryImpl;
import io.sirix.access.trx.node.json.JsonNodeHashing;
import io.sirix.access.trx.node.json.objectvalue.ObjectRecordValue;
import io.sirix.api.PageTrx;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.json.JsonNodeTrx;
import io.sirix.api.json.JsonResourceSession;
import io.sirix.axis.PostOrderAxis;
import io.sirix.diff.DiffDepth;
import io.sirix.diff.DiffFactory;
import io.sirix.diff.DiffTuple;
import io.sirix.diff.JsonDiffSerializer;
import io.sirix.exception.SirixUsageException;
import io.sirix.index.IndexType;
import io.sirix.index.path.summary.PathSummaryWriter;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.immutable.json.ImmutableArrayNode;
import io.sirix.node.immutable.json.ImmutableObjectKeyNode;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.interfaces.immutable.ImmutableJsonNode;
import io.sirix.node.interfaces.immutable.ImmutableNameNode;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.node.json.AbstractBooleanNode;
import io.sirix.node.json.AbstractNullNode;
import io.sirix.node.json.AbstractNumberNode;
import io.sirix.node.json.AbstractStringNode;
import io.sirix.node.json.ArrayNode;
import io.sirix.node.json.BooleanNode;
import io.sirix.node.json.NullNode;
import io.sirix.node.json.NumberNode;
import io.sirix.node.json.ObjectKeyNode;
import io.sirix.node.json.ObjectNode;
import io.sirix.node.json.StringNode;
import io.sirix.page.NamePage;
import io.sirix.service.InsertPosition;
import io.sirix.service.json.shredder.JsonItemShredder;
import io.sirix.service.json.shredder.JsonShredder;
import io.sirix.settings.Constants;
import io.sirix.settings.Fixed;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.hashing.LongHashFunction;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JsonNodeTrxImpl
extends AbstractNodeTrxImpl<JsonNodeReadOnlyTrx, JsonNodeTrx, JsonNodeFactory, ImmutableNode, InternalJsonNodeReadOnlyTrx>
implements InternalJsonNodeTrx,
ForwardingJsonNodeReadOnlyTrx {
    private final Bytes<ByteBuffer> bytes = Bytes.elasticHeapByteBuffer();
    private final String databaseName;
    private final JsonDeweyIDManager deweyIDManager;
    private final boolean useTextCompression;
    private final LongHashFunction hashFunction;
    private final boolean storeChildCount;
    private final boolean storeNodeHistory;
    private boolean canRemoveValue;
    private final boolean isAutoCommitting;
    private int beforeBulkInsertionRevisionNumber;
    private static final String INSERT_NOT_ALLOWED_SINCE_PARENT_NOT_IN_AN_ARRAY_NODE = "Insert is not allowed if parent node is not an array node!";

    JsonNodeTrxImpl(String databaseName, InternalResourceSession<JsonNodeReadOnlyTrx, JsonNodeTrx> resourceManager, InternalJsonNodeReadOnlyTrx nodeReadTrx, @Nullable PathSummaryWriter<JsonNodeReadOnlyTrx> pathSummaryWriter, @NonNegative int maxNodeCount, @Nullable Lock transactionLock, Duration afterCommitDelay, @NonNull JsonNodeHashing nodeHashing, JsonNodeFactory nodeFactory, @NonNull AfterCommitState afterCommitState, RecordToRevisionsIndex nodeToRevisionsIndex, boolean isAutoCommitting) {
        super(new JsonNodeTrxThreadFactory(), resourceManager.getResourceConfig().hashType, nodeReadTrx, nodeReadTrx, resourceManager, afterCommitState, nodeHashing, pathSummaryWriter, nodeFactory, nodeToRevisionsIndex, transactionLock, afterCommitDelay, maxNodeCount);
        this.databaseName = Objects.requireNonNull(databaseName);
        this.hashFunction = resourceManager.getResourceConfig().nodeHashFunction;
        this.storeChildCount = resourceManager.getResourceConfig().storeChildCount();
        this.isAutoCommitting = isAutoCommitting;
        this.useTextCompression = resourceManager.getResourceConfig().useTextCompression;
        this.deweyIDManager = new JsonDeweyIDManager(this);
        this.storeNodeHistory = resourceManager.getResourceConfig().storeNodeHistory();
    }

    @Override
    public JsonNodeTrx insertSubtreeAsFirstChild(JsonReader reader) {
        return this.insertSubtree(reader, InsertPosition.AS_FIRST_CHILD, JsonNodeTrx.Commit.IMPLICIT, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsFirstChild(JsonReader reader, JsonNodeTrx.Commit commit) {
        return this.insertSubtree(reader, InsertPosition.AS_FIRST_CHILD, commit, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsFirstChild(JsonReader reader, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode) {
        return this.insertSubtree(reader, InsertPosition.AS_FIRST_CHILD, commit, checkParentNode, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsFirstChild(JsonReader reader, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode, JsonNodeTrx.SkipRootToken skipRootToken) {
        return this.insertSubtree(reader, InsertPosition.AS_FIRST_CHILD, commit, checkParentNode, skipRootToken);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLastChild(JsonReader reader) {
        return this.insertSubtree(reader, InsertPosition.AS_LAST_CHILD, JsonNodeTrx.Commit.IMPLICIT, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLastChild(JsonReader reader, JsonNodeTrx.Commit commit) {
        return this.insertSubtree(reader, InsertPosition.AS_LAST_CHILD, commit, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLastChild(JsonReader reader, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode) {
        return this.insertSubtree(reader, InsertPosition.AS_LAST_CHILD, commit, checkParentNode, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLastChild(JsonReader reader, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode, JsonNodeTrx.SkipRootToken skipRootToken) {
        return this.insertSubtree(reader, InsertPosition.AS_LAST_CHILD, commit, checkParentNode, skipRootToken);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLeftSibling(JsonReader reader) {
        return this.insertSubtree(reader, InsertPosition.AS_LEFT_SIBLING, JsonNodeTrx.Commit.IMPLICIT, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLeftSibling(JsonReader reader, JsonNodeTrx.Commit commit) {
        return this.insertSubtree(reader, InsertPosition.AS_LEFT_SIBLING, commit, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLeftSibling(JsonReader reader, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode) {
        return this.insertSubtree(reader, InsertPosition.AS_LEFT_SIBLING, commit, checkParentNode, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLeftSibling(JsonReader reader, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode, JsonNodeTrx.SkipRootToken skipRootToken) {
        return this.insertSubtree(reader, InsertPosition.AS_LEFT_SIBLING, commit, checkParentNode, skipRootToken);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsRightSibling(JsonReader reader) {
        return this.insertSubtree(reader, InsertPosition.AS_RIGHT_SIBLING, JsonNodeTrx.Commit.IMPLICIT, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsRightSibling(JsonReader reader, JsonNodeTrx.Commit commit) {
        return this.insertSubtree(reader, InsertPosition.AS_RIGHT_SIBLING, commit, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsRightSibling(JsonReader reader, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode) {
        return this.insertSubtree(reader, InsertPosition.AS_RIGHT_SIBLING, commit, checkParentNode, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsRightSibling(JsonReader reader, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode, JsonNodeTrx.SkipRootToken skipRootToken) {
        return this.insertSubtree(reader, InsertPosition.AS_RIGHT_SIBLING, commit, checkParentNode, skipRootToken);
    }

    private JsonNodeTrx insertSubtree(JsonReader reader, InsertPosition insertionPosition, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode, JsonNodeTrx.SkipRootToken doSkipRootJsonToken) {
        ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).assertNotClosed();
        Objects.requireNonNull(reader);
        assert (insertionPosition != null);
        this.runLocked(() -> {
            try {
                this.assertRunning();
                JsonToken peekedJsonToken = reader.peek();
                if (peekedJsonToken != JsonToken.BEGIN_OBJECT && peekedJsonToken != JsonToken.BEGIN_ARRAY) {
                    throw new SirixUsageException(new String[]{"JSON to insert must begin with an array or object."});
                }
                JsonNodeTrx.SkipRootToken skipRootJsonToken = doSkipRootJsonToken;
                NodeKind nodeKind = this.getKind();
                block1 : switch (insertionPosition) {
                    case AS_FIRST_CHILD: 
                    case AS_LAST_CHILD: {
                        if (nodeKind != NodeKind.JSON_DOCUMENT && nodeKind != NodeKind.ARRAY && nodeKind != NodeKind.OBJECT) {
                            throw new IllegalStateException("Current node must either be the document root, an array or an object key.");
                        }
                        switch (peekedJsonToken) {
                            case BEGIN_OBJECT: {
                                if (nodeKind != NodeKind.OBJECT) break block1;
                                skipRootJsonToken = JsonNodeTrx.SkipRootToken.YES;
                                break;
                            }
                            case BEGIN_ARRAY: {
                                if (nodeKind == NodeKind.ARRAY || nodeKind == NodeKind.JSON_DOCUMENT) break block1;
                                throw new IllegalStateException("Current node in storage must be an array node.");
                            }
                        }
                        break;
                    }
                    case AS_LEFT_SIBLING: 
                    case AS_RIGHT_SIBLING: {
                        NodeKind parentKind;
                        if (checkParentNode != JsonNodeTrx.CheckParentNode.YES || (parentKind = this.getParentKind()) == NodeKind.ARRAY) break;
                        throw new IllegalStateException("Current parent node must be an array node.");
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                this.checkAccessAndCommit();
                this.beforeBulkInsertionRevisionNumber = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getRevisionNumber();
                this.nodeHashing.setBulkInsert(true);
                if (this.isAutoCommitting) {
                    this.nodeHashing.setAutoCommit(true);
                }
                long nodeKey = this.getCurrentNode().getNodeKey();
                JsonShredder.Builder shredderBuilder = new JsonShredder.Builder(this, reader, insertionPosition);
                if (skipRootJsonToken == JsonNodeTrx.SkipRootToken.YES) {
                    shredderBuilder.skipRootJsonToken();
                }
                JsonShredder shredder = shredderBuilder.build();
                shredder.call();
                this.moveTo(nodeKey);
                switch (insertionPosition) {
                    case AS_FIRST_CHILD: {
                        this.moveToFirstChild();
                        break;
                    }
                    case AS_LAST_CHILD: {
                        this.moveToLastChild();
                        break;
                    }
                    case AS_LEFT_SIBLING: {
                        this.moveToLeftSibling();
                        break;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.moveToRightSibling();
                        break;
                    }
                }
                this.adaptUpdateOperationsForInsert(this.getDeweyID(), this.getNodeKey());
                if (!this.isAutoCommitting) {
                    this.adaptHashesInPostorderTraversal();
                }
                this.nodeHashing.setBulkInsert(false);
                if (commit == JsonNodeTrx.Commit.IMPLICIT) {
                    this.commit();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return this;
    }

    @Override
    public JsonNodeTrx insertSubtreeAsFirstChild(Item item) {
        return this.insertSubtree(item, InsertPosition.AS_FIRST_CHILD, JsonNodeTrx.Commit.IMPLICIT, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsFirstChild(Item item, JsonNodeTrx.Commit commit) {
        return this.insertSubtree(item, InsertPosition.AS_FIRST_CHILD, commit, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsFirstChild(Item item, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode) {
        return this.insertSubtree(item, InsertPosition.AS_FIRST_CHILD, commit, checkParentNode, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsFirstChild(Item item, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode, JsonNodeTrx.SkipRootToken skipRootToken) {
        return this.insertSubtree(item, InsertPosition.AS_FIRST_CHILD, commit, checkParentNode, skipRootToken);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLastChild(Item item) {
        return this.insertSubtree(item, InsertPosition.AS_LAST_CHILD, JsonNodeTrx.Commit.IMPLICIT, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLastChild(Item item, JsonNodeTrx.Commit commit) {
        return this.insertSubtree(item, InsertPosition.AS_LAST_CHILD, commit, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLastChild(Item item, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode) {
        return this.insertSubtree(item, InsertPosition.AS_LAST_CHILD, commit, checkParentNode, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLastChild(Item item, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode, JsonNodeTrx.SkipRootToken skipRootToken) {
        return this.insertSubtree(item, InsertPosition.AS_FIRST_CHILD, commit, checkParentNode, skipRootToken);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLeftSibling(Item item) {
        return this.insertSubtree(item, InsertPosition.AS_LEFT_SIBLING, JsonNodeTrx.Commit.IMPLICIT, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLeftSibling(Item item, JsonNodeTrx.Commit commit) {
        return this.insertSubtree(item, InsertPosition.AS_LEFT_SIBLING, commit, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLeftSibling(Item item, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode) {
        return this.insertSubtree(item, InsertPosition.AS_LEFT_SIBLING, commit, checkParentNode, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsLeftSibling(Item item, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode, JsonNodeTrx.SkipRootToken skipRootToken) {
        return this.insertSubtree(item, InsertPosition.AS_FIRST_CHILD, commit, checkParentNode, skipRootToken);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsRightSibling(Item item) {
        return this.insertSubtree(item, InsertPosition.AS_RIGHT_SIBLING, JsonNodeTrx.Commit.IMPLICIT, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsRightSibling(Item item, JsonNodeTrx.Commit commit) {
        return this.insertSubtree(item, InsertPosition.AS_RIGHT_SIBLING, commit, JsonNodeTrx.CheckParentNode.YES, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsRightSibling(Item item, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode) {
        return this.insertSubtree(item, InsertPosition.AS_RIGHT_SIBLING, commit, checkParentNode, JsonNodeTrx.SkipRootToken.NO);
    }

    @Override
    public JsonNodeTrx insertSubtreeAsRightSibling(Item item, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode, JsonNodeTrx.SkipRootToken skipRootToken) {
        return this.insertSubtree(item, InsertPosition.AS_FIRST_CHILD, commit, checkParentNode, skipRootToken);
    }

    private JsonNodeTrx insertSubtree(Item item, InsertPosition insertionPosition, JsonNodeTrx.Commit commit, JsonNodeTrx.CheckParentNode checkParentNode, JsonNodeTrx.SkipRootToken doSkipRootToken) {
        ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).assertNotClosed();
        Objects.requireNonNull(item);
        assert (insertionPosition != null);
        this.runLocked(() -> {
            this.assertRunning();
            if (!item.itemType().isArray() && !item.itemType().isObject()) {
                throw new SirixUsageException(new String[]{"JSON to insert must begin with an array or object."});
            }
            NodeKind nodeKind = this.getKind();
            JsonNodeTrx.SkipRootToken skipRootJsonToken = doSkipRootToken;
            switch (insertionPosition) {
                case AS_FIRST_CHILD: 
                case AS_LAST_CHILD: {
                    if (nodeKind != NodeKind.JSON_DOCUMENT && nodeKind != NodeKind.ARRAY && nodeKind != NodeKind.OBJECT) {
                        throw new IllegalStateException("Current node must either be the document root, an array or an object key.");
                    }
                    if (item.itemType().isObject()) {
                        if (nodeKind != NodeKind.OBJECT) break;
                        skipRootJsonToken = JsonNodeTrx.SkipRootToken.YES;
                        break;
                    }
                    if (!item.itemType().isArray() || nodeKind == NodeKind.ARRAY || nodeKind == NodeKind.JSON_DOCUMENT) break;
                    throw new IllegalStateException("Current node in storage must be an array node.");
                }
                case AS_LEFT_SIBLING: 
                case AS_RIGHT_SIBLING: {
                    NodeKind parentKind;
                    if (checkParentNode != JsonNodeTrx.CheckParentNode.YES || (parentKind = this.getParentKind()) == NodeKind.ARRAY) break;
                    throw new IllegalStateException("Current parent node must be an array node.");
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.checkAccessAndCommit();
            this.beforeBulkInsertionRevisionNumber = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getRevisionNumber();
            this.nodeHashing.setBulkInsert(true);
            if (this.isAutoCommitting) {
                this.nodeHashing.setAutoCommit(true);
            }
            long nodeKey = this.getCurrentNode().getNodeKey();
            JsonItemShredder.Builder shredderBuilder = new JsonItemShredder.Builder(this, item, insertionPosition);
            if (skipRootJsonToken == JsonNodeTrx.SkipRootToken.YES) {
                shredderBuilder.skipRootJsonToken();
            }
            JsonItemShredder shredder = shredderBuilder.build();
            shredder.call();
            this.moveTo(nodeKey);
            switch (insertionPosition) {
                case AS_FIRST_CHILD: {
                    this.moveToFirstChild();
                    break;
                }
                case AS_LAST_CHILD: {
                    this.moveToLastChild();
                    break;
                }
                case AS_LEFT_SIBLING: {
                    this.moveToLeftSibling();
                    break;
                }
                case AS_RIGHT_SIBLING: {
                    this.moveToRightSibling();
                    break;
                }
            }
            this.adaptUpdateOperationsForInsert(this.getDeweyID(), this.getNodeKey());
            if (!this.isAutoCommitting) {
                this.adaptHashesInPostorderTraversal();
            }
            this.nodeHashing.setBulkInsert(false);
            if (commit == JsonNodeTrx.Commit.IMPLICIT) {
                this.commit();
            }
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertObjectAsFirstChild() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            NodeKind kind = this.getKind();
            if (kind != NodeKind.JSON_DOCUMENT && kind != NodeKind.OBJECT_KEY && kind != NodeKind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not the document-, an object key- or a json array node!"});
            }
            this.checkAccessAndCommit();
            StructNode structNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = structNode.getNodeKey();
            long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            long rightSibKey = kind == NodeKind.OBJECT_KEY ? Fixed.NULL_NODE_KEY.getStandardProperty() : structNode.getFirstChildKey();
            SirixDeweyID id = structNode.getKind() == NodeKind.OBJECT_KEY ? this.deweyIDManager.newRecordValueID() : this.deweyIDManager.newFirstChildID();
            ObjectNode node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectNode(parentKey, leftSibKey, rightSibKey, id);
            this.adaptNodesAndHashesForInsertAsChild(node);
            if (this.getParentKind() != NodeKind.OBJECT_KEY && !this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertObjectAsLastChild() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            NodeKind kind = this.getKind();
            if (kind != NodeKind.JSON_DOCUMENT && kind != NodeKind.OBJECT_KEY && kind != NodeKind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not the document-, an object key- or a json array node!"});
            }
            this.checkAccessAndCommit();
            StructNode structNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = structNode.getNodeKey();
            long leftSibKey = kind == NodeKind.OBJECT_KEY ? Fixed.NULL_NODE_KEY.getStandardProperty() : structNode.getLastChildKey();
            long rightSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            SirixDeweyID id = structNode.getKind() == NodeKind.OBJECT_KEY ? this.deweyIDManager.newRecordValueID() : (structNode.getFirstChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.deweyIDManager.newFirstChildID() : this.deweyIDManager.newLastChildID());
            ObjectNode node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectNode(parentKey, leftSibKey, rightSibKey, id);
            this.adaptNodesAndHashesForInsertAsChild(node);
            if (this.getParentKind() != NodeKind.OBJECT_KEY && !this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertObjectAsLeftSibling() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            if (!this.nodeHashing.isBulkInsert() && this.getParentKind() != NodeKind.ARRAY) {
                throw new SirixUsageException(new String[]{INSERT_NOT_ALLOWED_SINCE_PARENT_NOT_IN_AN_ARRAY_NODE});
            }
            StructNode currentNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getLeftSiblingKey();
            long rightSibKey = currentNode.getNodeKey();
            SirixDeweyID id = this.deweyIDManager.newLeftSiblingID();
            ObjectNode node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectNode(parentKey, leftSibKey, rightSibKey, id);
            this.insertAsSibling(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertObjectAsRightSibling() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            if (!this.nodeHashing.isBulkInsert() && this.getParentKind() != NodeKind.ARRAY) {
                throw new SirixUsageException(new String[]{INSERT_NOT_ALLOWED_SINCE_PARENT_NOT_IN_AN_ARRAY_NODE});
            }
            StructNode currentNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getNodeKey();
            long rightSibKey = currentNode.getRightSiblingKey();
            SirixDeweyID id = this.deweyIDManager.newRightSiblingID();
            ObjectNode node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectNode(parentKey, leftSibKey, rightSibKey, id);
            this.insertAsSibling(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertObjectRecordAsFirstChild(String key, ObjectRecordValue<?> value) {
        Objects.requireNonNull(key);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object node!"});
            }
            this.checkAccessAndCommit();
            StructNode structNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = structNode.getNodeKey();
            long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            long rightSibKey = structNode.getFirstChildKey();
            long pathNodeKey = this.getPathNodeKey(structNode, key, NodeKind.OBJECT_KEY);
            SirixDeweyID id = this.deweyIDManager.newFirstChildID();
            ObjectKeyNode node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectKeyNode(parentKey, leftSibKey, rightSibKey, pathNodeKey, key, Fixed.NULL_NODE_KEY.getStandardProperty(), id);
            this.adaptNodesAndHashesForInsertAsChild(node);
            ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
            this.insertValue(value);
            this.setFirstChildOfObjectKeyNode(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertObjectRecordAsLastChild(String key, ObjectRecordValue<?> value) {
        Objects.requireNonNull(key);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object node!"});
            }
            this.checkAccessAndCommit();
            StructNode structNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = structNode.getNodeKey();
            long leftSibKey = structNode.getLastChildKey();
            long rightSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            long pathNodeKey = this.getPathNodeKey(structNode, key, NodeKind.OBJECT_KEY);
            SirixDeweyID id = structNode.getFirstChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.deweyIDManager.newFirstChildID() : this.deweyIDManager.newLastChildID();
            ObjectKeyNode node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectKeyNode(parentKey, leftSibKey, rightSibKey, pathNodeKey, key, Fixed.NULL_NODE_KEY.getStandardProperty(), id);
            this.adaptNodesAndHashesForInsertAsChild(node);
            ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
            this.insertValue(value);
            this.setFirstChildOfObjectKeyNode(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void adaptUpdateOperationsForInsert(SirixDeweyID id, long newNodeKey) {
        DiffTuple diffTuple = new DiffTuple(DiffFactory.DiffType.INSERTED, newNodeKey, 0L, id == null ? null : new DiffDepth(id.getLevel(), 0));
        if (id == null) {
            this.updateOperationsUnordered.put(newNodeKey, diffTuple);
        } else {
            this.updateOperationsOrdered.put(id, diffTuple);
        }
    }

    private void adaptUpdateOperationsForReplace(SirixDeweyID id, long oldNodeKey, long newNodeKey) {
        if (id == null) {
            this.updateOperationsUnordered.put(newNodeKey, new DiffTuple(DiffFactory.DiffType.REPLACEDNEW, newNodeKey, oldNodeKey, null));
        } else {
            this.updateOperationsOrdered.put(id, new DiffTuple(DiffFactory.DiffType.REPLACEDNEW, newNodeKey, oldNodeKey, new DiffDepth(id.getLevel(), id.getLevel())));
        }
    }

    private void setFirstChildOfObjectKeyNode(ObjectKeyNode node) {
        ObjectKeyNode objectKeyNode = (ObjectKeyNode)this.pageTrx.prepareRecordForModification(node.getNodeKey(), IndexType.DOCUMENT, -1);
        objectKeyNode.setFirstChildKey(this.getNodeKey());
    }

    private void insertValue(ObjectRecordValue<?> value) throws AssertionError {
        NodeKind valueKind = value.getKind();
        switch (valueKind) {
            case OBJECT: {
                this.insertObjectAsFirstChild();
                break;
            }
            case ARRAY: {
                this.insertArrayAsFirstChild();
                break;
            }
            case STRING_VALUE: {
                this.insertStringValueAsFirstChild((String)value.getValue());
                break;
            }
            case BOOLEAN_VALUE: {
                this.insertBooleanValueAsFirstChild((Boolean)value.getValue());
                break;
            }
            case NUMBER_VALUE: {
                this.insertNumberValueAsFirstChild((Number)value.getValue());
                break;
            }
            case NULL_VALUE: {
                this.insertNullValueAsFirstChild();
                break;
            }
            default: {
                throw new AssertionError((Object)"Type not known.");
            }
        }
    }

    private long getPathNodeKey(ImmutableNode node, String name, NodeKind kind) {
        if (this.buildPathSummary) {
            this.moveToParentObjectKeyArrayOrDocumentRoot();
            long pathNodeKey = this.pathSummaryWriter.getPathNodeKey(new QNm(name), kind);
            ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
            return pathNodeKey;
        }
        return 0L;
    }

    private void moveToParentObjectKeyArrayOrDocumentRoot() {
        NodeKind nodeKind = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getKind();
        while (nodeKind != NodeKind.OBJECT_KEY && nodeKind != NodeKind.ARRAY && nodeKind != NodeKind.JSON_DOCUMENT) {
            ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).moveToParent();
            nodeKind = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getKind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertObjectRecordAsLeftSibling(String key, ObjectRecordValue<?> value) {
        Objects.requireNonNull(key);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT_KEY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object key node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = currentNode.getParentKey();
            long rightSibKey = currentNode.getNodeKey();
            long leftSibKey = currentNode.getLeftSiblingKey();
            this.moveToParent();
            long pathNodeKey = this.getPathNodeKey(currentNode, key, NodeKind.OBJECT_KEY);
            this.moveTo(currentNode.getNodeKey());
            SirixDeweyID id = this.deweyIDManager.newLeftSiblingID();
            ObjectKeyNode node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectKeyNode(parentKey, leftSibKey, rightSibKey, pathNodeKey, key, -1L, id);
            this.insertAsSibling(node);
            this.insertValue(value);
            this.setFirstChildOfObjectKeyNode(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertObjectRecordAsRightSibling(String key, ObjectRecordValue<?> value) {
        Objects.requireNonNull(key);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT_KEY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object key node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getNodeKey();
            long rightSibKey = currentNode.getRightSiblingKey();
            this.moveToParent();
            long pathNodeKey = this.getPathNodeKey(currentNode, key, NodeKind.OBJECT_KEY);
            this.moveTo(currentNode.getNodeKey());
            SirixDeweyID id = this.deweyIDManager.newRightSiblingID();
            ObjectKeyNode node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectKeyNode(parentKey, leftSibKey, rightSibKey, pathNodeKey, key, -1L, id);
            this.insertAsSibling(node);
            this.insertValue(value);
            this.setFirstChildOfObjectKeyNode(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertArrayAsFirstChild() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            NodeKind kind = this.getKind();
            if (kind != NodeKind.JSON_DOCUMENT && kind != NodeKind.OBJECT_KEY && kind != NodeKind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not the document node or an object key node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = currentNode.getNodeKey();
            long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            long rightSibKey = currentNode.getFirstChildKey();
            long pathNodeKey = this.getPathNodeKey(currentNode, "__array__", NodeKind.ARRAY);
            SirixDeweyID id = currentNode.getKind() == NodeKind.OBJECT_KEY ? this.deweyIDManager.newRecordValueID() : this.deweyIDManager.newFirstChildID();
            ArrayNode node = ((JsonNodeFactory)this.nodeFactory).createJsonArrayNode(parentKey, leftSibKey, rightSibKey, pathNodeKey, id);
            this.adaptNodesAndHashesForInsertAsChild(node);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
            if (this.getParentKind() != NodeKind.OBJECT_KEY && !this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertArrayAsLastChild() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            NodeKind kind = this.getKind();
            if (kind != NodeKind.JSON_DOCUMENT && kind != NodeKind.OBJECT_KEY && kind != NodeKind.ARRAY) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not the document node or an object key node!"});
            }
            this.checkAccessAndCommit();
            StructNode currentNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = currentNode.getNodeKey();
            long leftSibKey = currentNode.getLastChildKey();
            long rightSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
            long pathNodeKey = this.getPathNodeKey(currentNode, "__array__", NodeKind.ARRAY);
            SirixDeweyID id = currentNode.getKind() == NodeKind.OBJECT_KEY ? this.deweyIDManager.newRecordValueID() : (currentNode.getFirstChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.deweyIDManager.newFirstChildID() : this.deweyIDManager.newLastChildID());
            ArrayNode node = ((JsonNodeFactory)this.nodeFactory).createJsonArrayNode(parentKey, leftSibKey, rightSibKey, pathNodeKey, id);
            this.adaptNodesAndHashesForInsertAsChild(node);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
            if (this.getParentKind() != NodeKind.OBJECT_KEY && !this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertArrayAsLeftSibling() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            this.checkPrecondition();
            StructNode currentNode = (StructNode)this.getCurrentNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getLeftSiblingKey();
            long rightSibKey = currentNode.getNodeKey();
            this.moveToParent();
            long pathNodeKey = this.getPathNodeKey(currentNode, "array", NodeKind.ARRAY);
            this.moveTo(currentNode.getNodeKey());
            SirixDeweyID id = this.deweyIDManager.newLeftSiblingID();
            ArrayNode node = ((JsonNodeFactory)this.nodeFactory).createJsonArrayNode(parentKey, leftSibKey, rightSibKey, pathNodeKey, id);
            this.insertAsSibling(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertArrayAsRightSibling() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            this.checkPrecondition();
            StructNode currentNode = (StructNode)this.getCurrentNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getNodeKey();
            long rightSibKey = currentNode.getRightSiblingKey();
            this.moveToParent();
            long pathNodeKey = this.getPathNodeKey(currentNode, "array", NodeKind.ARRAY);
            this.moveTo(currentNode.getNodeKey());
            SirixDeweyID id = this.deweyIDManager.newRightSiblingID();
            ArrayNode node = ((JsonNodeFactory)this.nodeFactory).createJsonArrayNode(parentKey, leftSibKey, rightSibKey, pathNodeKey, id);
            this.insertAsSibling(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx replaceObjectRecordValue(ObjectRecordValue<?> value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT_KEY) {
                throw new SirixUsageException(new String[]{"Replacing is only permitted for record object key nodes."});
            }
            this.checkAccessAndCommit();
            long nodeKey = this.getNodeKey();
            this.moveToFirstChild();
            this.canRemoveValue = true;
            long oldValueNodeKey = this.getNodeKey();
            this.remove();
            this.moveTo(nodeKey);
            this.insertValue(value);
            Object node = this.getCurrentNode();
            this.adaptUpdateOperationsForReplace(node.getDeweyID(), oldValueNodeKey, node.getNodeKey());
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertStringValueAsFirstChild(String value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            AbstractStringNode node;
            SirixDeweyID id;
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT_KEY && kind != NodeKind.ARRAY && kind != NodeKind.JSON_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object key or an array node!"});
            }
            if (kind != NodeKind.OBJECT_KEY) {
                this.checkAccessAndCommit();
            }
            StructNode structNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long pathNodeKey = this.getPathNodeKey(structNode);
            long parentKey = structNode.getNodeKey();
            byte[] textValue = JsonNodeTrxImpl.getBytes(value);
            if (kind == NodeKind.OBJECT_KEY) {
                id = this.deweyIDManager.newRecordValueID();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectStringNode(parentKey, textValue, this.useTextCompression, id);
            } else {
                id = this.deweyIDManager.newFirstChildID();
                long rightSibKey = structNode.getFirstChildKey();
                long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonStringNode(parentKey, leftSibKey, rightSibKey, textValue, this.useTextCompression, id);
            }
            this.adaptNodesAndHashesForInsertAsChild(node);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
            if (this.getParentKind() != NodeKind.OBJECT_KEY && !this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertStringValueAsLastChild(String value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            AbstractStringNode node;
            SirixDeweyID id;
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT_KEY && kind != NodeKind.ARRAY && kind != NodeKind.JSON_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object key or an array node!"});
            }
            if (kind != NodeKind.OBJECT_KEY) {
                this.checkAccessAndCommit();
            }
            StructNode structNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long pathNodeKey = this.getPathNodeKey(structNode);
            long parentKey = structNode.getNodeKey();
            byte[] textValue = JsonNodeTrxImpl.getBytes(value);
            if (kind == NodeKind.OBJECT_KEY) {
                id = this.deweyIDManager.newRecordValueID();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectStringNode(parentKey, textValue, this.useTextCompression, id);
            } else {
                id = structNode.getFirstChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.deweyIDManager.newFirstChildID() : this.deweyIDManager.newLastChildID();
                long leftSibKey = structNode.getLastChildKey();
                long rightSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonStringNode(parentKey, leftSibKey, rightSibKey, textValue, this.useTextCompression, id);
            }
            this.adaptNodesAndHashesForInsertAsChild(node);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
            if (this.getParentKind() != NodeKind.OBJECT_KEY && !this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private long getPathNodeKey(StructNode structNode) {
        long pathNodeKey = structNode.getKind() == NodeKind.ARRAY ? ((ArrayNode)structNode).getPathNodeKey() : (structNode.getKind() == NodeKind.OBJECT_KEY ? ((ObjectKeyNode)structNode).getPathNodeKey() : -1L);
        return pathNodeKey;
    }

    private void adaptNodesAndHashesForInsertAsChild(ImmutableJsonNode node) {
        ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
        this.adaptForInsert((StructNode)((Object)node));
        ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
        this.nodeHashing.adaptHashesWithAdd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertStringValueAsLeftSibling(String value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            this.checkPrecondition();
            StructNode currentNode = (StructNode)this.getCurrentNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getLeftSiblingKey();
            long rightSibKey = currentNode.getNodeKey();
            byte[] textValue = JsonNodeTrxImpl.getBytes(value);
            SirixDeweyID id = this.deweyIDManager.newLeftSiblingID();
            StringNode node = ((JsonNodeFactory)this.nodeFactory).createJsonStringNode(parentKey, leftSibKey, rightSibKey, textValue, this.useTextCompression, id);
            this.insertAsSibling(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertStringValueAsRightSibling(String value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            this.checkPrecondition();
            StructNode currentNode = (StructNode)this.getCurrentNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getNodeKey();
            long rightSibKey = currentNode.getRightSiblingKey();
            byte[] textValue = JsonNodeTrxImpl.getBytes(value);
            SirixDeweyID id = this.deweyIDManager.newRightSiblingID();
            StringNode node = ((JsonNodeFactory)this.nodeFactory).createJsonStringNode(parentKey, leftSibKey, rightSibKey, textValue, this.useTextCompression, id);
            this.insertAsSibling(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertBooleanValueAsFirstChild(boolean value) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            AbstractBooleanNode node;
            SirixDeweyID id;
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT_KEY && kind != NodeKind.ARRAY && kind != NodeKind.JSON_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object key or array node!"});
            }
            if (kind != NodeKind.OBJECT_KEY) {
                this.checkAccessAndCommit();
            }
            StructNode structNode = (StructNode)this.getCurrentNode();
            long pathNodeKey = this.getPathNodeKey(structNode);
            long parentKey = structNode.getNodeKey();
            if (kind == NodeKind.OBJECT_KEY) {
                id = this.deweyIDManager.newRecordValueID();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectBooleanNode(parentKey, value, id);
            } else {
                id = this.deweyIDManager.newFirstChildID();
                long rightSibKey = structNode.getFirstChildKey();
                long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonBooleanNode(parentKey, leftSibKey, rightSibKey, value, id);
            }
            this.adaptNodesAndHashesForInsertAsChild(node);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
            if (this.getParentKind() != NodeKind.OBJECT_KEY && !this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertBooleanValueAsLastChild(boolean value) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            AbstractBooleanNode node;
            SirixDeweyID id;
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT_KEY && kind != NodeKind.ARRAY && kind != NodeKind.JSON_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object key or array node!"});
            }
            if (kind != NodeKind.OBJECT_KEY) {
                this.checkAccessAndCommit();
            }
            StructNode structNode = (StructNode)this.getCurrentNode();
            long pathNodeKey = this.getPathNodeKey(structNode);
            long parentKey = structNode.getNodeKey();
            if (kind == NodeKind.OBJECT_KEY) {
                id = this.deweyIDManager.newRecordValueID();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectBooleanNode(parentKey, value, id);
            } else {
                id = structNode.getFirstChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.deweyIDManager.newFirstChildID() : this.deweyIDManager.newLastChildID();
                long leftSibKey = structNode.getLastChildKey();
                long rightSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonBooleanNode(parentKey, leftSibKey, rightSibKey, value, id);
            }
            this.adaptNodesAndHashesForInsertAsChild(node);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
            if (this.getParentKind() != NodeKind.OBJECT_KEY && !this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertBooleanValueAsLeftSibling(boolean value) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            this.checkPrecondition();
            StructNode currentNode = (StructNode)this.getCurrentNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getLeftSiblingKey();
            long rightSibKey = currentNode.getNodeKey();
            SirixDeweyID id = this.deweyIDManager.newLeftSiblingID();
            BooleanNode node = ((JsonNodeFactory)this.nodeFactory).createJsonBooleanNode(parentKey, leftSibKey, rightSibKey, value, id);
            this.insertAsSibling(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertBooleanValueAsRightSibling(boolean value) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            this.checkPrecondition();
            StructNode currentNode = (StructNode)this.getCurrentNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getNodeKey();
            long rightSibKey = currentNode.getRightSiblingKey();
            SirixDeweyID id = this.deweyIDManager.newRightSiblingID();
            BooleanNode node = ((JsonNodeFactory)this.nodeFactory).createJsonBooleanNode(parentKey, leftSibKey, rightSibKey, value, id);
            this.insertAsSibling(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void checkPrecondition() {
        if (!this.nodeHashing.isBulkInsert() && this.getParentKind() != NodeKind.ARRAY) {
            throw new SirixUsageException(new String[]{INSERT_NOT_ALLOWED_SINCE_PARENT_NOT_IN_AN_ARRAY_NODE});
        }
    }

    private void insertAsSibling(ImmutableJsonNode node) {
        long pathNodeKey;
        ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
        this.adaptForInsert((StructNode)((Object)node));
        ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
        this.nodeHashing.adaptHashesWithAdd();
        if (this.buildPathSummary) {
            this.moveToParentObjectKeyArrayOrDocumentRoot();
            pathNodeKey = this.isObjectKey() ? ((ImmutableObjectKeyNode)this.getNode()).getPathNodeKey() : (this.isArray() ? ((ImmutableArrayNode)this.getNode()).getPathNodeKey() : -1L);
        } else {
            pathNodeKey = 0L;
        }
        ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
        this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertNumberValueAsFirstChild(Number value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            AbstractNumberNode node;
            SirixDeweyID id;
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT_KEY && kind != NodeKind.ARRAY && kind != NodeKind.JSON_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object-key- or array-node!"});
            }
            if (kind != NodeKind.OBJECT_KEY) {
                this.checkAccessAndCommit();
            }
            StructNode currentNode = (StructNode)this.getCurrentNode();
            long pathNodeKey = this.getPathNodeKey(currentNode);
            long parentKey = currentNode.getNodeKey();
            if (kind == NodeKind.OBJECT_KEY) {
                id = this.deweyIDManager.newRecordValueID();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectNumberNode(parentKey, value, id);
            } else {
                id = this.deweyIDManager.newFirstChildID();
                long rightSibKey = currentNode.getFirstChildKey();
                long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonNumberNode(parentKey, leftSibKey, rightSibKey, value, id);
            }
            this.adaptNodesAndHashesForInsertAsChild(node);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
            if (this.getParentKind() != NodeKind.OBJECT_KEY && !this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertNumberValueAsLastChild(Number value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            AbstractNumberNode node;
            SirixDeweyID id;
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT_KEY && kind != NodeKind.ARRAY && kind != NodeKind.JSON_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object-key- or array-node!"});
            }
            if (kind != NodeKind.OBJECT_KEY) {
                this.checkAccessAndCommit();
            }
            StructNode currentNode = (StructNode)this.getCurrentNode();
            long pathNodeKey = this.getPathNodeKey(currentNode);
            long parentKey = currentNode.getNodeKey();
            if (kind == NodeKind.OBJECT_KEY) {
                id = this.deweyIDManager.newRecordValueID();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectNumberNode(parentKey, value, id);
            } else {
                id = currentNode.getFirstChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.deweyIDManager.newFirstChildID() : this.deweyIDManager.newLastChildID();
                long leftSibKey = currentNode.getLastChildKey();
                long rightSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonNumberNode(parentKey, leftSibKey, rightSibKey, value, id);
            }
            this.adaptNodesAndHashesForInsertAsChild(node);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
            if (this.getParentKind() != NodeKind.OBJECT_KEY && !this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertNumberValueAsLeftSibling(Number value) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            this.checkPrecondition();
            StructNode structNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = structNode.getParentKey();
            long rightSibKey = structNode.getNodeKey();
            long leftSibKey = structNode.getLeftSiblingKey();
            SirixDeweyID id = this.deweyIDManager.newLeftSiblingID();
            NumberNode node = ((JsonNodeFactory)this.nodeFactory).createJsonNumberNode(parentKey, leftSibKey, rightSibKey, value, id);
            this.insertAsSibling(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public JsonNodeReadOnlyTrx nodeReadOnlyTrxDelegate() {
        return (JsonNodeReadOnlyTrx)((Object)this.nodeReadOnlyTrx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertNumberValueAsRightSibling(Number value) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            this.checkPrecondition();
            StructNode structNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = structNode.getParentKey();
            long leftSibKey = structNode.getNodeKey();
            long rightSibKey = structNode.getRightSiblingKey();
            SirixDeweyID id = this.deweyIDManager.newRightSiblingID();
            NumberNode node = ((JsonNodeFactory)this.nodeFactory).createJsonNumberNode(parentKey, leftSibKey, rightSibKey, value, id);
            this.insertAsSibling(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertNullValueAsFirstChild() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            AbstractNullNode node;
            SirixDeweyID id;
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT_KEY && kind != NodeKind.ARRAY && kind != NodeKind.JSON_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object-key- or array-node!"});
            }
            if (kind != NodeKind.OBJECT_KEY) {
                this.checkAccessAndCommit();
            }
            StructNode structNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = structNode.getNodeKey();
            if (kind == NodeKind.OBJECT_KEY) {
                id = this.deweyIDManager.newRecordValueID();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectNullNode(parentKey, id);
            } else {
                id = this.deweyIDManager.newFirstChildID();
                long rightSibKey = structNode.getFirstChildKey();
                long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonNullNode(parentKey, leftSibKey, rightSibKey, id);
            }
            this.adaptNodesAndHashesForInsertAsChild(node);
            if (this.getParentKind() != NodeKind.OBJECT_KEY && !this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertNullValueAsLastChild() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            AbstractNullNode node;
            SirixDeweyID id;
            NodeKind kind = this.getKind();
            if (kind != NodeKind.OBJECT_KEY && kind != NodeKind.ARRAY && kind != NodeKind.JSON_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an object-key- or array-node!"});
            }
            if (kind != NodeKind.OBJECT_KEY) {
                this.checkAccessAndCommit();
            }
            StructNode structNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = structNode.getNodeKey();
            if (kind == NodeKind.OBJECT_KEY) {
                id = this.deweyIDManager.newRecordValueID();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonObjectNullNode(parentKey, id);
            } else {
                id = structNode.getFirstChildKey() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.deweyIDManager.newFirstChildID() : this.deweyIDManager.newLastChildID();
                long leftSibKey = structNode.getLeftSiblingKey();
                long rightSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                node = ((JsonNodeFactory)this.nodeFactory).createJsonNullNode(parentKey, leftSibKey, rightSibKey, id);
            }
            this.adaptNodesAndHashesForInsertAsChild(node);
            if (this.getParentKind() != NodeKind.OBJECT_KEY && !this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertNullValueAsLeftSibling() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            this.checkPrecondition();
            StructNode currentNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = currentNode.getParentKey();
            long rightSibKey = currentNode.getNodeKey();
            long leftSibKey = currentNode.getLeftSiblingKey();
            SirixDeweyID id = this.deweyIDManager.newLeftSiblingID();
            NullNode node = ((JsonNodeFactory)this.nodeFactory).createJsonNullNode(parentKey, leftSibKey, rightSibKey, id);
            this.insertAsSibling(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx insertNullValueAsRightSibling() {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            this.checkPrecondition();
            StructNode currentNode = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            long parentKey = currentNode.getParentKey();
            long leftSibKey = currentNode.getNodeKey();
            long rightSibKey = currentNode.getRightSiblingKey();
            SirixDeweyID id = this.deweyIDManager.newRightSiblingID();
            NullNode node = ((JsonNodeFactory)this.nodeFactory).createJsonNullNode(parentKey, leftSibKey, rightSibKey, id);
            this.insertAsSibling(node);
            if (!this.nodeHashing.isBulkInsert()) {
                this.adaptUpdateOperationsForInsert(id, node.getNodeKey());
            }
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private static byte[] getBytes(String value) {
        return value.getBytes(Constants.DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx remove() {
        this.checkAccessAndCommit();
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            StructNode node = (StructNode)this.getCurrentNode();
            if (node.getKind() == NodeKind.JSON_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Document root can not be removed."});
            }
            NodeKind parentNodeKind = this.getParentKind();
            if (parentNodeKind != NodeKind.JSON_DOCUMENT && parentNodeKind != NodeKind.OBJECT && parentNodeKind != NodeKind.ARRAY && !this.canRemoveValue) {
                throw new SirixUsageException(new String[]{"An object record value can not be removed, you have to remove the whole object record (parent of this value)."});
            }
            this.canRemoveValue = false;
            if (parentNodeKind != NodeKind.OBJECT_KEY) {
                this.adaptUpdateOperationsForRemove(node.getDeweyID(), node.getNodeKey());
            }
            PostOrderAxis axis = new PostOrderAxis(this);
            while (axis.hasNext()) {
                axis.nextLong();
                ImmutableNode currentNode = axis.getCursor().getNode();
                this.removeName();
                this.removeValue();
                this.pageTrx.removeRecord(currentNode.getNodeKey(), IndexType.DOCUMENT, -1);
                if (!this.storeNodeHistory) continue;
                this.nodeToRevisionsIndex.addRevisionToRecordToRevisionsIndex(currentNode.getNodeKey());
            }
            if (node.getKind() == NodeKind.OBJECT_KEY) {
                this.removeName();
            } else {
                this.removeValue();
            }
            ImmutableJsonNode jsonNode = (ImmutableJsonNode)((Object)node);
            ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(jsonNode);
            this.nodeHashing.adaptHashesWithRemove();
            this.adaptForRemove(node);
            ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(jsonNode);
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addRevisionToRecordToRevisionsIndex(node.getNodeKey());
            }
            if (node.hasRightSibling()) {
                this.moveTo(node.getRightSiblingKey());
            } else if (node.hasLeftSibling()) {
                this.moveTo(node.getLeftSiblingKey());
            } else {
                this.moveTo(node.getParentKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void adaptUpdateOperationsForRemove(SirixDeweyID id, long oldNodeKey) {
        this.moveToNext();
        DiffTuple diffTuple = new DiffTuple(DiffFactory.DiffType.DELETED, 0L, oldNodeKey, id == null ? null : new DiffDepth(0, id.getLevel()));
        if (id == null) {
            this.updateOperationsUnordered.values().removeIf(currDiffTuple -> currDiffTuple.getNewNodeKey() == oldNodeKey);
            this.updateOperationsUnordered.put(oldNodeKey, diffTuple);
        } else {
            this.updateOperationsOrdered.values().removeIf(currDiffTuple -> currDiffTuple.getNewNodeKey() == oldNodeKey);
            this.updateOperationsOrdered.put(id, diffTuple);
        }
        this.moveTo(oldNodeKey);
    }

    private void removeValue() {
        Object currentNode = this.getCurrentNode();
        if (currentNode.getKind() == NodeKind.OBJECT_STRING_VALUE || currentNode.getKind() == NodeKind.OBJECT_NUMBER_VALUE || currentNode.getKind() == NodeKind.OBJECT_BOOLEAN_VALUE || currentNode.getKind() == NodeKind.STRING_VALUE || currentNode.getKind() == NodeKind.NUMBER_VALUE || currentNode.getKind() == NodeKind.BOOLEAN_VALUE) {
            long nodeKey = this.getNodeKey();
            this.moveToParent();
            ImmutableNode node = this.getNode();
            long pathNodeKey = node.getKind() == NodeKind.ARRAY ? ((ImmutableArrayNode)node).getPathNodeKey() : (node.getKind() == NodeKind.OBJECT_KEY ? ((ImmutableObjectKeyNode)node).getPathNodeKey() : -1L);
            this.moveTo(nodeKey);
            this.indexController.notifyChange(IndexController.ChangeType.DELETE, node, pathNodeKey);
        }
    }

    private void removeName() {
        Object n = this.getCurrentNode();
        if (n instanceof ImmutableNameNode) {
            ImmutableNameNode node = (ImmutableNameNode)n;
            this.indexController.notifyChange(IndexController.ChangeType.DELETE, node, node.getPathNodeKey());
            NodeKind nodeKind = node.getKind();
            NamePage page = this.pageTrx.getNamePage(this.pageTrx.getActualRevisionRootPage());
            page.removeName(node.getLocalNameKey(), nodeKind, this.pageTrx);
            assert (nodeKind != NodeKind.JSON_DOCUMENT);
            if (this.buildPathSummary) {
                this.pathSummaryWriter.remove(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx setObjectKeyName(String key) {
        Objects.requireNonNull(key);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getKind() != NodeKind.OBJECT_KEY) {
                throw new SirixUsageException(new String[]{"Not allowed if current node is not an object key node!"});
            }
            this.checkAccessAndCommit();
            ObjectKeyNode node = (ObjectKeyNode)((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode();
            long oldHash = node.computeHash(this.bytes);
            NodeKind nodeKind = node.getKind();
            int oldNameKey = node.getNameKey();
            NamePage page = this.pageTrx.getNamePage(this.pageTrx.getActualRevisionRootPage());
            page.removeName(oldNameKey, nodeKind, this.pageTrx);
            int newNameKey = this.pageTrx.createNameKey(key, node.getKind());
            node = (ObjectKeyNode)this.pageTrx.prepareRecordForModification(node.getNodeKey(), IndexType.DOCUMENT, -1);
            node.setNameKey(newNameKey);
            node.setName(key);
            node.setPreviousRevision(this.pageTrx.getRevisionToRepresent());
            if (this.buildPathSummary) {
                this.pathSummaryWriter.adaptPathForChangedNode(node, new QNm(key), -1, -1, newNameKey, PathSummaryWriter.OPType.SETNAME);
            }
            node.setPathNodeKey(this.buildPathSummary ? this.pathSummaryWriter.getNodeKey() : 0L);
            ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
            this.nodeHashing.adaptHashedWithUpdate(oldHash);
            this.adaptUpdateOperationsForUpdate(node.getDeweyID(), node.getNodeKey());
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addRevisionToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void adaptUpdateOperationsForUpdate(SirixDeweyID id, long nodeKey) {
        DiffTuple diffTuple = new DiffTuple(DiffFactory.DiffType.UPDATED, nodeKey, nodeKey, id == null ? null : new DiffDepth(id.getLevel(), id.getLevel()));
        if (id == null && this.updateOperationsUnordered.get(nodeKey) == null) {
            this.updateOperationsUnordered.put(nodeKey, diffTuple);
        } else if (id != null && this.hasNoUpdatingNodeWithGivenNodeKey(nodeKey)) {
            this.updateOperationsOrdered.put(id, diffTuple);
        }
    }

    private boolean hasNoUpdatingNodeWithGivenNodeKey(long nodeKey) {
        return this.updateOperationsOrdered.values().stream().filter(this.filterInsertedOrDeletedTuplesWithNodeKey(nodeKey)).findAny().isEmpty();
    }

    private Predicate<DiffTuple> filterInsertedOrDeletedTuplesWithNodeKey(long nodeKey) {
        return currDiffTuple -> currDiffTuple.getNewNodeKey() == nodeKey && currDiffTuple.getDiff() == DiffFactory.DiffType.INSERTED || currDiffTuple.getOldNodeKey() == nodeKey && currDiffTuple.getDiff() == DiffFactory.DiffType.DELETED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx setStringValue(String value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getKind() != NodeKind.STRING_VALUE && this.getKind() != NodeKind.OBJECT_STRING_VALUE) {
                throw new SirixUsageException(new String[]{"Not allowed if current node is not a string value and not an object string value node!"});
            }
            this.checkAccessAndCommit();
            long nodeKey = this.getNodeKey();
            this.moveToParent();
            long pathNodeKey = this.getPathNodeKey();
            this.moveTo(nodeKey);
            this.indexController.notifyChange(IndexController.ChangeType.DELETE, this.getNode(), pathNodeKey);
            long oldHash = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode().computeHash(this.bytes);
            byte[] byteVal = JsonNodeTrxImpl.getBytes(value);
            AbstractStringNode node = (AbstractStringNode)this.pageTrx.prepareRecordForModification(((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode().getNodeKey(), IndexType.DOCUMENT, -1);
            node.setRawValue(byteVal);
            node.setPreviousRevision(node.getLastModifiedRevisionNumber());
            node.setLastModifiedRevision(this.pageTrx.getRevisionNumber());
            ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
            this.nodeHashing.adaptHashedWithUpdate(oldHash);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, this.getNode(), pathNodeKey);
            this.adaptUpdateOperationsForUpdate(node.getDeweyID(), node.getNodeKey());
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addRevisionToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx setBooleanValue(boolean value) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getKind() != NodeKind.BOOLEAN_VALUE && this.getKind() != NodeKind.OBJECT_BOOLEAN_VALUE) {
                throw new SirixUsageException(new String[]{"Not allowed if current node is not a boolean value node!"});
            }
            this.checkAccessAndCommit();
            long nodeKey = this.getNodeKey();
            this.moveToParent();
            long pathNodeKey = this.getPathNodeKey();
            this.moveTo(nodeKey);
            this.indexController.notifyChange(IndexController.ChangeType.DELETE, this.getNode(), pathNodeKey);
            long oldHash = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode().computeHash(this.bytes);
            AbstractBooleanNode node = (AbstractBooleanNode)this.pageTrx.prepareRecordForModification(((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode().getNodeKey(), IndexType.DOCUMENT, -1);
            node.setValue(value);
            node.setPreviousRevision(node.getLastModifiedRevisionNumber());
            node.setLastModifiedRevision(this.pageTrx.getRevisionNumber());
            ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
            this.nodeHashing.adaptHashedWithUpdate(oldHash);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, this.getNode(), pathNodeKey);
            this.adaptUpdateOperationsForUpdate(node.getDeweyID(), node.getNodeKey());
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addRevisionToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx setNumberValue(Number value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getKind() != NodeKind.NUMBER_VALUE && this.getKind() != NodeKind.OBJECT_NUMBER_VALUE) {
                throw new SirixUsageException(new String[]{"Not allowed if current node is not a number value and not an object number value node!"});
            }
            this.checkAccessAndCommit();
            long nodeKey = this.getNodeKey();
            this.moveToParent();
            long pathNodeKey = this.getPathNodeKey();
            this.moveTo(nodeKey);
            this.indexController.notifyChange(IndexController.ChangeType.DELETE, this.getNode(), pathNodeKey);
            long oldHash = ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode().computeHash(this.bytes);
            AbstractNumberNode node = (AbstractNumberNode)this.pageTrx.prepareRecordForModification(((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode().getNodeKey(), IndexType.DOCUMENT, -1);
            node.setValue(value);
            node.setPreviousRevision(node.getLastModifiedRevisionNumber());
            node.setLastModifiedRevision(this.pageTrx.getRevisionNumber());
            ((InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
            this.nodeHashing.adaptHashedWithUpdate(oldHash);
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, this.getNode(), pathNodeKey);
            this.adaptUpdateOperationsForUpdate(node.getDeweyID(), node.getNodeKey());
            if (this.storeNodeHistory) {
                this.nodeToRevisionsIndex.addRevisionToRecordToRevisionsIndex(node.getNodeKey());
            }
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void adaptForInsert(StructNode structNode) {
        assert (structNode != null);
        StructNode parent = (StructNode)this.pageTrx.prepareRecordForModification(structNode.getParentKey(), IndexType.DOCUMENT, -1);
        if (this.storeChildCount) {
            parent.incrementChildCount();
        }
        if (structNode.hasLeftSibling()) {
            StructNode leftSiblingNode = (StructNode)this.pageTrx.prepareRecordForModification(structNode.getLeftSiblingKey(), IndexType.DOCUMENT, -1);
            leftSiblingNode.setRightSiblingKey(structNode.getNodeKey());
        } else {
            parent.setFirstChildKey(structNode.getNodeKey());
        }
        if (structNode.hasRightSibling()) {
            StructNode rightSiblingNode = (StructNode)this.pageTrx.prepareRecordForModification(structNode.getRightSiblingKey(), IndexType.DOCUMENT, -1);
            rightSiblingNode.setLeftSiblingKey(structNode.getNodeKey());
        } else {
            parent.setLastChildKey(structNode.getNodeKey());
        }
    }

    private void adaptForRemove(StructNode oldNode) {
        assert (oldNode != null);
        if (oldNode.hasLeftSibling()) {
            StructNode leftSibling = (StructNode)this.pageTrx.prepareRecordForModification(oldNode.getLeftSiblingKey(), IndexType.DOCUMENT, -1);
            leftSibling.setRightSiblingKey(oldNode.getRightSiblingKey());
        }
        if (oldNode.hasRightSibling()) {
            StructNode rightSibling = (StructNode)this.pageTrx.prepareRecordForModification(oldNode.getRightSiblingKey(), IndexType.DOCUMENT, -1);
            rightSibling.setLeftSiblingKey(oldNode.getLeftSiblingKey());
        }
        StructNode parent = (StructNode)this.pageTrx.prepareRecordForModification(oldNode.getParentKey(), IndexType.DOCUMENT, -1);
        if (!oldNode.hasLeftSibling()) {
            parent.setFirstChildKey(oldNode.getRightSiblingKey());
        }
        if (!oldNode.hasRightSibling()) {
            parent.setLastChildKey(oldNode.getLeftSiblingKey());
        }
        if (this.storeChildCount) {
            parent.decrementChildCount();
        }
        if (oldNode.getKind() == NodeKind.ELEMENT) {
            this.moveTo(oldNode.getNodeKey());
        }
        this.moveTo(oldNode.getNodeKey());
        this.pageTrx.removeRecord(oldNode.getNodeKey(), IndexType.DOCUMENT, -1);
    }

    @Override
    protected void serializeUpdateDiffs(int revisionNumber) {
        if (!this.nodeHashing.isBulkInsert() && revisionNumber - 1 > 0) {
            JsonDiffSerializer diffSerializer = new JsonDiffSerializer(this.databaseName, (JsonResourceSession)((Object)this.resourceSession), this.beforeBulkInsertionRevisionNumber != 0 && this.isAutoCommitting ? this.beforeBulkInsertionRevisionNumber : revisionNumber - 1, revisionNumber, this.storeDeweyIDs() ? this.updateOperationsOrdered.values() : this.updateOperationsUnordered.values());
            String jsonDiff = diffSerializer.serialize(false);
            Path diff = this.resourceSession.getResourceConfig().getResource().resolve(ResourceConfiguration.ResourcePaths.UPDATE_OPERATIONS.getPath()).resolve("diffFromRev" + (revisionNumber - 1) + "toRev" + revisionNumber + ".json");
            try {
                Files.writeString(diff, (CharSequence)jsonDiff, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (this.storeDeweyIDs()) {
                this.updateOperationsOrdered.clear();
            } else {
                this.updateOperationsUnordered.clear();
            }
        }
    }

    @Override
    protected JsonNodeTrx self() {
        return this;
    }

    @Override
    protected AbstractNodeHashing<ImmutableNode, JsonNodeReadOnlyTrx> reInstantiateNodeHashing(PageTrx pageTrx) {
        return new JsonNodeHashing(this.resourceSession.getResourceConfig(), (InternalJsonNodeReadOnlyTrx)this.nodeReadOnlyTrx, pageTrx);
    }

    @Override
    protected JsonNodeFactory reInstantiateNodeFactory(PageTrx pageTrx) {
        return new JsonNodeFactoryImpl(this.hashFunction, pageTrx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx copySubtreeAsFirstChild(JsonNodeReadOnlyTrx rtx) {
        Objects.requireNonNull(rtx);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            long nodeKey = this.getCurrentNode().getNodeKey();
            this.copy(rtx, InsertPosition.AS_FIRST_CHILD);
            this.moveTo(nodeKey);
            this.moveToFirstChild();
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx copySubtreeAsLeftSibling(JsonNodeReadOnlyTrx rtx) {
        Objects.requireNonNull(rtx);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            long nodeKey = this.getCurrentNode().getNodeKey();
            this.copy(rtx, InsertPosition.AS_LEFT_SIBLING);
            this.moveTo(nodeKey);
            this.moveToFirstChild();
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNodeTrx copySubtreeAsRightSibling(JsonNodeReadOnlyTrx rtx) {
        Objects.requireNonNull(rtx);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            long nodeKey = this.getCurrentNode().getNodeKey();
            this.copy(rtx, InsertPosition.AS_RIGHT_SIBLING);
            this.moveTo(nodeKey);
            this.moveToRightSibling();
            JsonNodeTrxImpl jsonNodeTrxImpl = this;
            return jsonNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void copy(JsonNodeReadOnlyTrx trx, InsertPosition insert) {
        assert (trx != null);
        assert (insert != null);
        JsonNodeReadOnlyTrx rtx = (JsonNodeReadOnlyTrx)trx.getResourceSession().beginNodeReadOnlyTrx(trx.getRevisionNumber());
        assert (rtx.getRevisionNumber() == trx.getRevisionNumber());
        rtx.moveTo(trx.getNodeKey());
        assert (rtx.getNodeKey() == trx.getNodeKey());
        if (rtx.getKind() == NodeKind.JSON_DOCUMENT) {
            rtx.moveToFirstChild();
        }
        NodeKind kind = rtx.getKind();
        block0 : switch (kind) {
            case NULL_VALUE: {
                switch (insert) {
                    case AS_FIRST_CHILD: {
                        this.insertNullValueAsFirstChild();
                        break block0;
                    }
                    case AS_LEFT_SIBLING: {
                        this.insertNullValueAsLeftSibling();
                        break block0;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.insertNullValueAsRightSibling();
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case STRING_VALUE: {
                String textValue = rtx.getValue();
                switch (insert) {
                    case AS_FIRST_CHILD: {
                        this.insertStringValueAsFirstChild(textValue);
                        break block0;
                    }
                    case AS_LEFT_SIBLING: {
                        this.insertStringValueAsLeftSibling(textValue);
                        break block0;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.insertStringValueAsRightSibling(textValue);
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case BOOLEAN_VALUE: {
                switch (insert) {
                    case AS_FIRST_CHILD: {
                        this.insertBooleanValueAsFirstChild(rtx.getBooleanValue());
                        break block0;
                    }
                    case AS_LEFT_SIBLING: {
                        this.insertBooleanValueAsLeftSibling(rtx.getBooleanValue());
                        break block0;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.insertBooleanValueAsRightSibling(rtx.getBooleanValue());
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case NUMBER_VALUE: {
                switch (insert) {
                    case AS_FIRST_CHILD: {
                        this.insertNumberValueAsFirstChild(rtx.getNumberValue());
                        break block0;
                    }
                    case AS_LEFT_SIBLING: {
                        this.insertNumberValueAsLeftSibling(rtx.getNumberValue());
                        break block0;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.insertNumberValueAsRightSibling(rtx.getNumberValue());
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        rtx.close();
    }

    private static final class JsonNodeTrxThreadFactory
    implements ThreadFactory {
        private JsonNodeTrxThreadFactory() {
        }

        @Override
        public Thread newThread(@NonNull Runnable runnable) {
            Thread thread = new Thread(runnable, "JsonNodeTrxCommitThread");
            thread.setPriority(5);
            thread.setDaemon(false);
            return thread;
        }
    }
}

