/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node.xml;

import io.brackit.query.atomic.QNm;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.exception.SirixException;
import io.sirix.index.IndexType;
import io.sirix.node.NodeKind;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.xml.TextNode;
import io.sirix.settings.Fixed;

public enum InsertPos {
    ASFIRSTCHILD{

        @Override
        void processMove(StructNode fromNode, StructNode toNode, XmlNodeTrx wtx) {
            StructNode moved;
            assert (fromNode != null);
            assert (toNode != null);
            assert (wtx != null);
            StructNode newParent = (StructNode)wtx.getPageWtx().prepareRecordForModification(toNode.getNodeKey(), IndexType.DOCUMENT, -1);
            if (fromNode.getParentKey() != toNode.getNodeKey()) {
                newParent.incrementChildCount();
            }
            if (toNode.hasFirstChild()) {
                wtx.moveTo(toNode.getFirstChildKey());
                if (wtx.getKind() == NodeKind.TEXT && fromNode.getKind() == NodeKind.TEXT) {
                    StringBuilder builder = new StringBuilder(wtx.getValue());
                    wtx.moveTo(wtx.getRightSiblingKey());
                    TextNode moved2 = (TextNode)wtx.getPageWtx().prepareRecordForModification(fromNode.getNodeKey(), IndexType.DOCUMENT, -1);
                    moved2.setRightSiblingKey(wtx.getNodeKey());
                    wtx.moveTo(moved2.getNodeKey());
                    builder.insert(0, wtx.getValue());
                    wtx.setValue(builder.toString());
                    wtx.moveTo(toNode.getFirstChildKey());
                    wtx.remove();
                    wtx.moveTo(moved2.getRightSiblingKey());
                    StructNode rightSibling = (StructNode)wtx.getPageWtx().prepareRecordForModification(wtx.getNodeKey(), IndexType.DOCUMENT, -1);
                    rightSibling.setLeftSiblingKey(fromNode.getNodeKey());
                } else {
                    StructNode oldFirstChild = (StructNode)wtx.getPageWtx().prepareRecordForModification(toNode.getFirstChildKey(), IndexType.DOCUMENT, -1);
                    oldFirstChild.setLeftSiblingKey(fromNode.getNodeKey());
                    StructNode moved3 = (StructNode)wtx.getPageWtx().prepareRecordForModification(fromNode.getNodeKey(), IndexType.DOCUMENT, -1);
                    moved3.setRightSiblingKey(oldFirstChild.getNodeKey());
                }
            } else {
                moved = (StructNode)wtx.getPageWtx().prepareRecordForModification(fromNode.getNodeKey(), IndexType.DOCUMENT, -1);
                moved.setRightSiblingKey(Fixed.NULL_NODE_KEY.getStandardProperty());
            }
            newParent = (StructNode)wtx.getPageWtx().prepareRecordForModification(toNode.getNodeKey(), IndexType.DOCUMENT, -1);
            newParent.setFirstChildKey(fromNode.getNodeKey());
            moved = (StructNode)wtx.getPageWtx().prepareRecordForModification(fromNode.getNodeKey(), IndexType.DOCUMENT, -1);
            moved.setLeftSiblingKey(Fixed.NULL_NODE_KEY.getStandardProperty());
            moved.setParentKey(toNode.getNodeKey());
        }

        @Override
        void insertNode(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
            assert (wtx != null);
            assert (rtx != null);
            assert (wtx.getKind() == NodeKind.ELEMENT || wtx.getKind() == NodeKind.XML_DOCUMENT);
            switch (rtx.getKind()) {
                case ELEMENT: {
                    wtx.insertElementAsFirstChild(rtx.getName());
                    break;
                }
                case TEXT: {
                    assert (wtx.getKind() == NodeKind.ELEMENT);
                    wtx.insertTextAsFirstChild(rtx.getValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Node type not known!");
                }
            }
        }
    }
    ,
    ASRIGHTSIBLING{

        @Override
        void processMove(StructNode fromNode, StructNode toNode, XmlNodeTrx wtx) {
            assert (fromNode != null);
            assert (toNode != null);
            assert (wtx != null);
            if (fromNode.getParentKey() != toNode.getParentKey()) {
                StructNode parentNode = (StructNode)wtx.getPageWtx().prepareRecordForModification(toNode.getParentKey(), IndexType.DOCUMENT, -1);
                parentNode.incrementChildCount();
            }
            boolean hasMoved = wtx.moveTo(toNode.getRightSiblingKey());
            if (fromNode.getKind() == NodeKind.TEXT && toNode.getKind() == NodeKind.TEXT) {
                wtx.moveTo(toNode.getNodeKey());
                builder = new StringBuilder(wtx.getValue());
                if (toNode.hasRightSibling()) {
                    StructNode rightSibling = (StructNode)wtx.getPageWtx().prepareRecordForModification(wtx.getRightSiblingKey(), IndexType.DOCUMENT, -1);
                    rightSibling.setLeftSiblingKey(fromNode.getNodeKey());
                }
                TextNode movedNode = (TextNode)wtx.getPageWtx().prepareRecordForModification(fromNode.getNodeKey(), IndexType.DOCUMENT, -1);
                movedNode.setRightSiblingKey(toNode.getRightSiblingKey());
                movedNode.setLeftSiblingKey(wtx.getLeftSiblingKey());
                wtx.moveTo(movedNode.getNodeKey());
                builder.append(wtx.getValue());
                wtx.setValue(builder.toString());
                StructNode insertAnchor = (StructNode)wtx.getPageWtx().prepareRecordForModification(toNode.getNodeKey(), IndexType.DOCUMENT, -1);
                insertAnchor.setRightSiblingKey(fromNode.getNodeKey());
                wtx.moveTo(toNode.getNodeKey());
                wtx.remove();
            } else if (hasMoved && fromNode.getKind() == NodeKind.TEXT && wtx.getKind() == NodeKind.TEXT) {
                builder = new StringBuilder(wtx.getValue());
                StructNode rightSibling = (StructNode)wtx.getPageWtx().prepareRecordForModification(wtx.getNodeKey(), IndexType.DOCUMENT, -1);
                rightSibling.setLeftSiblingKey(fromNode.getNodeKey());
                TextNode movedNode = (TextNode)wtx.getPageWtx().prepareRecordForModification(fromNode.getNodeKey(), IndexType.DOCUMENT, -1);
                movedNode.setRightSiblingKey(rightSibling.getNodeKey());
                movedNode.setLeftSiblingKey(toNode.getNodeKey());
                wtx.moveTo(movedNode.getNodeKey());
                builder.insert(0, wtx.getValue());
                wtx.setValue(builder.toString());
                wtx.moveTo(toNode.getRightSiblingKey());
                wtx.remove();
                StructNode insertAnchor = (StructNode)wtx.getPageWtx().prepareRecordForModification(toNode.getNodeKey(), IndexType.DOCUMENT, -1);
                insertAnchor.setRightSiblingKey(fromNode.getNodeKey());
            } else {
                StructNode insertAnchor = (StructNode)wtx.getPageWtx().prepareRecordForModification(toNode.getNodeKey(), IndexType.DOCUMENT, -1);
                long rightSiblKey = insertAnchor.getRightSiblingKey();
                insertAnchor.setRightSiblingKey(fromNode.getNodeKey());
                if (rightSiblKey > -1L) {
                    StructNode oldRightSibling = (StructNode)wtx.getPageWtx().prepareRecordForModification(rightSiblKey, IndexType.DOCUMENT, -1);
                    oldRightSibling.setLeftSiblingKey(fromNode.getNodeKey());
                }
                StructNode movedNode = (StructNode)wtx.getPageWtx().prepareRecordForModification(fromNode.getNodeKey(), IndexType.DOCUMENT, -1);
                movedNode.setRightSiblingKey(rightSiblKey);
                movedNode.setLeftSiblingKey(insertAnchor.getNodeKey());
            }
            StructNode movedNode = (StructNode)wtx.getPageWtx().prepareRecordForModification(fromNode.getNodeKey(), IndexType.DOCUMENT, -1);
            movedNode.setParentKey(toNode.getParentKey());
        }

        @Override
        void insertNode(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
            assert (wtx != null);
            assert (rtx != null);
            assert (wtx.getKind() == NodeKind.ELEMENT || wtx.getKind() == NodeKind.TEXT);
            switch (rtx.getKind()) {
                case ELEMENT: {
                    wtx.insertElementAsRightSibling(rtx.getName());
                    break;
                }
                case TEXT: {
                    wtx.insertTextAsRightSibling(rtx.getValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Node type not known!");
                }
            }
        }
    }
    ,
    ASNONSTRUCTURAL{

        @Override
        void processMove(StructNode fromNode, StructNode toNode, XmlNodeTrx wtx) {
            throw new AssertionError((Object)"May never be invoked!");
        }

        @Override
        void insertNode(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
            assert (wtx != null);
            assert (rtx != null);
            assert (wtx.getKind() == NodeKind.ELEMENT);
            switch (rtx.getKind()) {
                case NAMESPACE: {
                    QNm name = rtx.getName();
                    wtx.insertNamespace(new QNm(name.getNamespaceURI(), name.getLocalName(), ""));
                    wtx.moveToParent();
                    break;
                }
                case ATTRIBUTE: {
                    wtx.insertAttribute(rtx.getName(), rtx.getValue());
                    wtx.moveToParent();
                    break;
                }
                default: {
                    throw new IllegalStateException("Only namespace- and attribute-nodes are permitted!");
                }
            }
        }
    }
    ,
    ASLEFTSIBLING{

        @Override
        void processMove(StructNode fromNode, StructNode toNode, XmlNodeTrx wtx) {
            throw new UnsupportedOperationException();
        }

        @Override
        void insertNode(XmlNodeTrx wtx, XmlNodeReadOnlyTrx rtx) {
            assert (wtx != null);
            assert (rtx != null);
            assert (wtx.getKind() == NodeKind.ELEMENT || wtx.getKind() == NodeKind.TEXT);
            switch (rtx.getKind()) {
                case ELEMENT: {
                    wtx.insertElementAsLeftSibling(rtx.getName());
                    break;
                }
                case TEXT: {
                    wtx.insertTextAsLeftSibling(rtx.getValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Node type not known!");
                }
            }
        }
    };


    abstract void processMove(StructNode var1, StructNode var2, XmlNodeTrx var3) throws SirixException;

    abstract void insertNode(XmlNodeTrx var1, XmlNodeReadOnlyTrx var2) throws SirixException;
}

