/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node.xml;

import io.brackit.query.atomic.QNm;
import io.brackit.query.util.path.Path;
import io.brackit.query.util.path.PathParser;
import io.sirix.access.trx.node.AbstractIndexController;
import io.sirix.api.PageTrx;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.index.ChangeListener;
import io.sirix.index.IndexBuilder;
import io.sirix.index.IndexDef;
import io.sirix.index.Indexes;
import io.sirix.index.cas.xml.XmlCASIndexImpl;
import io.sirix.index.name.xml.XmlNameIndexImpl;
import io.sirix.index.path.PathFilter;
import io.sirix.index.path.summary.PathSummaryReader;
import io.sirix.index.path.xml.XmlPCRCollector;
import io.sirix.index.path.xml.XmlPathIndexImpl;
import java.util.HashSet;
import java.util.Set;

public final class XmlIndexController
extends AbstractIndexController<XmlNodeReadOnlyTrx, XmlNodeTrx> {
    public XmlIndexController() {
        super(new Indexes(), new HashSet<ChangeListener>(), new XmlPathIndexImpl(), new XmlCASIndexImpl(), new XmlNameIndexImpl());
    }

    @Override
    protected Path<QNm> parsePath(String path) {
        return Path.parse((String)path, (PathParser.Type)PathParser.Type.XML);
    }

    public XmlIndexController createIndexes(Set<IndexDef> indexDefs, XmlNodeTrx nodeWriteTrx) {
        IndexBuilder.build(nodeWriteTrx, this.createIndexBuilders(indexDefs, nodeWriteTrx));
        this.createIndexListeners(indexDefs, nodeWriteTrx);
        return this;
    }

    Set<XmlNodeVisitor> createIndexBuilders(Set<IndexDef> indexDefs, XmlNodeTrx nodeWriteTrx) {
        HashSet<XmlNodeVisitor> indexBuilders = new HashSet<XmlNodeVisitor>(indexDefs.size());
        for (IndexDef indexDef : indexDefs) {
            this.indexes.add(indexDef);
            switch (indexDef.getType()) {
                case PATH: {
                    indexBuilders.add(this.createPathIndexBuilder(nodeWriteTrx.getPageWtx(), nodeWriteTrx.getPathSummary(), indexDef));
                    break;
                }
                case CAS: {
                    indexBuilders.add(this.createCASIndexBuilder(nodeWriteTrx, nodeWriteTrx.getPageWtx(), nodeWriteTrx.getPathSummary(), indexDef));
                    break;
                }
                case NAME: {
                    indexBuilders.add(this.createNameIndexBuilder(nodeWriteTrx.getPageWtx(), indexDef));
                    break;
                }
            }
        }
        return indexBuilders;
    }

    @Override
    public PathFilter createPathFilter(Set<String> stringPaths, XmlNodeReadOnlyTrx rtx) {
        HashSet<Path<QNm>> paths = new HashSet<Path<QNm>>(stringPaths.size());
        for (String path : stringPaths) {
            paths.add((Path<QNm>)Path.parse((String)path, (PathParser.Type)PathParser.Type.XML));
        }
        return new PathFilter(paths, new XmlPCRCollector(rtx));
    }

    private XmlNodeVisitor createPathIndexBuilder(PageTrx pageTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        return (XmlNodeVisitor)this.pathIndex.createBuilder(pageTrx, pathSummaryReader, indexDef);
    }

    private XmlNodeVisitor createCASIndexBuilder(XmlNodeReadOnlyTrx nodeReadTrx, PageTrx pageTrx, PathSummaryReader pathSummaryReader, IndexDef indexDef) {
        return (XmlNodeVisitor)this.casIndex.createBuilder(nodeReadTrx, pageTrx, pathSummaryReader, indexDef);
    }

    private XmlNodeVisitor createNameIndexBuilder(PageTrx pageWriteTrx, IndexDef indexDef) {
        return (XmlNodeVisitor)this.nameIndex.createBuilder(pageWriteTrx, indexDef);
    }
}

