/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node.xml;

import com.google.common.base.Preconditions;
import io.brackit.query.atomic.QNm;
import io.sirix.access.trx.node.AbstractNodeHashing;
import io.sirix.access.trx.node.AbstractNodeTrxImpl;
import io.sirix.access.trx.node.AfterCommitState;
import io.sirix.access.trx.node.IndexController;
import io.sirix.access.trx.node.InternalResourceSession;
import io.sirix.access.trx.node.RecordToRevisionsIndex;
import io.sirix.access.trx.node.xml.ForwardingXmlNodeReadOnlyTrx;
import io.sirix.access.trx.node.xml.InsertPos;
import io.sirix.access.trx.node.xml.InternalXmlNodeReadOnlyTrx;
import io.sirix.access.trx.node.xml.InternalXmlNodeTrx;
import io.sirix.access.trx.node.xml.XmlDeweyIDManager;
import io.sirix.access.trx.node.xml.XmlNodeFactory;
import io.sirix.access.trx.node.xml.XmlNodeFactoryImpl;
import io.sirix.access.trx.node.xml.XmlNodeHashing;
import io.sirix.api.Movement;
import io.sirix.api.PageTrx;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.axis.DescendantAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.axis.PostOrderAxis;
import io.sirix.exception.SirixIOException;
import io.sirix.exception.SirixUsageException;
import io.sirix.index.IndexType;
import io.sirix.index.path.summary.PathSummaryWriter;
import io.sirix.node.AbstractForwardingNode;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.immutable.xml.ImmutableAttributeNode;
import io.sirix.node.immutable.xml.ImmutableNamespace;
import io.sirix.node.interfaces.NameNode;
import io.sirix.node.interfaces.Node;
import io.sirix.node.interfaces.StructNode;
import io.sirix.node.interfaces.ValueNode;
import io.sirix.node.interfaces.immutable.ImmutableNameNode;
import io.sirix.node.interfaces.immutable.ImmutableNode;
import io.sirix.node.interfaces.immutable.ImmutableXmlNode;
import io.sirix.node.xml.AttributeNode;
import io.sirix.node.xml.CommentNode;
import io.sirix.node.xml.ElementNode;
import io.sirix.node.xml.NamespaceNode;
import io.sirix.node.xml.PINode;
import io.sirix.node.xml.TextNode;
import io.sirix.page.NamePage;
import io.sirix.service.InsertPosition;
import io.sirix.service.xml.serialize.StAXSerializer;
import io.sirix.service.xml.shredder.XmlShredder;
import io.sirix.settings.Constants;
import io.sirix.settings.Fixed;
import io.sirix.utils.XMLToken;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import net.openhft.chronicle.bytes.Bytes;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class XmlNodeTrxImpl
extends AbstractNodeTrxImpl<XmlNodeReadOnlyTrx, XmlNodeTrx, XmlNodeFactory, ImmutableXmlNode, InternalXmlNodeReadOnlyTrx>
implements InternalXmlNodeTrx,
ForwardingXmlNodeReadOnlyTrx {
    private final Bytes<ByteBuffer> bytes = Bytes.elasticHeapByteBuffer();
    private final XmlDeweyIDManager deweyIDManager;
    private final boolean useTextCompression;
    private final boolean storeChildCount;

    XmlNodeTrxImpl(InternalResourceSession<XmlNodeReadOnlyTrx, XmlNodeTrx> resourceManager, InternalXmlNodeReadOnlyTrx nodeReadOnlyTrx, PathSummaryWriter<XmlNodeReadOnlyTrx> pathSummaryWriter, @NonNegative int maxNodeCount, @Nullable Lock transactionLock, Duration afterCommitDelay, @NonNull XmlNodeHashing nodeHashing, XmlNodeFactory nodeFactory, @NonNull AfterCommitState afterCommitState, RecordToRevisionsIndex nodeToRevisionsIndex) {
        super(Executors.defaultThreadFactory(), resourceManager.getResourceConfig().hashType, nodeReadOnlyTrx, nodeReadOnlyTrx, resourceManager, afterCommitState, nodeHashing, pathSummaryWriter, nodeFactory, nodeToRevisionsIndex, transactionLock, afterCommitDelay, maxNodeCount);
        this.indexController = resourceManager.getWtxIndexController(nodeReadOnlyTrx.getPageTrx().getRevisionNumber());
        this.storeChildCount = this.resourceSession.getResourceConfig().storeChildCount();
        this.useTextCompression = resourceManager.getResourceConfig().useTextCompression;
        this.deweyIDManager = new XmlDeweyIDManager(this);
    }

    @Override
    public XmlNodeReadOnlyTrx nodeReadOnlyTrxDelegate() {
        return (XmlNodeReadOnlyTrx)((Object)this.nodeReadOnlyTrx);
    }

    @Override
    public XmlNodeTrx moveSubtreeToFirstChild(@NonNegative long fromKey) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            Preconditions.checkArgument((fromKey >= 0L && fromKey <= this.getMaxNodeKey() ? 1 : 0) != 0, (Object)"Argument must be a valid node key!");
            Preconditions.checkArgument((fromKey != ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey() ? 1 : 0) != 0, (Object)"Can't move itself to first child of itself!");
            Object node = this.pageTrx.getRecord(fromKey, IndexType.DOCUMENT, -1);
            if (node == null) {
                throw new IllegalStateException("Node to move must exist!");
            }
            Object nodeToMove = node;
            if (nodeToMove instanceof StructNode && ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.ELEMENT) {
                this.checkAncestors((Node)nodeToMove);
                this.checkAccessAndCommit();
                ElementNode nodeAnchor = (ElementNode)this.getCurrentNode();
                if (nodeAnchor.getFirstChildKey() != nodeToMove.getNodeKey()) {
                    StructNode toMove = (StructNode)nodeToMove;
                    this.adaptSubtreeForMove(toMove, IndexController.ChangeType.DELETE);
                    this.adaptHashesForMove(toMove);
                    this.adaptForMove(toMove, nodeAnchor, InsertPos.ASFIRSTCHILD);
                    ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(toMove.getNodeKey());
                    this.nodeHashing.adaptHashesWithAdd();
                    if (this.buildPathSummary && toMove instanceof NameNode) {
                        NameNode moved = (NameNode)((Object)toMove);
                        this.pathSummaryWriter.adaptPathForChangedNode(moved, this.getName(), moved.getURIKey(), moved.getPrefixKey(), moved.getLocalNameKey(), PathSummaryWriter.OPType.MOVED);
                    }
                    this.adaptSubtreeForMove(toMove, IndexController.ChangeType.INSERT);
                    if (this.storeDeweyIDs()) {
                        this.deweyIDManager.computeNewDeweyIDs();
                    }
                }
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Move is not allowed if moved node is not an ElementNode and the node isn't inserted at an element node!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void adaptSubtreeForMove(Node node, IndexController.ChangeType type) throws SirixIOException {
        assert (type != null);
        long beforeNodeKey = this.getNode().getNodeKey();
        this.moveTo(node.getNodeKey());
        DescendantAxis axis = new DescendantAxis(this, IncludeSelf.YES);
        while (axis.hasNext()) {
            int i;
            axis.nextLong();
            int attCount = this.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                this.moveToAttribute(i);
                ImmutableAttributeNode att = (ImmutableAttributeNode)this.getNode();
                this.indexController.notifyChange(type, att, att.getPathNodeKey());
                this.moveToParent();
            }
            int nspCount = this.getNamespaceCount();
            for (i = 0; i < nspCount; ++i) {
                this.moveToAttribute(i);
                ImmutableNamespace nsp = (ImmutableNamespace)this.getNode();
                this.indexController.notifyChange(type, nsp, nsp.getPathNodeKey());
                this.moveToParent();
            }
            long pathNodeKey = -1L;
            if (this.getNode() instanceof ValueNode && this.getNode().getParentKey() != Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                long nodeKey = this.getNode().getNodeKey();
                this.moveToParent();
                pathNodeKey = this.getNameNode().getPathNodeKey();
                this.moveTo(nodeKey);
            } else if (this.getNode() instanceof NameNode) {
                pathNodeKey = this.getNameNode().getPathNodeKey();
            }
            this.indexController.notifyChange(type, this.getNode(), pathNodeKey);
        }
        this.moveTo(beforeNodeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx moveSubtreeToLeftSibling(@NonNegative long fromKey) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode().hasLeftSibling()) {
                this.moveToLeftSibling();
                XmlNodeTrx xmlNodeTrx = this.moveSubtreeToRightSibling(fromKey);
                return xmlNodeTrx;
            }
            this.moveToParent();
            XmlNodeTrx xmlNodeTrx = this.moveSubtreeToFirstChild(fromKey);
            return xmlNodeTrx;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public XmlNodeTrx moveSubtreeToRightSibling(@NonNegative long fromKey) {
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (fromKey < 0L || fromKey > this.getMaxNodeKey()) {
                throw new IllegalArgumentException("Argument must be a valid node key!");
            }
            if (fromKey == ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey()) {
                throw new IllegalArgumentException("Can't move itself to first child of itself!");
            }
            Object node = this.pageTrx.getRecord(fromKey, IndexType.DOCUMENT, -1);
            if (node == null) {
                throw new IllegalStateException("Node to move must exist: " + fromKey);
            }
            Object nodeToMove = node;
            if (nodeToMove instanceof StructNode) {
                StructNode toMove = (StructNode)nodeToMove;
                Object object = this.getCurrentNode();
                if (object instanceof StructNode) {
                    StructNode nodeAnchor = (StructNode)object;
                    this.checkAncestors(toMove);
                    this.checkAccessAndCommit();
                    if (nodeAnchor.getRightSiblingKey() != nodeToMove.getNodeKey()) {
                        long parentKey = nodeAnchor.getParentKey();
                        this.adaptHashesForMove(toMove);
                        this.adaptForMove(toMove, nodeAnchor, InsertPos.ASRIGHTSIBLING);
                        ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).moveTo(toMove.getNodeKey());
                        this.nodeHashing.adaptHashesWithAdd();
                        if (this.buildPathSummary && toMove instanceof NameNode) {
                            PathSummaryWriter.OPType type;
                            NameNode moved = (NameNode)((Object)toMove);
                            PathSummaryWriter.OPType oPType = type = moved.getParentKey() == parentKey ? PathSummaryWriter.OPType.MOVED_ON_SAME_LEVEL : PathSummaryWriter.OPType.MOVED;
                            if (type != PathSummaryWriter.OPType.MOVED_ON_SAME_LEVEL) {
                                this.pathSummaryWriter.adaptPathForChangedNode(moved, this.getName(), moved.getURIKey(), moved.getPrefixKey(), moved.getLocalNameKey(), type);
                            }
                        }
                        if (this.storeDeweyIDs()) {
                            this.deweyIDManager.computeNewDeweyIDs();
                        }
                    }
                    object = this;
                    return object;
                }
            }
            throw new SirixUsageException(new String[]{"Move is not allowed if moved node is not an ElementNode or TextNode and the node isn't inserted at an ElementNode or TextNode!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void adaptHashesForMove(StructNode nodeToMove) throws SirixIOException {
        assert (nodeToMove != null);
        ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode((ImmutableXmlNode)((Object)nodeToMove));
        this.nodeHashing.adaptHashesWithRemove();
    }

    private void adaptForMove(StructNode fromNode, StructNode toNode, InsertPos insertPos) {
        assert (fromNode != null);
        assert (toNode != null);
        assert (insertPos != null);
        StructNode parent = (StructNode)this.pageTrx.prepareRecordForModification(fromNode.getParentKey(), IndexType.DOCUMENT, -1);
        switch (insertPos) {
            case ASRIGHTSIBLING: {
                if (fromNode.getParentKey() == toNode.getParentKey() || !this.storeChildCount) break;
                parent.decrementChildCount();
                break;
            }
            case ASFIRSTCHILD: {
                if (fromNode.getParentKey() == toNode.getNodeKey() || !this.storeChildCount) break;
                parent.decrementChildCount();
                break;
            }
            case ASNONSTRUCTURAL: {
                break;
            }
        }
        if (parent.getFirstChildKey() == fromNode.getNodeKey()) {
            parent.setFirstChildKey(fromNode.getRightSiblingKey());
        }
        if (fromNode.hasRightSibling()) {
            StructNode rightSibling = (StructNode)this.pageTrx.prepareRecordForModification(fromNode.getRightSiblingKey(), IndexType.DOCUMENT, -1);
            rightSibling.setLeftSiblingKey(fromNode.getLeftSiblingKey());
        }
        if (fromNode.hasLeftSibling()) {
            StructNode leftSibling = (StructNode)this.pageTrx.prepareRecordForModification(fromNode.getLeftSiblingKey(), IndexType.DOCUMENT, -1);
            leftSibling.setRightSiblingKey(fromNode.getRightSiblingKey());
        }
        if (fromNode.hasLeftSibling() && fromNode.hasRightSibling()) {
            this.moveTo(fromNode.getLeftSiblingKey());
            if (this.getCurrentNode() != null && ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.TEXT) {
                StringBuilder builder = new StringBuilder(this.getValue());
                this.moveTo(fromNode.getRightSiblingKey());
                if (this.getCurrentNode() != null && ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.TEXT) {
                    builder.append(this.getValue());
                    if (fromNode.getRightSiblingKey() == toNode.getNodeKey()) {
                        this.moveTo(fromNode.getLeftSiblingKey());
                        if (((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode().hasLeftSibling()) {
                            StructNode leftSibling = (StructNode)this.pageTrx.prepareRecordForModification(((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode().getLeftSiblingKey(), IndexType.DOCUMENT, -1);
                            leftSibling.setRightSiblingKey(fromNode.getRightSiblingKey());
                        }
                        long leftSiblingKey = ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode().hasLeftSibling() ? ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode().getLeftSiblingKey() : ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                        this.moveTo(fromNode.getRightSiblingKey());
                        StructNode rightSibling = (StructNode)this.pageTrx.prepareRecordForModification(((ImmutableXmlNode)this.getCurrentNode()).getNodeKey(), IndexType.DOCUMENT, -1);
                        rightSibling.setLeftSiblingKey(leftSiblingKey);
                        this.moveTo(fromNode.getLeftSiblingKey());
                        this.remove();
                        this.moveTo(fromNode.getRightSiblingKey());
                    } else {
                        if (((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode().hasRightSibling()) {
                            StructNode rightSibling = (StructNode)this.pageTrx.prepareRecordForModification(((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode().getRightSiblingKey(), IndexType.DOCUMENT, -1);
                            rightSibling.setLeftSiblingKey(fromNode.getLeftSiblingKey());
                        }
                        long rightSiblingKey = ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode().hasRightSibling() ? ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode().getRightSiblingKey() : ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                        this.moveTo(fromNode.getLeftSiblingKey());
                        StructNode leftSibling = (StructNode)this.pageTrx.prepareRecordForModification(((ImmutableXmlNode)this.getCurrentNode()).getNodeKey(), IndexType.DOCUMENT, -1);
                        leftSibling.setRightSiblingKey(rightSiblingKey);
                        this.moveTo(fromNode.getRightSiblingKey());
                        this.remove();
                        this.moveTo(fromNode.getLeftSiblingKey());
                    }
                    this.setValue(builder.toString());
                }
            }
        }
        insertPos.processMove(fromNode, toNode, this);
    }

    @Override
    public XmlNodeTrx insertElementAsFirstChild(QNm name) {
        if (!XMLToken.isValidQName(Objects.requireNonNull(name))) {
            throw new IllegalArgumentException("The QName is not valid!");
        }
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            NodeKind kind = ((ImmutableXmlNode)((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode()).getKind();
            if (kind == NodeKind.ELEMENT || kind == NodeKind.XML_DOCUMENT) {
                this.checkAccessAndCommit();
                long parentKey = ((ImmutableXmlNode)((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode()).getNodeKey();
                long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                long rightSibKey = ((StructNode)((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode()).getFirstChildKey();
                long pathNodeKey = this.buildPathSummary ? this.pathSummaryWriter.getPathNodeKey(name, NodeKind.ELEMENT) : 0L;
                SirixDeweyID id = this.deweyIDManager.newFirstChildID();
                ElementNode node = ((XmlNodeFactory)this.nodeFactory).createElementNode(parentKey, leftSibKey, rightSibKey, name, pathNodeKey, id);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.adaptForInsert(node, InsertPos.ASFIRSTCHILD);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.nodeHashing.adaptHashesWithAdd();
                this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an ElementNode!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public XmlNodeTrx insertElementAsLeftSibling(QNm name) {
        if (!XMLToken.isValidQName(Objects.requireNonNull(name))) {
            throw new IllegalArgumentException("The QName is not valid!");
        }
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getCurrentNode() instanceof StructNode && ((ImmutableXmlNode)this.getCurrentNode()).getKind() != NodeKind.XML_DOCUMENT) {
                this.checkAccessAndCommit();
                long key = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                this.moveToParent();
                long pathNodeKey = this.buildPathSummary ? this.pathSummaryWriter.getPathNodeKey(name, NodeKind.ELEMENT) : 0L;
                this.moveTo(key);
                long parentKey = ((ImmutableXmlNode)this.getCurrentNode()).getParentKey();
                long leftSibKey = ((StructNode)this.getCurrentNode()).getLeftSiblingKey();
                long rightSibKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                SirixDeweyID id = this.deweyIDManager.newLeftSiblingID();
                ElementNode node = ((XmlNodeFactory)this.nodeFactory).createElementNode(parentKey, leftSibKey, rightSibKey, name, pathNodeKey, id);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.adaptForInsert(node, InsertPos.ASLEFTSIBLING);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.nodeHashing.adaptHashesWithAdd();
                this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an StructuralNode (either Text or Element)!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx insertElementAsRightSibling(QNm name) {
        if (!XMLToken.isValidQName(Objects.requireNonNull(name))) {
            throw new IllegalArgumentException("The QName is not valid!");
        }
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (!(this.getCurrentNode() instanceof StructNode) || this.isDocumentRoot()) {
                throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an StructuralNode (either Text or Element)!"});
            }
            this.checkAccessAndCommit();
            long key = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
            this.moveToParent();
            long pathNodeKey = this.buildPathSummary ? this.pathSummaryWriter.getPathNodeKey(name, NodeKind.ELEMENT) : 0L;
            this.moveTo(key);
            long parentKey = ((ImmutableXmlNode)this.getCurrentNode()).getParentKey();
            long leftSibKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
            long rightSibKey = ((StructNode)this.getCurrentNode()).getRightSiblingKey();
            SirixDeweyID id = this.deweyIDManager.newRightSiblingID();
            ElementNode node = ((XmlNodeFactory)this.nodeFactory).createElementNode(parentKey, leftSibKey, rightSibKey, name, pathNodeKey, id);
            ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
            this.adaptForInsert(node, InsertPos.ASRIGHTSIBLING);
            ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
            this.nodeHashing.adaptHashesWithAdd();
            this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
            XmlNodeTrxImpl xmlNodeTrxImpl = this;
            return xmlNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public XmlNodeTrx insertSubtreeAsFirstChild(XMLEventReader reader) {
        return this.insertSubtree(reader, InsertPosition.AS_FIRST_CHILD, XmlNodeTrx.Commit.Implicit);
    }

    @Override
    public XmlNodeTrx insertSubtreeAsRightSibling(XMLEventReader reader) {
        return this.insertSubtree(reader, InsertPosition.AS_RIGHT_SIBLING, XmlNodeTrx.Commit.Implicit);
    }

    @Override
    public XmlNodeTrx insertSubtreeAsLeftSibling(XMLEventReader reader) {
        return this.insertSubtree(reader, InsertPosition.AS_LEFT_SIBLING, XmlNodeTrx.Commit.Implicit);
    }

    @Override
    public XmlNodeTrx insertSubtreeAsFirstChild(XMLEventReader reader, XmlNodeTrx.Commit commit) {
        return this.insertSubtree(reader, InsertPosition.AS_FIRST_CHILD, commit);
    }

    @Override
    public XmlNodeTrx insertSubtreeAsRightSibling(XMLEventReader reader, XmlNodeTrx.Commit commit) {
        return this.insertSubtree(reader, InsertPosition.AS_RIGHT_SIBLING, commit);
    }

    @Override
    public XmlNodeTrx insertSubtreeAsLeftSibling(XMLEventReader reader, XmlNodeTrx.Commit commit) {
        return this.insertSubtree(reader, InsertPosition.AS_LEFT_SIBLING, commit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlNodeTrx insertSubtree(XMLEventReader reader, InsertPosition insertionPosition, XmlNodeTrx.Commit commit) {
        Objects.requireNonNull(reader);
        assert (insertionPosition != null);
        try {
            if (insertionPosition != InsertPosition.AS_FIRST_CHILD && !reader.peek().isStartElement() && reader.hasNext()) {
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException(e);
        }
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getCurrentNode() instanceof StructNode) {
                this.checkAccessAndCommit();
                this.nodeHashing.setBulkInsert(true);
                long nodeKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                XmlShredder shredder = new XmlShredder.Builder(this, reader, insertionPosition).build();
                shredder.call();
                this.moveTo(nodeKey);
                switch (insertionPosition) {
                    case AS_FIRST_CHILD: {
                        this.moveToFirstChild();
                        this.nonElementHashes();
                        break;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.moveToRightSibling();
                        break;
                    }
                    case AS_LEFT_SIBLING: {
                        this.moveToLeftSibling();
                        break;
                    }
                }
                this.adaptHashesInPostorderTraversal();
                this.nodeHashing.setBulkInsert(false);
                if (commit == XmlNodeTrx.Commit.Implicit) {
                    this.commit();
                }
            }
            XmlNodeTrxImpl xmlNodeTrxImpl = this;
            return xmlNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void nonElementHashes() {
        while (((ImmutableXmlNode)this.getCurrentNode()).getKind() != NodeKind.ELEMENT) {
            long hashToAdd = ((ImmutableXmlNode)this.getCurrentNode()).computeHash(this.bytes);
            Node node = (Node)this.pageTrx.prepareRecordForModification(((ImmutableXmlNode)((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode()).getNodeKey(), IndexType.DOCUMENT, -1);
            node.setHash(hashToAdd);
            this.moveToRightSibling();
        }
    }

    @Override
    public XmlNodeTrx insertPIAsLeftSibling(String target, @NonNull String content) {
        return this.pi(target, content, InsertPosition.AS_LEFT_SIBLING);
    }

    @Override
    public XmlNodeTrx insertPIAsRightSibling(String target, @NonNull String content) {
        return this.pi(target, content, InsertPosition.AS_RIGHT_SIBLING);
    }

    @Override
    public XmlNodeTrx insertPIAsFirstChild(String target, @NonNull String content) {
        return this.pi(target, content, InsertPosition.AS_FIRST_CHILD);
    }

    private XmlNodeTrx pi(String target, String content, InsertPosition insert) {
        byte[] targetBytes = XmlNodeTrxImpl.getBytes(target);
        if (!XMLToken.isNCName(Objects.requireNonNull(targetBytes))) {
            throw new IllegalArgumentException("The target is not valid!");
        }
        if (content.contains("?>-")) {
            throw new SirixUsageException(new String[]{"The content must not contain '?>-'"});
        }
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getCurrentNode() instanceof StructNode) {
                long rightSibKey;
                long leftSibKey;
                long parentKey;
                this.checkAccessAndCommit();
                byte[] processingContent = XmlNodeTrxImpl.getBytes(content);
                InsertPos pos = InsertPos.ASFIRSTCHILD;
                SirixDeweyID id = switch (insert) {
                    case InsertPosition.AS_FIRST_CHILD -> {
                        parentKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                        leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                        rightSibKey = ((StructNode)this.getCurrentNode()).getFirstChildKey();
                        yield this.deweyIDManager.newFirstChildID();
                    }
                    case InsertPosition.AS_RIGHT_SIBLING -> {
                        parentKey = ((ImmutableXmlNode)this.getCurrentNode()).getParentKey();
                        leftSibKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                        rightSibKey = ((StructNode)this.getCurrentNode()).getRightSiblingKey();
                        pos = InsertPos.ASRIGHTSIBLING;
                        yield this.deweyIDManager.newRightSiblingID();
                    }
                    case InsertPosition.AS_LEFT_SIBLING -> {
                        parentKey = ((ImmutableXmlNode)this.getCurrentNode()).getParentKey();
                        leftSibKey = ((StructNode)this.getCurrentNode()).getLeftSiblingKey();
                        rightSibKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                        pos = InsertPos.ASLEFTSIBLING;
                        yield this.deweyIDManager.newLeftSiblingID();
                    }
                    default -> throw new IllegalStateException("Insert location not known!");
                };
                QNm targetName = new QNm(target);
                long pathNodeKey = this.buildPathSummary ? this.pathSummaryWriter.getPathNodeKey(targetName, NodeKind.PROCESSING_INSTRUCTION) : 0L;
                PINode node = ((XmlNodeFactory)this.nodeFactory).createPINode(parentKey, leftSibKey, rightSibKey, targetName, processingContent, this.useTextCompression, pathNodeKey, id);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.adaptForInsert(node, pos);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.nodeHashing.adaptHashesWithAdd();
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Current node must be a structural node!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public XmlNodeTrx insertCommentAsLeftSibling(String value) {
        return this.comment(value, InsertPosition.AS_LEFT_SIBLING);
    }

    @Override
    public XmlNodeTrx insertCommentAsRightSibling(String value) {
        return this.comment(value, InsertPosition.AS_RIGHT_SIBLING);
    }

    @Override
    public XmlNodeTrx insertCommentAsFirstChild(String value) {
        return this.comment(value, InsertPosition.AS_FIRST_CHILD);
    }

    private XmlNodeTrx comment(String value, InsertPosition insert) {
        if (value.contains("--")) {
            throw new SirixUsageException(new String[]{"Character sequence \"--\" is not allowed in comment content!"});
        }
        if (value.endsWith("-")) {
            throw new SirixUsageException(new String[]{"Comment content must not end with \"-\"!"});
        }
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getCurrentNode() instanceof StructNode && (((ImmutableXmlNode)this.getCurrentNode()).getKind() != NodeKind.XML_DOCUMENT || ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.XML_DOCUMENT && insert == InsertPosition.AS_FIRST_CHILD)) {
                InsertPos pos;
                long rightSibKey;
                long leftSibKey;
                long parentKey;
                this.checkAccessAndCommit();
                byte[] commentValue = XmlNodeTrxImpl.getBytes(value);
                CommentNode node = ((XmlNodeFactory)this.nodeFactory).createCommentNode(parentKey, leftSibKey, rightSibKey, commentValue, this.useTextCompression, switch (insert) {
                    case InsertPosition.AS_FIRST_CHILD -> {
                        parentKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                        leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                        rightSibKey = ((StructNode)this.getCurrentNode()).getFirstChildKey();
                        pos = InsertPos.ASFIRSTCHILD;
                        yield this.deweyIDManager.newFirstChildID();
                    }
                    case InsertPosition.AS_RIGHT_SIBLING -> {
                        parentKey = ((ImmutableXmlNode)this.getCurrentNode()).getParentKey();
                        leftSibKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                        rightSibKey = ((StructNode)this.getCurrentNode()).getRightSiblingKey();
                        pos = InsertPos.ASRIGHTSIBLING;
                        yield this.deweyIDManager.newRightSiblingID();
                    }
                    case InsertPosition.AS_LEFT_SIBLING -> {
                        parentKey = ((ImmutableXmlNode)this.getCurrentNode()).getParentKey();
                        leftSibKey = ((StructNode)this.getCurrentNode()).getLeftSiblingKey();
                        rightSibKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                        pos = InsertPos.ASLEFTSIBLING;
                        yield this.deweyIDManager.newLeftSiblingID();
                    }
                    default -> throw new IllegalStateException("Insert location not known!");
                });
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.adaptForInsert(node, pos);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.nodeHashing.adaptHashesWithAdd();
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Current node must be a structural node!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public XmlNodeTrx insertTextAsFirstChild(String value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getCurrentNode() instanceof StructNode && !value.isEmpty()) {
                this.checkAccessAndCommit();
                long pathNodeKey = ((NameNode)this.getCurrentNode()).getPathNodeKey();
                long parentKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                long leftSibKey = Fixed.NULL_NODE_KEY.getStandardProperty();
                long rightSibKey = ((StructNode)this.getCurrentNode()).getFirstChildKey();
                if (this.hasNode(rightSibKey)) {
                    this.moveTo(rightSibKey);
                    if (((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.TEXT) {
                        this.setValue(value + this.getValue());
                        XmlNodeTrxImpl xmlNodeTrxImpl = this;
                        return xmlNodeTrxImpl;
                    }
                    this.moveTo(parentKey);
                }
                byte[] textValue = XmlNodeTrxImpl.getBytes(value);
                SirixDeweyID id = this.deweyIDManager.newFirstChildID();
                TextNode node = ((XmlNodeFactory)this.nodeFactory).createTextNode(parentKey, leftSibKey, rightSibKey, textValue, this.useTextCompression, id);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.adaptForInsert(node, InsertPos.ASFIRSTCHILD);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.nodeHashing.adaptHashesWithAdd();
                this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an ElementNode or TextNode!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public XmlNodeTrx insertTextAsLeftSibling(String value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getCurrentNode() instanceof StructNode && ((ImmutableXmlNode)this.getCurrentNode()).getKind() != NodeKind.XML_DOCUMENT && !value.isEmpty()) {
                this.checkAccessAndCommit();
                long parentKey = ((ImmutableXmlNode)this.getCurrentNode()).getParentKey();
                long leftSibKey = ((StructNode)this.getCurrentNode()).getLeftSiblingKey();
                long rightSibKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                StringBuilder builder = new StringBuilder();
                if (((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.TEXT) {
                    builder.append(value);
                }
                builder.append(this.getValue());
                if (!value.contentEquals(builder)) {
                    this.setValue(builder.toString());
                    XmlNodeTrxImpl xmlNodeTrxImpl = this;
                    return xmlNodeTrxImpl;
                }
                if (this.hasNode(leftSibKey)) {
                    this.moveTo(leftSibKey);
                    StringBuilder valueBuilder = new StringBuilder();
                    if (((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.TEXT) {
                        valueBuilder.append(this.getValue()).append((CharSequence)builder);
                    }
                    if (!value.contentEquals(valueBuilder)) {
                        this.setValue(valueBuilder.toString());
                        XmlNodeTrxImpl xmlNodeTrxImpl = this;
                        return xmlNodeTrxImpl;
                    }
                }
                this.moveTo(rightSibKey);
                byte[] textValue = XmlNodeTrxImpl.getBytes(builder.toString());
                SirixDeweyID id = this.deweyIDManager.newLeftSiblingID();
                TextNode node = ((XmlNodeFactory)this.nodeFactory).createTextNode(parentKey, leftSibKey, rightSibKey, textValue, this.useTextCompression, id);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.adaptForInsert(node, InsertPos.ASLEFTSIBLING);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.nodeHashing.adaptHashesWithAdd();
                this.moveToParent();
                long pathNodeKey = this.isElement() ? this.getNameNode().getPathNodeKey() : -1L;
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an Element- or Text-node!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public XmlNodeTrx insertTextAsRightSibling(String value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getCurrentNode() instanceof StructNode && ((ImmutableXmlNode)this.getCurrentNode()).getKind() != NodeKind.XML_DOCUMENT && !value.isEmpty()) {
                this.checkAccessAndCommit();
                long parentKey = ((ImmutableXmlNode)this.getCurrentNode()).getParentKey();
                long leftSibKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                long rightSibKey = ((StructNode)this.getCurrentNode()).getRightSiblingKey();
                Object currValue = "";
                if (((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.TEXT) {
                    currValue = (String)currValue + this.getValue();
                }
                if (!value.equals(currValue = (String)currValue + value)) {
                    this.setValue((String)currValue);
                    XmlNodeTrxImpl xmlNodeTrxImpl = this;
                    return xmlNodeTrxImpl;
                }
                if (this.hasNode(rightSibKey)) {
                    this.moveTo(rightSibKey);
                    if (((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.TEXT) {
                        currValue = (String)currValue + this.getValue();
                    }
                    if (!value.equals(currValue)) {
                        this.setValue((String)currValue);
                        XmlNodeTrxImpl xmlNodeTrxImpl = this;
                        return xmlNodeTrxImpl;
                    }
                }
                this.moveTo(leftSibKey);
                byte[] textValue = XmlNodeTrxImpl.getBytes((String)currValue);
                SirixDeweyID id = this.deweyIDManager.newRightSiblingID();
                TextNode node = ((XmlNodeFactory)this.nodeFactory).createTextNode(parentKey, leftSibKey, rightSibKey, textValue, this.useTextCompression, id);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.adaptForInsert(node, InsertPos.ASRIGHTSIBLING);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.nodeHashing.adaptHashesWithAdd();
                this.moveToParent();
                long pathNodeKey = this.isElement() ? this.getNameNode().getPathNodeKey() : -1L;
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an Element- or Text-node or value is empty!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private static byte[] getBytes(String value) {
        return value.getBytes(Constants.DEFAULT_ENCODING);
    }

    @Override
    public XmlNodeTrx insertAttribute(QNm name, @NonNull String value) {
        return this.insertAttribute(name, value, Movement.NONE);
    }

    @Override
    public XmlNodeTrx insertAttribute(QNm name, @NonNull String value, @NonNull Movement move) {
        Objects.requireNonNull(value);
        if (!XMLToken.isValidQName(Objects.requireNonNull(name))) {
            throw new IllegalArgumentException("The QName is not valid!");
        }
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.ELEMENT) {
                this.checkAccessAndCommit();
                ElementNode element = (ElementNode)this.getCurrentNode();
                long attKey = -1L;
                ImmutableXmlNode currentNode = (ImmutableXmlNode)this.getCurrentNode();
                for (int i = 0; i < element.getAttributeCount(); ++i) {
                    long attributeKey = element.getAttributeKey(i);
                    if (!this.moveTo(attributeKey) || !this.getName().equals((Object)name)) continue;
                    attKey = attributeKey;
                    break;
                }
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(currentNode);
                if (attKey != -1L) {
                    this.moveTo(attKey);
                    QNm qName = this.getName();
                    if (name.equals((Object)qName)) {
                        if (this.getValue().equals(value)) {
                            XmlNodeTrxImpl xmlNodeTrxImpl = this;
                            return xmlNodeTrxImpl;
                        }
                        this.setValue(value);
                    }
                    this.moveToParent();
                }
                long pathNodeKey = this.resourceSession.getResourceConfig().withPathSummary ? this.pathSummaryWriter.getPathNodeKey(name, NodeKind.ATTRIBUTE) : 0L;
                byte[] attValue = XmlNodeTrxImpl.getBytes(value);
                SirixDeweyID id = this.deweyIDManager.newAttributeID();
                long elementKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                AttributeNode node = ((XmlNodeFactory)this.nodeFactory).createAttributeNode(elementKey, name, attValue, pathNodeKey, id);
                Node parentNode = (Node)this.pageTrx.prepareRecordForModification(node.getParentKey(), IndexType.DOCUMENT, -1);
                ((ElementNode)parentNode).insertAttribute(node.getNodeKey());
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.nodeHashing.adaptHashesWithAdd();
                this.indexController.notifyChange(IndexController.ChangeType.INSERT, node, pathNodeKey);
                if (move == Movement.TOPARENT) {
                    this.moveToParent();
                }
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an ElementNode!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public XmlNodeTrx insertNamespace(@NonNull QNm name) {
        return this.insertNamespace(name, Movement.NONE);
    }

    @Override
    public XmlNodeTrx insertNamespace(@NonNull QNm name, @NonNull Movement move) {
        if (!XMLToken.isValidQName(Objects.requireNonNull(name))) {
            throw new IllegalArgumentException("The QName is not valid!");
        }
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.ELEMENT) {
                this.checkAccessAndCommit();
                int namespCount = ((ElementNode)this.getCurrentNode()).getNamespaceCount();
                for (int i = 0; i < namespCount; ++i) {
                    this.moveToNamespace(i);
                    QNm qName = this.getName();
                    if (name.getPrefix().equals(qName.getPrefix())) {
                        throw new SirixUsageException(new String[]{"Duplicate namespace!"});
                    }
                    this.moveToParent();
                }
                long pathNodeKey = this.buildPathSummary ? this.pathSummaryWriter.getPathNodeKey(name, NodeKind.NAMESPACE) : 0L;
                long elementKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
                SirixDeweyID id = this.deweyIDManager.newNamespaceID();
                NamespaceNode node = ((XmlNodeFactory)this.nodeFactory).createNamespaceNode(elementKey, name, pathNodeKey, id);
                Node parentNode = (Node)this.pageTrx.prepareRecordForModification(node.getParentKey(), IndexType.DOCUMENT, -1);
                ((ElementNode)parentNode).insertNamespace(node.getNodeKey());
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(node);
                this.nodeHashing.adaptHashesWithAdd();
                if (move == Movement.TOPARENT) {
                    this.moveToParent();
                }
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"Insert is not allowed if current node is not an ElementNode!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void checkAncestors(Node node) {
        assert (node != null);
        Object item = this.getCurrentNode();
        while (((ImmutableXmlNode)this.getCurrentNode()).hasParent()) {
            this.moveToParent();
            if (((ImmutableXmlNode)this.getCurrentNode()).getNodeKey() != node.getNodeKey()) continue;
            throw new IllegalStateException("Moving one of the ancestor nodes is not permitted!");
        }
        this.moveTo(item.getNodeKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx remove() {
        this.checkAccessAndCommit();
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.XML_DOCUMENT) {
                throw new SirixUsageException(new String[]{"Document root can not be removed."});
            }
            if (this.getCurrentNode() instanceof StructNode) {
                node = (StructNode)((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode();
                PostOrderAxis axis = new PostOrderAxis(this);
                while (axis.hasNext()) {
                    axis.nextLong();
                    ImmutableNode currentNode = axis.getCursor().getNode();
                    this.removeName();
                    this.removeNonStructural();
                    this.removeValue();
                    this.pageTrx.removeRecord(currentNode.getNodeKey(), IndexType.DOCUMENT, -1);
                }
                this.removeName();
                this.removeValue();
                ImmutableXmlNode xmlNode = (ImmutableXmlNode)((Object)node);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(xmlNode);
                this.nodeHashing.adaptHashesWithRemove();
                this.adaptForRemove((StructNode)node);
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode(xmlNode);
                if (!((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).hasRightSibling() || !this.moveTo(node.getRightSiblingKey())) {
                    if (node.hasLeftSibling()) {
                        this.moveTo(node.getLeftSiblingKey());
                    } else {
                        this.moveTo(node.getParentKey());
                    }
                }
            } else if (((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.ATTRIBUTE) {
                node = (AttributeNode)((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode();
                this.indexController.notifyChange(IndexController.ChangeType.DELETE, node, ((AttributeNode)node).getPathNodeKey());
                ElementNode parent = (ElementNode)this.pageTrx.prepareRecordForModification(((AbstractForwardingNode)node).getParentKey(), IndexType.DOCUMENT, -1);
                parent.removeAttribute(((AbstractForwardingNode)node).getNodeKey());
                this.nodeHashing.adaptHashesWithRemove();
                this.pageTrx.removeRecord(((AbstractForwardingNode)node).getNodeKey(), IndexType.DOCUMENT, -1);
                this.removeName();
                this.moveToParent();
            } else if (((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.NAMESPACE) {
                node = (NamespaceNode)((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode();
                this.indexController.notifyChange(IndexController.ChangeType.DELETE, node, ((NamespaceNode)node).getPathNodeKey());
                ElementNode parent = (ElementNode)this.pageTrx.prepareRecordForModification(((AbstractForwardingNode)node).getParentKey(), IndexType.DOCUMENT, -1);
                parent.removeNamespace(((AbstractForwardingNode)node).getNodeKey());
                this.nodeHashing.adaptHashesWithRemove();
                this.pageTrx.removeRecord(((AbstractForwardingNode)node).getNodeKey(), IndexType.DOCUMENT, -1);
                this.removeName();
                this.moveToParent();
            }
            XmlNodeTrxImpl xmlNodeTrxImpl = this;
            return xmlNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void removeValue() throws SirixIOException {
        if (this.getCurrentNode() instanceof ValueNode) {
            long nodeKey = this.getNodeKey();
            long pathNodeKey = this.moveToParent() ? this.getPathNodeKey() : -1L;
            this.moveTo(nodeKey);
            this.indexController.notifyChange(IndexController.ChangeType.DELETE, (ImmutableNode)this.getCurrentNode(), pathNodeKey);
        }
    }

    private void removeNonStructural() {
        if (((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getKind() == NodeKind.ELEMENT) {
            int attCount = ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getAttributeCount();
            for (int i = 0; i < attCount; ++i) {
                this.moveToAttribute(i);
                this.removeName();
                this.removeValue();
                this.pageTrx.removeRecord(((ImmutableXmlNode)this.getCurrentNode()).getNodeKey(), IndexType.DOCUMENT, -1);
                this.moveToParent();
            }
            int nspCount = ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getNamespaceCount();
            for (int i = 0; i < nspCount; ++i) {
                this.moveToNamespace(i);
                this.removeName();
                this.pageTrx.removeRecord(((ImmutableXmlNode)this.getCurrentNode()).getNodeKey(), IndexType.DOCUMENT, -1);
                this.moveToParent();
            }
        }
    }

    private void removeName() {
        Object n = this.getCurrentNode();
        if (n instanceof ImmutableNameNode) {
            ImmutableNameNode node = (ImmutableNameNode)n;
            this.indexController.notifyChange(IndexController.ChangeType.DELETE, node, node.getPathNodeKey());
            NodeKind nodeKind = node.getKind();
            NamePage page = this.pageTrx.getNamePage(this.pageTrx.getActualRevisionRootPage());
            page.removeName(node.getPrefixKey(), nodeKind, this.pageTrx);
            page.removeName(node.getLocalNameKey(), nodeKind, this.pageTrx);
            page.removeName(node.getURIKey(), NodeKind.NAMESPACE, this.pageTrx);
            assert (nodeKind != NodeKind.XML_DOCUMENT);
            if (this.buildPathSummary) {
                this.pathSummaryWriter.remove(node);
            }
        }
    }

    @Override
    public XmlNodeTrx setName(QNm name) {
        Objects.requireNonNull(name);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getCurrentNode() instanceof NameNode) {
                if (!this.getName().equals((Object)name)) {
                    this.checkAccessAndCommit();
                    NameNode node = (NameNode)((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode();
                    long oldHash = node.computeHash(this.bytes);
                    NodeKind nodeKind = node.getKind();
                    int oldPrefixKey = node.getPrefixKey();
                    int oldLocalNameKey = node.getLocalNameKey();
                    int oldUriKey = node.getURIKey();
                    NamePage page = (NamePage)this.pageTrx.getActualRevisionRootPage().getNamePageReference().getPage();
                    page.removeName(oldPrefixKey, nodeKind, this.pageTrx);
                    page.removeName(oldLocalNameKey, nodeKind, this.pageTrx);
                    page.removeName(oldUriKey, NodeKind.NAMESPACE, this.pageTrx);
                    int prefixKey = name.getPrefix() != null && !name.getPrefix().isEmpty() ? this.pageTrx.createNameKey(name.getPrefix(), node.getKind()) : -1;
                    int localNameKey = name.getLocalName() != null && !name.getLocalName().isEmpty() ? this.pageTrx.createNameKey(name.getLocalName(), node.getKind()) : -1;
                    int uriKey = name.getNamespaceURI() != null && !name.getNamespaceURI().isEmpty() ? this.pageTrx.createNameKey(name.getNamespaceURI(), NodeKind.NAMESPACE) : -1;
                    node = (NameNode)this.pageTrx.prepareRecordForModification(node.getNodeKey(), IndexType.DOCUMENT, -1);
                    node.setLocalNameKey(localNameKey);
                    node.setURIKey(uriKey);
                    node.setPrefixKey(prefixKey);
                    if (this.buildPathSummary) {
                        this.pathSummaryWriter.adaptPathForChangedNode(node, name, uriKey, prefixKey, localNameKey, PathSummaryWriter.OPType.SETNAME);
                    }
                    node.setPathNodeKey(this.buildPathSummary ? this.pathSummaryWriter.getNodeKey() : 0L);
                    ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode((ImmutableXmlNode)((Object)node));
                    this.nodeHashing.adaptHashedWithUpdate(oldHash);
                }
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"setName is not allowed if current node is not an INameNode implementation!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public XmlNodeTrx setValue(String value) {
        Objects.requireNonNull(value);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            if (this.getCurrentNode() instanceof ValueNode) {
                this.checkAccessAndCommit();
                if (value.isEmpty()) {
                    this.remove();
                    XmlNodeTrxImpl xmlNodeTrxImpl = this;
                    return xmlNodeTrxImpl;
                }
                long nodeKey = this.getNodeKey();
                this.moveToParent();
                long pathNodeKey = this.getPathNodeKey();
                this.moveTo(nodeKey);
                this.indexController.notifyChange(IndexController.ChangeType.DELETE, this.getNode(), pathNodeKey);
                long oldHash = ((ImmutableXmlNode)((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode()).computeHash(this.bytes);
                byte[] byteVal = XmlNodeTrxImpl.getBytes(value);
                ValueNode node = (ValueNode)this.pageTrx.prepareRecordForModification(((ImmutableXmlNode)((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode()).getNodeKey(), IndexType.DOCUMENT, -1);
                node.setRawValue(byteVal);
                node.setPreviousRevision(node.getLastModifiedRevisionNumber());
                node.setLastModifiedRevision(((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getRevisionNumber());
                ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).setCurrentNode((ImmutableXmlNode)((Object)node));
                this.nodeHashing.adaptHashedWithUpdate(oldHash);
                this.indexController.notifyChange(IndexController.ChangeType.INSERT, this.getNode(), pathNodeKey);
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new SirixUsageException(new String[]{"setValue(String) is not allowed if current node is not an IValNode implementation!"});
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    protected void postOrderTraversalHashes() {
        new PostOrderAxis(this, IncludeSelf.YES).forEach(unused -> {
            StructNode node = ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
            if (node.getKind() == NodeKind.ELEMENT) {
                int i;
                ElementNode element = (ElementNode)node;
                int nspCount = element.getNamespaceCount();
                for (i = 0; i < nspCount; ++i) {
                    this.moveToNamespace(i);
                    this.nodeHashing.addHashAndDescendantCount();
                    this.moveToParent();
                }
                int attCount = element.getAttributeCount();
                for (i = 0; i < attCount; ++i) {
                    this.moveToAttribute(i);
                    this.nodeHashing.addHashAndDescendantCount();
                    this.moveToParent();
                }
            }
            this.nodeHashing.addHashAndDescendantCount();
        });
    }

    @Override
    protected void serializeUpdateDiffs(int revisionNumber) {
    }

    private void adaptForInsert(Node newNode, InsertPos insertPos) throws SirixIOException {
        assert (newNode != null);
        assert (insertPos != null);
        if (newNode instanceof StructNode) {
            StructNode structNode = (StructNode)newNode;
            StructNode parent = (StructNode)this.pageTrx.prepareRecordForModification(newNode.getParentKey(), IndexType.DOCUMENT, -1);
            if (this.storeChildCount) {
                parent.incrementChildCount();
            }
            if (!((StructNode)newNode).hasLeftSibling()) {
                parent.setFirstChildKey(newNode.getNodeKey());
            }
            if (structNode.hasRightSibling()) {
                StructNode rightSiblingNode = (StructNode)this.pageTrx.prepareRecordForModification(structNode.getRightSiblingKey(), IndexType.DOCUMENT, -1);
                rightSiblingNode.setLeftSiblingKey(structNode.getNodeKey());
            }
            if (structNode.hasLeftSibling()) {
                StructNode leftSiblingNode = (StructNode)this.pageTrx.prepareRecordForModification(structNode.getLeftSiblingKey(), IndexType.DOCUMENT, -1);
                leftSiblingNode.setRightSiblingKey(structNode.getNodeKey());
            }
        }
    }

    private void adaptForRemove(StructNode oldNode) {
        assert (oldNode != null);
        boolean concatenated = false;
        if (oldNode.hasLeftSibling() && oldNode.hasRightSibling() && this.moveTo(oldNode.getRightSiblingKey()) && ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.TEXT && this.moveTo(oldNode.getLeftSiblingKey()) && ((ImmutableXmlNode)this.getCurrentNode()).getKind() == NodeKind.TEXT) {
            StringBuilder builder = new StringBuilder(this.getValue());
            this.moveTo(oldNode.getRightSiblingKey());
            builder.append(this.getValue());
            this.moveTo(oldNode.getLeftSiblingKey());
            this.setValue(builder.toString());
            concatenated = true;
        }
        if (oldNode.hasLeftSibling()) {
            StructNode leftSibling = (StructNode)this.pageTrx.prepareRecordForModification(oldNode.getLeftSiblingKey(), IndexType.DOCUMENT, -1);
            if (concatenated) {
                this.moveTo(oldNode.getRightSiblingKey());
                leftSibling.setRightSiblingKey(((StructNode)this.getCurrentNode()).getRightSiblingKey());
            } else {
                leftSibling.setRightSiblingKey(oldNode.getRightSiblingKey());
            }
        }
        if (oldNode.hasRightSibling()) {
            if (concatenated) {
                this.moveTo(oldNode.getRightSiblingKey());
                this.moveTo(((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode().getRightSiblingKey());
                rightSibling = (StructNode)this.pageTrx.prepareRecordForModification(((ImmutableXmlNode)((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode()).getNodeKey(), IndexType.DOCUMENT, -1);
                rightSibling.setLeftSiblingKey(oldNode.getLeftSiblingKey());
            } else {
                rightSibling = (StructNode)this.pageTrx.prepareRecordForModification(oldNode.getRightSiblingKey(), IndexType.DOCUMENT, -1);
                rightSibling.setLeftSiblingKey(oldNode.getLeftSiblingKey());
            }
        }
        StructNode parent = (StructNode)this.pageTrx.prepareRecordForModification(oldNode.getParentKey(), IndexType.DOCUMENT, -1);
        if (!oldNode.hasLeftSibling()) {
            parent.setFirstChildKey(oldNode.getRightSiblingKey());
        }
        if (this.storeChildCount) {
            parent.decrementChildCount();
        }
        if (concatenated) {
            parent.decrementDescendantCount();
            if (this.storeChildCount) {
                parent.decrementChildCount();
            }
        }
        if (concatenated) {
            this.moveTo(parent.getNodeKey());
            while (parent.hasParent()) {
                this.moveToParent();
                StructNode ancestor = (StructNode)this.pageTrx.prepareRecordForModification(((ImmutableXmlNode)((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode()).getNodeKey(), IndexType.DOCUMENT, -1);
                ancestor.decrementDescendantCount();
                parent = ancestor;
            }
        }
        if (concatenated) {
            this.moveTo(oldNode.getRightSiblingKey());
            this.pageTrx.removeRecord(((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getNodeKey(), IndexType.DOCUMENT, -1);
        }
        if (oldNode.getKind() == NodeKind.ELEMENT) {
            this.moveTo(oldNode.getNodeKey());
            this.removeNonStructural();
        }
        this.moveTo(oldNode.getNodeKey());
        this.pageTrx.removeRecord(oldNode.getNodeKey(), IndexType.DOCUMENT, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx copySubtreeAsFirstChild(XmlNodeReadOnlyTrx rtx) {
        Objects.requireNonNull(rtx);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            long nodeKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
            this.copy(rtx, InsertPosition.AS_FIRST_CHILD);
            this.moveTo(nodeKey);
            this.moveToFirstChild();
            XmlNodeTrxImpl xmlNodeTrxImpl = this;
            return xmlNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx copySubtreeAsLeftSibling(XmlNodeReadOnlyTrx rtx) {
        Objects.requireNonNull(rtx);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            long nodeKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
            this.copy(rtx, InsertPosition.AS_LEFT_SIBLING);
            this.moveTo(nodeKey);
            this.moveToFirstChild();
            XmlNodeTrxImpl xmlNodeTrxImpl = this;
            return xmlNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlNodeTrx copySubtreeAsRightSibling(XmlNodeReadOnlyTrx rtx) {
        Objects.requireNonNull(rtx);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            long nodeKey = ((ImmutableXmlNode)this.getCurrentNode()).getNodeKey();
            this.copy(rtx, InsertPosition.AS_RIGHT_SIBLING);
            this.moveTo(nodeKey);
            this.moveToRightSibling();
            XmlNodeTrxImpl xmlNodeTrxImpl = this;
            return xmlNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void copy(XmlNodeReadOnlyTrx trx, InsertPosition insert) {
        assert (trx != null);
        assert (insert != null);
        XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)trx.getResourceSession().beginNodeReadOnlyTrx(trx.getRevisionNumber());
        assert (rtx.getRevisionNumber() == trx.getRevisionNumber());
        rtx.moveTo(trx.getNodeKey());
        assert (rtx.getNodeKey() == trx.getNodeKey());
        if (rtx.getKind() == NodeKind.XML_DOCUMENT) {
            rtx.moveToFirstChild();
        }
        if (!rtx.isStructuralNode()) {
            throw new IllegalStateException("Node to insert must be a structural node (Text, PI, Comment, Document root or Element)!");
        }
        NodeKind kind = rtx.getKind();
        block0 : switch (kind) {
            case TEXT: {
                String textValue = rtx.getValue();
                switch (insert) {
                    case AS_FIRST_CHILD: {
                        this.insertTextAsFirstChild(textValue);
                        break block0;
                    }
                    case AS_LEFT_SIBLING: {
                        this.insertTextAsLeftSibling(textValue);
                        break block0;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.insertTextAsRightSibling(textValue);
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case PROCESSING_INSTRUCTION: {
                switch (insert) {
                    case AS_FIRST_CHILD: {
                        this.insertPIAsFirstChild(rtx.getName().getLocalName(), rtx.getValue());
                        break block0;
                    }
                    case AS_LEFT_SIBLING: {
                        this.insertPIAsLeftSibling(rtx.getName().getLocalName(), rtx.getValue());
                        break block0;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.insertPIAsRightSibling(rtx.getName().getLocalName(), rtx.getValue());
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            case COMMENT: {
                String commentValue = rtx.getValue();
                switch (insert) {
                    case AS_FIRST_CHILD: {
                        this.insertCommentAsFirstChild(commentValue);
                        break block0;
                    }
                    case AS_LEFT_SIBLING: {
                        this.insertCommentAsLeftSibling(commentValue);
                        break block0;
                    }
                    case AS_RIGHT_SIBLING: {
                        this.insertCommentAsRightSibling(commentValue);
                        break block0;
                    }
                }
                throw new IllegalStateException();
            }
            default: {
                new XmlShredder.Builder(this, new StAXSerializer(rtx), insert).build().call();
            }
        }
        rtx.close();
    }

    @Override
    public XmlNodeTrx replaceNode(XMLEventReader reader) {
        Objects.requireNonNull(reader);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            this.checkAccessAndCommit();
            if (this.getCurrentNode() instanceof StructNode) {
                InsertPosition pos;
                long anchorNodeKey;
                StructNode currentNode = ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
                if (currentNode.hasLeftSibling()) {
                    anchorNodeKey = this.getLeftSiblingKey();
                    pos = InsertPosition.AS_RIGHT_SIBLING;
                } else {
                    anchorNodeKey = this.getParentKey();
                    pos = InsertPosition.AS_FIRST_CHILD;
                }
                this.insertAndThenRemove(reader, pos, anchorNodeKey);
                XmlNodeTrxImpl xmlNodeTrxImpl = this;
                return xmlNodeTrxImpl;
            }
            throw new IllegalArgumentException("Not supported for attributes / namespaces.");
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void insertAndThenRemove(XMLEventReader reader, InsertPosition pos, long anchorNodeKey) {
        long formerNodeKey = this.getNodeKey();
        this.insert(reader, pos, anchorNodeKey);
        this.moveTo(formerNodeKey);
        this.remove();
    }

    private void insert(XMLEventReader reader, InsertPosition pos, long anchorNodeKey) {
        this.moveTo(anchorNodeKey);
        XmlShredder shredder = new XmlShredder.Builder(this, reader, pos).build();
        shredder.call();
    }

    @Override
    protected XmlNodeTrx self() {
        return this;
    }

    @Override
    public XmlNodeTrx setBulkInsertion(boolean bulkInsertion) {
        this.nodeHashing.setBulkInsert(bulkInsertion);
        return this;
    }

    @Override
    public XmlNodeTrx replaceNode(XmlNodeReadOnlyTrx rtx) {
        Objects.requireNonNull(rtx);
        if (this.lock != null) {
            this.lock.lock();
        }
        try {
            switch (rtx.getKind()) {
                case TEXT: 
                case PROCESSING_INSTRUCTION: 
                case COMMENT: 
                case ELEMENT: {
                    this.checkCurrentNode();
                    if (this.isText()) {
                        this.removeAndThenInsert(rtx);
                        break;
                    }
                    this.insertAndThenRemove(rtx);
                    break;
                }
                case ATTRIBUTE: {
                    if (((ImmutableXmlNode)this.getCurrentNode()).getKind() != NodeKind.ATTRIBUTE) {
                        throw new IllegalStateException("Current node must be an attribute node!");
                    }
                    this.remove();
                    this.insertAttribute(rtx.getName(), rtx.getValue());
                    break;
                }
                case NAMESPACE: {
                    if (((ImmutableXmlNode)this.getCurrentNode()).getKind() != NodeKind.NAMESPACE) {
                        throw new IllegalStateException("Current node must be a namespace node!");
                    }
                    this.remove();
                    this.insertNamespace(rtx.getName());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Node type not supported!");
                }
            }
            XmlNodeTrxImpl xmlNodeTrxImpl = this;
            return xmlNodeTrxImpl;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private void checkCurrentNode() {
        if (!(this.getCurrentNode() instanceof StructNode)) {
            throw new IllegalStateException("Current node must be a structural node!");
        }
    }

    private ImmutableNode removeAndThenInsert(XmlNodeReadOnlyTrx rtx) {
        long key;
        assert (rtx != null);
        StructNode currentNode = ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
        if (currentNode.hasLeftSibling()) {
            long nodeKey = currentNode.getLeftSiblingKey();
            this.remove();
            this.moveTo(nodeKey);
            key = this.copySubtreeAsRightSibling(rtx).getNodeKey();
        } else {
            long nodeKey = currentNode.getParentKey();
            this.remove();
            this.moveTo(nodeKey);
            key = this.copySubtreeAsFirstChild(rtx).getNodeKey();
        }
        this.moveTo(key);
        return ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getCurrentNode();
    }

    private void insertAndThenRemove(XmlNodeReadOnlyTrx rtx) {
        long key;
        assert (rtx != null);
        StructNode currentNode = ((InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx).getStructuralNode();
        if (currentNode.hasLeftSibling()) {
            this.moveToLeftSibling();
            key = this.copySubtreeAsRightSibling(rtx).getNodeKey();
        } else {
            this.moveToParent();
            key = this.copySubtreeAsFirstChild(rtx).getNodeKey();
            this.moveTo(key);
        }
        this.removeOldNode(currentNode, key);
    }

    private void removeOldNode(@NonNull StructNode node, @NonNegative long key) {
        this.moveTo(node.getNodeKey());
        this.remove();
        this.moveTo(key);
    }

    @Override
    protected AbstractNodeHashing<ImmutableXmlNode, XmlNodeReadOnlyTrx> reInstantiateNodeHashing(PageTrx pageTrx) {
        return new XmlNodeHashing(this.resourceSession.getResourceConfig(), (InternalXmlNodeReadOnlyTrx)this.nodeReadOnlyTrx, pageTrx);
    }

    @Override
    protected XmlNodeFactory reInstantiateNodeFactory(PageTrx pageTrx) {
        return new XmlNodeFactoryImpl(this.resourceSession.getResourceConfig().nodeHashFunction, pageTrx);
    }
}

