/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.node.xml;

import io.sirix.access.ResourceConfiguration;
import io.sirix.access.ResourceStore;
import io.sirix.access.User;
import io.sirix.access.trx.node.AbstractResourceSession;
import io.sirix.access.trx.node.AfterCommitState;
import io.sirix.access.trx.node.InternalResourceSession;
import io.sirix.access.trx.node.RecordToRevisionsIndex;
import io.sirix.access.trx.node.xml.XmlIndexController;
import io.sirix.access.trx.node.xml.XmlNodeFactoryImpl;
import io.sirix.access.trx.node.xml.XmlNodeHashing;
import io.sirix.access.trx.node.xml.XmlNodeReadOnlyTrxImpl;
import io.sirix.access.trx.node.xml.XmlNodeTrxImpl;
import io.sirix.access.trx.page.PageTrxFactory;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.api.xml.XmlResourceSession;
import io.sirix.cache.BufferManager;
import io.sirix.index.path.summary.PathSummaryWriter;
import io.sirix.io.IOStorage;
import io.sirix.node.interfaces.Node;
import io.sirix.node.interfaces.immutable.ImmutableXmlNode;
import io.sirix.page.UberPage;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;

public final class XmlResourceSessionImpl
extends AbstractResourceSession<XmlNodeReadOnlyTrx, XmlNodeTrx>
implements XmlResourceSession,
InternalResourceSession<XmlNodeReadOnlyTrx, XmlNodeTrx> {
    private final ConcurrentMap<Integer, XmlIndexController> rtxIndexControllers = new ConcurrentHashMap<Integer, XmlIndexController>();
    private final ConcurrentMap<Integer, XmlIndexController> wtxIndexControllers = new ConcurrentHashMap<Integer, XmlIndexController>();

    @Inject
    XmlResourceSessionImpl(ResourceStore<XmlResourceSession> resourceStore, ResourceConfiguration resourceConf, BufferManager bufferManager, IOStorage storage, UberPage uberPage, Semaphore writeLock, User user, PageTrxFactory pageTrxFactory) {
        super(resourceStore, resourceConf, bufferManager, storage, uberPage, writeLock, user, pageTrxFactory);
    }

    @Override
    public XmlNodeReadOnlyTrx createNodeReadOnlyTrx(long nodeTrxId, PageReadOnlyTrx pageReadTrx, Node documentNode) {
        return new XmlNodeReadOnlyTrxImpl(this, nodeTrxId, pageReadTrx, (ImmutableXmlNode)((Object)documentNode));
    }

    @Override
    public XmlNodeTrx createNodeReadWriteTrx(long nodeTrxId, PageTrx pageTrx, int maxNodeCount, Duration autoCommitDelay, Node documentNode, AfterCommitState afterCommitState) {
        XmlNodeReadOnlyTrxImpl nodeReadTrx = new XmlNodeReadOnlyTrxImpl(this, nodeTrxId, pageTrx, (ImmutableXmlNode)((Object)documentNode));
        XmlNodeFactoryImpl nodeFactory = new XmlNodeFactoryImpl(this.getResourceConfig().nodeHashFunction, pageTrx);
        boolean buildPathSummary = this.getResourceConfig().withPathSummary;
        PathSummaryWriter<XmlNodeReadOnlyTrx> pathSummaryWriter = buildPathSummary ? new PathSummaryWriter<XmlNodeReadOnlyTrx>(pageTrx, this, nodeFactory, nodeReadTrx) : null;
        boolean isAutoCommitting = maxNodeCount > 0 || !autoCommitDelay.isZero();
        ReentrantLock transactionLock = isAutoCommitting ? new ReentrantLock() : null;
        ResourceConfiguration resourceConfig = this.getResourceConfig();
        return new XmlNodeTrxImpl(this, nodeReadTrx, pathSummaryWriter, maxNodeCount, transactionLock, autoCommitDelay, new XmlNodeHashing(resourceConfig, nodeReadTrx, pageTrx), nodeFactory, afterCommitState, new RecordToRevisionsIndex(pageTrx));
    }

    @Override
    public synchronized XmlIndexController getRtxIndexController(int revision) {
        return this.rtxIndexControllers.computeIfAbsent(revision, unused -> this.createIndexController(revision));
    }

    @Override
    public synchronized XmlIndexController getWtxIndexController(int revision) {
        return this.wtxIndexControllers.computeIfAbsent(revision, unused -> this.createIndexController(revision));
    }

    private XmlIndexController createIndexController(int revision) {
        XmlIndexController controller = new XmlIndexController();
        this.initializeIndexController(revision, controller);
        return controller;
    }
}

