/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.access.trx.page;

import com.google.common.base.Preconditions;
import io.sirix.access.ResourceConfiguration;
import io.sirix.access.User;
import io.sirix.access.trx.node.CommitCredentials;
import io.sirix.access.trx.node.IndexController;
import io.sirix.access.trx.page.AbstractForwardingPageReadOnlyTrx;
import io.sirix.access.trx.page.NodePageReadOnlyTrx;
import io.sirix.access.trx.page.TreeModifier;
import io.sirix.api.PageReadOnlyTrx;
import io.sirix.api.PageTrx;
import io.sirix.cache.IndexLogKey;
import io.sirix.cache.PageContainer;
import io.sirix.cache.TransactionIntentLog;
import io.sirix.exception.SirixIOException;
import io.sirix.index.IndexType;
import io.sirix.io.Writer;
import io.sirix.node.DeletedNode;
import io.sirix.node.NodeKind;
import io.sirix.node.SirixDeweyID;
import io.sirix.node.delegates.NodeDelegate;
import io.sirix.node.interfaces.DataRecord;
import io.sirix.page.CASPage;
import io.sirix.page.DeweyIDPage;
import io.sirix.page.KeyValueLeafPage;
import io.sirix.page.NamePage;
import io.sirix.page.PageKind;
import io.sirix.page.PageReference;
import io.sirix.page.PathPage;
import io.sirix.page.PathSummaryPage;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.SerializationType;
import io.sirix.page.UberPage;
import io.sirix.page.interfaces.KeyValuePage;
import io.sirix.page.interfaces.Page;
import io.sirix.settings.Fixed;
import io.sirix.settings.VersioningType;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class NodePageTrx
extends AbstractForwardingPageReadOnlyTrx
implements PageTrx {
    private Bytes<ByteBuffer> bufferBytes = Bytes.elasticByteBuffer((int)64000);
    private final Writer storagePageReaderWriter;
    TransactionIntentLog log;
    private final RevisionRootPage newRevisionRootPage;
    private final NodePageReadOnlyTrx pageRtx;
    private volatile boolean isClosed;
    private final IndexController<?, ?> indexController;
    private final TreeModifier treeModifier;
    private final int representRevision;
    private final boolean isBoundToNodeTrx;
    private IndexLogKeyToPageContainer mostRecentPageContainer;
    private IndexLogKeyToPageContainer secondMostRecentPageContainer;
    private IndexLogKeyToPageContainer mostRecentPathSummaryPageContainer;
    private final LinkedHashMap<IndexLogKey, PageContainer> pageContainerCache;

    NodePageTrx(TreeModifier treeModifier, Writer writer, TransactionIntentLog log, RevisionRootPage revisionRootPage, NodePageReadOnlyTrx pageRtx, IndexController<?, ?> indexController, int representRevision, boolean isBoundToNodeTrx) {
        this.treeModifier = Objects.requireNonNull(treeModifier);
        this.storagePageReaderWriter = Objects.requireNonNull(writer);
        this.log = Objects.requireNonNull(log);
        this.newRevisionRootPage = Objects.requireNonNull(revisionRootPage);
        this.pageRtx = Objects.requireNonNull(pageRtx);
        this.indexController = Objects.requireNonNull(indexController);
        Preconditions.checkArgument((representRevision >= 0 ? 1 : 0) != 0, (Object)"The represented revision must be >= 0.");
        this.representRevision = representRevision;
        this.isBoundToNodeTrx = isBoundToNodeTrx;
        this.secondMostRecentPageContainer = this.mostRecentPageContainer = new IndexLogKeyToPageContainer(IndexType.DOCUMENT, -1L, -1, -1, null);
        this.mostRecentPathSummaryPageContainer = new IndexLogKeyToPageContainer(IndexType.PATH_SUMMARY, -1L, -1, -1, null);
        this.pageContainerCache = new LinkedHashMap<IndexLogKey, PageContainer>(2500){

            @Override
            protected boolean removeEldestEntry(Map.Entry<IndexLogKey, PageContainer> eldest) {
                return this.size() > 2500;
            }
        };
    }

    @Override
    public Bytes<ByteBuffer> newBufferedBytesInstance() {
        this.bufferBytes = Bytes.elasticByteBuffer((int)64000);
        return this.bufferBytes;
    }

    @Override
    public int getRevisionToRepresent() {
        this.pageRtx.assertNotClosed();
        return this.representRevision;
    }

    @Override
    public TransactionIntentLog getLog() {
        this.pageRtx.assertNotClosed();
        return this.log;
    }

    @Override
    public int getRevisionNumber() {
        this.pageRtx.assertNotClosed();
        return this.newRevisionRootPage.getRevision();
    }

    public DataRecord prepareRecordForModification(long recordKey, @NonNull IndexType indexType, int index) {
        this.pageRtx.assertNotClosed();
        Preconditions.checkArgument((recordKey >= 0L ? 1 : 0) != 0, (Object)"recordKey must be >= 0!");
        Objects.requireNonNull(indexType);
        long recordPageKey = this.pageRtx.pageKey(recordKey, indexType);
        PageContainer cont = this.prepareRecordPage(recordPageKey, index, indexType);
        KeyValueLeafPage modifiedPage = cont.getModifiedAsUnorderedKeyValuePage();
        DataRecord record = this.pageRtx.getValue(modifiedPage, recordKey);
        if (record == null) {
            DataRecord oldRecord = this.pageRtx.getValue(cont.getCompleteAsUnorderedKeyValuePage(), recordKey);
            if (oldRecord == null) {
                throw new SirixIOException("Cannot retrieve record from cache: (key: " + recordKey + ") (indexType: " + String.valueOf((Object)indexType) + ") (index: " + index + ")");
            }
            record = oldRecord;
            modifiedPage.setRecord(record);
        }
        return record;
    }

    public DataRecord createRecord(@NonNull DataRecord record, @NonNull IndexType indexType, @NonNegative int index) {
        this.pageRtx.assertNotClosed();
        long createdRecordKey = switch (indexType) {
            case IndexType.DOCUMENT -> this.newRevisionRootPage.incrementAndGetMaxNodeKeyInDocumentIndex();
            case IndexType.CHANGED_NODES -> this.newRevisionRootPage.incrementAndGetMaxNodeKeyInChangedNodesIndex();
            case IndexType.RECORD_TO_REVISIONS -> this.newRevisionRootPage.incrementAndGetMaxNodeKeyInRecordToRevisionsIndex();
            case IndexType.PATH_SUMMARY -> {
                PathSummaryPage pathSummaryPage = (PathSummaryPage)this.newRevisionRootPage.getPathSummaryPageReference().getPage();
                yield pathSummaryPage.incrementAndGetMaxNodeKey(index);
            }
            case IndexType.CAS -> {
                CASPage casPage = (CASPage)this.newRevisionRootPage.getCASPageReference().getPage();
                yield casPage.incrementAndGetMaxNodeKey(index);
            }
            case IndexType.PATH -> {
                PathPage pathPage = (PathPage)this.newRevisionRootPage.getPathPageReference().getPage();
                yield pathPage.incrementAndGetMaxNodeKey(index);
            }
            case IndexType.NAME -> {
                NamePage namePage = (NamePage)this.newRevisionRootPage.getNamePageReference().getPage();
                yield namePage.incrementAndGetMaxNodeKey(index);
            }
            default -> throw new IllegalStateException();
        };
        long recordPageKey = this.pageRtx.pageKey(createdRecordKey, indexType);
        PageContainer cont = this.prepareRecordPage(recordPageKey, index, indexType);
        KeyValueLeafPage modified = cont.getModifiedAsUnorderedKeyValuePage();
        modified.setRecord(record);
        return record;
    }

    @Override
    public void removeRecord(long recordKey, @NonNull IndexType indexType, int index) {
        this.pageRtx.assertNotClosed();
        long recordPageKey = this.pageRtx.pageKey(recordKey, indexType);
        PageContainer cont = this.prepareRecordPage(recordPageKey, index, indexType);
        Object node = this.getRecord(recordKey, indexType, index);
        if (node == null) {
            throw new IllegalStateException("Node not found: " + recordKey);
        }
        DeletedNode delNode = new DeletedNode(new NodeDelegate(node.getNodeKey(), -1L, null, -1, this.pageRtx.getRevisionNumber(), (SirixDeweyID)null));
        cont.getModifiedAsUnorderedKeyValuePage().setRecord(delNode);
        cont.getCompleteAsUnorderedKeyValuePage().setRecord(delNode);
    }

    @Override
    public <V extends DataRecord> V getRecord(long recordKey, @NonNull IndexType indexType, @NonNegative int index) {
        this.pageRtx.assertNotClosed();
        Preconditions.checkArgument((recordKey >= Fixed.NULL_NODE_KEY.getStandardProperty() ? 1 : 0) != 0);
        Objects.requireNonNull(indexType);
        long recordPageKey = this.pageRtx.pageKey(recordKey, indexType);
        PageContainer pageCont = this.getPageContainer(recordPageKey, index, indexType);
        if (pageCont == null) {
            return this.pageRtx.getRecord(recordKey, indexType, index);
        }
        DataRecord node = this.pageRtx.getValue((KeyValueLeafPage)pageCont.getModified(), recordKey);
        if (node == null) {
            node = this.pageRtx.getValue((KeyValueLeafPage)pageCont.getComplete(), recordKey);
        }
        return (V)this.pageRtx.checkItemIfDeleted(node);
    }

    @Override
    public String getName(int nameKey, @NonNull NodeKind nodeKind) {
        this.pageRtx.assertNotClosed();
        NamePage currentNamePage = this.getNamePage(this.newRevisionRootPage);
        return currentNamePage == null || currentNamePage.getName(nameKey, nodeKind, this.pageRtx) == null ? this.pageRtx.getName(nameKey, nodeKind) : currentNamePage.getName(nameKey, nodeKind, this.pageRtx);
    }

    @Override
    public int createNameKey(@Nullable String name, @NonNull NodeKind nodeKind) {
        this.pageRtx.assertNotClosed();
        Objects.requireNonNull(nodeKind);
        String string = name == null ? "" : name;
        NamePage namePage = this.getNamePage(this.newRevisionRootPage);
        return namePage.setName(string, nodeKind, this);
    }

    @Override
    public void commit(@Nullable PageReference reference) {
        if (reference == null) {
            return;
        }
        PageContainer container = this.log.get(reference);
        if (container == null) {
            return;
        }
        Page page = container.getModified();
        reference.setPage(page);
        page.commit(this);
        this.storagePageReaderWriter.write(this, reference, this.bufferBytes);
        container.getComplete().clearPage();
        page.clearPage();
        reference.setPage(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UberPage commit(@Nullable String commitMessage, @Nullable Instant commitTimestamp) {
        this.pageRtx.assertNotClosed();
        this.pageRtx.resourceSession.getCommitLock().lock();
        try {
            Path commitFile = this.pageRtx.resourceSession.getCommitFile();
            commitFile.toFile().deleteOnExit();
            this.createIfAbsent(commitFile);
            PageReference uberPageReference = new PageReference();
            UberPage uberPage = this.pageRtx.getUberPage();
            uberPageReference.setPage(uberPage);
            this.setUserIfPresent();
            this.setCommitMessageAndTimestampIfRequired(commitMessage, commitTimestamp);
            this.parallelSerializationOfKeyValuePages();
            uberPage.commit(this);
            uberPageReference.setPage(uberPage);
            this.storagePageReaderWriter.writeUberPageReference(this, uberPageReference, this.bufferBytes);
            uberPageReference.setPage(null);
            int revision = uberPage.getRevisionNumber();
            this.serializeIndexDefinitions(revision);
            this.log.clear();
            this.pageContainerCache.clear();
            try {
                Files.deleteIfExists(commitFile);
            }
            catch (IOException e) {
                throw new SirixIOException("Commit file couldn't be deleted!");
            }
        }
        finally {
            this.pageRtx.resourceSession.getCommitLock().unlock();
        }
        return this.readUberPage();
    }

    private void setCommitMessageAndTimestampIfRequired(@Nullable String commitMessage, @Nullable Instant commitTimestamp) {
        if (commitMessage != null) {
            this.newRevisionRootPage.setCommitMessage(commitMessage);
        }
        if (commitTimestamp != null) {
            this.newRevisionRootPage.setCommitTimestamp(commitTimestamp);
        }
    }

    private void serializeIndexDefinitions(int revision) {
        if (!this.indexController.getIndexes().getIndexDefs().isEmpty()) {
            Path indexes = this.pageRtx.getResourceSession().getResourceConfig().resourcePath.resolve(ResourceConfiguration.ResourcePaths.INDEXES.getPath()).resolve(revision + ".xml");
            try (OutputStream out = Files.newOutputStream(indexes, StandardOpenOption.CREATE);){
                this.indexController.serialize(out);
            }
            catch (IOException e) {
                throw new SirixIOException("Index definitions couldn't be serialized!", e);
            }
        }
    }

    private void parallelSerializationOfKeyValuePages() {
        this.log.getList().parallelStream().map(PageContainer::getModified).filter(page -> page instanceof KeyValueLeafPage).forEach(page -> {
            Bytes bytes = Bytes.elasticByteBuffer((int)60000);
            PageKind.KEYVALUELEAFPAGE.serializePage(this, (BytesOut<?>)bytes, (Page)page, SerializationType.DATA);
            bytes.clear();
        });
    }

    private UberPage readUberPage() {
        return (UberPage)this.storagePageReaderWriter.read(this.storagePageReaderWriter.readUberPageReference(), this.pageRtx);
    }

    private void createIfAbsent(Path file) {
        while (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }
    }

    private void setUserIfPresent() {
        Optional<User> optionalUser = this.pageRtx.resourceSession.getUser();
        optionalUser.ifPresent(this.newRevisionRootPage::setUser);
    }

    @Override
    public UberPage rollback() {
        this.pageRtx.assertNotClosed();
        this.log.clear();
        return this.readUberPage();
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed) {
            this.pageRtx.assertNotClosed();
            UberPage lastUberPage = this.readUberPage();
            this.pageRtx.resourceSession.setLastCommittedUberPage(lastUberPage);
            if (!this.isBoundToNodeTrx) {
                this.pageRtx.resourceSession.closePageWriteTransaction(this.pageRtx.getTrxId());
            }
            this.log.close();
            this.pageRtx.close();
            this.storagePageReaderWriter.close();
            this.isClosed = true;
        }
    }

    @Override
    public DeweyIDPage getDeweyIDPage(@NonNull RevisionRootPage revisionRoot) {
        return null;
    }

    private PageContainer getPageContainer(@NonNegative long recordPageKey, int indexNumber, IndexType indexType) {
        PageContainer pageContainer = this.getMostRecentPageContainer(indexType, recordPageKey, indexNumber, this.newRevisionRootPage.getRevision());
        if (pageContainer != null) {
            return pageContainer;
        }
        return this.pageContainerCache.computeIfAbsent(new IndexLogKey(indexType, recordPageKey, indexNumber, this.newRevisionRootPage.getRevision()), unused -> {
            PageReference pageReference = this.pageRtx.getPageReference(this.newRevisionRootPage, indexType, indexNumber);
            PageReference leafPageReference = this.pageRtx.getLeafPageReference(pageReference, recordPageKey, indexNumber, indexType, this.newRevisionRootPage);
            return this.log.get(leafPageReference);
        });
    }

    private @Nullable PageContainer getMostRecentPageContainer(IndexType indexType, long recordPageKey, @NonNegative int indexNumber, @NonNegative int revisionNumber) {
        PageContainer pageContainer;
        if (indexType == IndexType.PATH_SUMMARY) {
            return this.mostRecentPathSummaryPageContainer.indexType == indexType && this.mostRecentPathSummaryPageContainer.indexNumber == indexNumber && this.mostRecentPathSummaryPageContainer.recordPageKey == recordPageKey && this.mostRecentPathSummaryPageContainer.revisionNumber == revisionNumber ? this.mostRecentPathSummaryPageContainer.pageContainer : null;
        }
        PageContainer pageContainer2 = pageContainer = this.mostRecentPageContainer.indexType == indexType && this.mostRecentPageContainer.recordPageKey == recordPageKey && this.mostRecentPageContainer.indexNumber == indexNumber && this.mostRecentPageContainer.revisionNumber == revisionNumber ? this.mostRecentPageContainer.pageContainer : null;
        if (pageContainer == null) {
            pageContainer = this.secondMostRecentPageContainer.indexType == indexType && this.secondMostRecentPageContainer.recordPageKey == recordPageKey && this.secondMostRecentPageContainer.indexNumber == indexNumber && this.secondMostRecentPageContainer.revisionNumber == revisionNumber ? this.secondMostRecentPageContainer.pageContainer : null;
        }
        return pageContainer;
    }

    private PageContainer prepareRecordPage(@NonNegative long recordPageKey, int indexNumber, IndexType indexType) {
        assert (indexType != null);
        PageContainer mostRecentPageContainer1 = this.getMostRecentPageContainer(indexType, recordPageKey, indexNumber, this.newRevisionRootPage.getRevision());
        if (mostRecentPageContainer1 != null) {
            return mostRecentPageContainer1;
        }
        Function<IndexLogKey, PageContainer> fetchPageContainer = key -> {
            PageReference pageReference = this.pageRtx.getPageReference(this.newRevisionRootPage, indexType, indexNumber);
            PageReference reference = this.treeModifier.prepareLeafOfTree(this.pageRtx, this.log, this.getUberPage().getPageCountExp(indexType), pageReference, recordPageKey, indexNumber, indexType, this.newRevisionRootPage);
            PageContainer pageContainer = this.log.get(reference);
            if (pageContainer != null) {
                return pageContainer;
            }
            if (reference.getKey() == -15L) {
                KeyValueLeafPage completePage = new KeyValueLeafPage(recordPageKey, indexType, this.pageRtx);
                KeyValueLeafPage modifyPage = new KeyValueLeafPage(completePage);
                pageContainer = PageContainer.getInstance(completePage, modifyPage);
            } else {
                pageContainer = this.dereferenceRecordPageForModification(reference);
            }
            assert (pageContainer != null);
            switch (indexType) {
                case DOCUMENT: 
                case CHANGED_NODES: 
                case RECORD_TO_REVISIONS: 
                case PATH_SUMMARY: 
                case CAS: 
                case PATH: 
                case NAME: 
                case DEWEYID_TO_RECORDID: {
                    this.appendLogRecord(reference, pageContainer);
                    break;
                }
                default: {
                    throw new IllegalStateException("Page kind not known!");
                }
            }
            return pageContainer;
        };
        PageContainer currPageContainer = this.pageContainerCache.computeIfAbsent(new IndexLogKey(indexType, recordPageKey, indexNumber, this.newRevisionRootPage.getRevision()), fetchPageContainer);
        if (indexType == IndexType.PATH_SUMMARY) {
            this.mostRecentPathSummaryPageContainer = new IndexLogKeyToPageContainer(indexType, recordPageKey, indexNumber, this.newRevisionRootPage.getRevision(), currPageContainer);
        } else {
            this.secondMostRecentPageContainer = this.mostRecentPageContainer;
            this.mostRecentPageContainer = new IndexLogKeyToPageContainer(indexType, recordPageKey, indexNumber, this.newRevisionRootPage.getRevision(), currPageContainer);
        }
        return currPageContainer;
    }

    private PageContainer dereferenceRecordPageForModification(PageReference reference) {
        List<KeyValuePage<DataRecord>> pageFragments = this.pageRtx.getPageFragments(reference);
        VersioningType versioningType = this.pageRtx.resourceSession.getResourceConfig().versioningType;
        int mileStoneRevision = this.pageRtx.resourceSession.getResourceConfig().maxNumberOfRevisionsToRestore;
        return versioningType.combineRecordPagesForModification(pageFragments, mileStoneRevision, this.pageRtx, reference, this.log);
    }

    @Override
    public RevisionRootPage getActualRevisionRootPage() {
        this.pageRtx.assertNotClosed();
        return this.newRevisionRootPage;
    }

    @Override
    protected @NonNull PageReadOnlyTrx delegate() {
        return this.pageRtx;
    }

    @Override
    public PageReadOnlyTrx getPageReadOnlyTrx() {
        return this.pageRtx;
    }

    @Override
    public PageTrx appendLogRecord(@NonNull PageReference reference, @NonNull PageContainer pageContainer) {
        Objects.requireNonNull(pageContainer);
        this.log.put(reference, pageContainer);
        return this;
    }

    @Override
    public PageContainer getLogRecord(PageReference reference) {
        Objects.requireNonNull(reference);
        return this.log.get(reference);
    }

    @Override
    public PageTrx truncateTo(int revision) {
        this.storagePageReaderWriter.truncateTo(this, revision);
        return this;
    }

    @Override
    public long getTrxId() {
        return this.pageRtx.getTrxId();
    }

    @Override
    public CommitCredentials getCommitCredentials() {
        return this.pageRtx.getCommitCredentials();
    }

    private record IndexLogKeyToPageContainer(IndexType indexType, long recordPageKey, int indexNumber, int revisionNumber, PageContainer pageContainer) {
    }
}

