/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.sirix.access.User;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

public final class RevisionInfo {
    private final User user;
    private final int revision;
    private final Instant revisionTimestamp;
    private final String commitMessage;
    private int hash;

    public RevisionInfo(User user, int revision, Instant revisionTimestamp, String commitMessage) {
        this.user = (User)Preconditions.checkNotNull((Object)user);
        Preconditions.checkArgument((revision >= 0 ? 1 : 0) != 0);
        this.revision = revision;
        this.revisionTimestamp = (Instant)Preconditions.checkNotNull((Object)revisionTimestamp);
        this.commitMessage = commitMessage;
    }

    public User getUser() {
        return this.user;
    }

    public int getRevision() {
        return this.revision;
    }

    public Instant getRevisionTimestamp() {
        return this.revisionTimestamp;
    }

    public Optional<String> getCommitMessage() {
        return Optional.ofNullable(this.commitMessage);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.user, this.revision, this.revisionTimestamp, this.commitMessage);
        }
        return this.hash;
    }

    public boolean equals(Object other) {
        if (!(other instanceof RevisionInfo)) {
            return false;
        }
        RevisionInfo otherRevisionInfo = (RevisionInfo)other;
        return this.user == otherRevisionInfo.user && this.revision == otherRevisionInfo.revision && this.revisionTimestamp.equals(otherRevisionInfo.revisionTimestamp) && Objects.equals(this.commitMessage, otherRevisionInfo.commitMessage);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.user).add("revision", this.revision).add("revisionTimestamp", (Object)this.revisionTimestamp).add("commitMessage", (Object)this.commitMessage).toString();
    }
}

