/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis;

import io.sirix.api.NodeCursor;
import io.sirix.axis.AbstractAxis;
import io.sirix.axis.IncludeSelf;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import org.checkerframework.checker.index.qual.NonNegative;

public final class DescendantAxis
extends AbstractAxis {
    private LongArrayList rightSiblingKeyStack;
    private boolean first;

    public DescendantAxis(NodeCursor cursor) {
        super(cursor);
    }

    public DescendantAxis(NodeCursor cursor, IncludeSelf includeSelf) {
        super(cursor, includeSelf);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.first = true;
        this.rightSiblingKeyStack = new LongArrayList();
    }

    @Override
    protected long nextKey() {
        NodeCursor cursor = this.getCursor();
        if (this.first) {
            this.first = false;
            long key = this.includeSelf() == IncludeSelf.YES ? cursor.getNodeKey() : cursor.getFirstChildKey();
            return key;
        }
        if (cursor.hasFirstChild()) {
            long key = cursor.getFirstChildKey();
            if (cursor.hasRightSibling()) {
                this.rightSiblingKeyStack.add(cursor.getRightSiblingKey());
            }
            return key;
        }
        if (cursor.hasRightSibling()) {
            long currKey = cursor.getNodeKey();
            long key = cursor.getRightSiblingKey();
            return this.hasNextNode(key, currKey);
        }
        if (this.rightSiblingKeyStack.size() > 0) {
            long currKey = cursor.getNodeKey();
            long key = this.rightSiblingKeyStack.popLong();
            return this.hasNextNode(key, currKey);
        }
        return this.done();
    }

    private long hasNextNode(@NonNegative long key, @NonNegative long currKey) {
        NodeCursor cursor = this.getCursor();
        cursor.moveTo(key);
        if (cursor.getLeftSiblingKey() == this.getStartKey()) {
            return this.done();
        }
        cursor.moveTo(currKey);
        return key;
    }
}

