/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis;

import io.sirix.api.NodeCursor;
import io.sirix.axis.AbstractAxis;
import java.util.ArrayDeque;
import java.util.Deque;

public final class FollowingAxis
extends AbstractAxis {
    private boolean isFirst = true;
    private Deque<Long> rightSiblingStack = new ArrayDeque<Long>();

    public FollowingAxis(NodeCursor cursor) {
        super(cursor);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.isFirst = true;
        this.rightSiblingStack = new ArrayDeque<Long>();
    }

    @Override
    protected long nextKey() {
        if (this.isFirst) {
            switch (this.getCursor().getKind()) {
                case ATTRIBUTE: 
                case NAMESPACE: {
                    return this.done();
                }
            }
        }
        NodeCursor cursor = this.getCursor();
        long currKey = cursor.getNodeKey();
        if (this.isFirst) {
            this.isFirst = false;
            if (cursor.hasRightSibling()) {
                cursor.moveToRightSibling();
                long key = cursor.getNodeKey();
                if (cursor.hasRightSibling()) {
                    this.rightSiblingStack.push(cursor.getRightSiblingKey());
                }
                cursor.moveTo(currKey);
                return key;
            }
            while (cursor.hasParent()) {
                cursor.moveToParent();
                if (!cursor.hasRightSibling()) continue;
                cursor.moveToRightSibling();
                long key = cursor.getNodeKey();
                if (cursor.hasRightSibling()) {
                    this.rightSiblingStack.push(cursor.getRightSiblingKey());
                }
                cursor.moveTo(currKey);
                return key;
            }
            return this.done();
        }
        if (cursor.hasFirstChild()) {
            cursor.moveToFirstChild();
            long key = cursor.getNodeKey();
            if (cursor.hasRightSibling()) {
                this.rightSiblingStack.push(cursor.getRightSiblingKey());
            }
            cursor.moveTo(currKey);
            return key;
        }
        if (this.rightSiblingStack.isEmpty()) {
            while (cursor.hasParent()) {
                cursor.moveToParent();
                if (!cursor.hasRightSibling()) continue;
                cursor.moveToRightSibling();
                long key = cursor.getNodeKey();
                if (cursor.hasRightSibling()) {
                    this.rightSiblingStack.push(cursor.getRightSiblingKey());
                }
                cursor.moveTo(currKey);
                return key;
            }
        } else {
            cursor.moveTo(this.rightSiblingStack.pop());
            long key = cursor.getNodeKey();
            if (cursor.hasRightSibling()) {
                this.rightSiblingStack.push(cursor.getRightSiblingKey());
            }
            cursor.moveTo(currKey);
            return key;
        }
        return this.done();
    }
}

