/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis;

import io.sirix.api.Axis;
import io.sirix.axis.AbstractAxis;
import java.util.Objects;

public final class NestedAxis
extends AbstractAxis {
    private final Axis parentAxis;
    private final Axis childAxis;
    private boolean isFirst;

    public NestedAxis(Axis parentAxis, Axis childAxis) {
        super(parentAxis.getCursor());
        this.parentAxis = Objects.requireNonNull(parentAxis);
        this.childAxis = Objects.requireNonNull(childAxis);
        this.isFirst = true;
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.parentAxis != null) {
            this.parentAxis.reset(nodeKey);
        }
        if (this.childAxis != null) {
            this.childAxis.reset(nodeKey);
        }
        this.isFirst = true;
    }

    @Override
    protected long nextKey() {
        boolean hasNext;
        if (this.isFirst) {
            this.isFirst = false;
            if (this.parentAxis.hasNext()) {
                this.childAxis.reset(this.parentAxis.next());
            } else {
                return this.done();
            }
        }
        while (!(hasNext = this.childAxis.hasNext()) && this.parentAxis.hasNext()) {
            this.childAxis.reset(this.parentAxis.next());
        }
        if (hasNext) {
            return this.childAxis.next();
        }
        return this.done();
    }
}

