/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis;

import io.sirix.api.NodeCursor;
import io.sirix.axis.AbstractAxis;
import io.sirix.node.NodeKind;
import java.util.ArrayDeque;
import java.util.Deque;

public final class PrecedingAxis
extends AbstractAxis {
    private boolean mIsFirst = true;
    private Deque<Long> mStack = new ArrayDeque<Long>();

    public PrecedingAxis(NodeCursor cursor) {
        super(cursor);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.mIsFirst = true;
        this.mStack = new ArrayDeque<Long>();
    }

    @Override
    protected long nextKey() {
        NodeCursor cursor = this.getCursor();
        if (this.mIsFirst) {
            this.mIsFirst = false;
            if (cursor.getKind() == NodeKind.ATTRIBUTE || cursor.getKind() == NodeKind.NAMESPACE) {
                return this.done();
            }
        }
        long key = cursor.getNodeKey();
        if (!this.mStack.isEmpty()) {
            return this.mStack.pop();
        }
        if (cursor.hasLeftSibling()) {
            cursor.moveToLeftSibling();
            this.getLastChild();
            long nodeKey = cursor.getNodeKey();
            cursor.moveTo(key);
            return nodeKey;
        }
        while (cursor.hasParent()) {
            cursor.moveToParent();
            if (!cursor.hasLeftSibling()) continue;
            cursor.moveToLeftSibling();
            this.getLastChild();
            long nodeKey = cursor.getNodeKey();
            cursor.moveTo(key);
            return nodeKey;
        }
        return this.done();
    }

    private void getLastChild() {
        NodeCursor cursor = this.getCursor();
        long parent = cursor.getNodeKey();
        if (cursor.hasFirstChild()) {
            while (cursor.hasFirstChild()) {
                this.mStack.push(cursor.getNodeKey());
                cursor.moveToFirstChild();
            }
            while (cursor.hasRightSibling()) {
                this.mStack.push(cursor.getNodeKey());
                cursor.moveToRightSibling();
                this.getLastChild();
            }
            if (cursor.hasParent() && cursor.getParentKey() != parent) {
                this.mStack.push(cursor.getNodeKey());
                while (cursor.hasParent() && cursor.getParentKey() != parent) {
                    cursor.moveToParent();
                    while (cursor.hasRightSibling()) {
                        cursor.moveToRightSibling();
                        this.getLastChild();
                        this.mStack.push(cursor.getNodeKey());
                    }
                }
                cursor.moveTo(this.mStack.pop());
            }
        }
    }
}

