/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis;

import io.sirix.api.NodeCursor;
import io.sirix.axis.AbstractAxis;
import io.sirix.node.NodeKind;
import io.sirix.settings.Fixed;

public final class PrecedingSiblingAxis
extends AbstractAxis {
    private boolean mIsFirst;

    public PrecedingSiblingAxis(NodeCursor cursor) {
        super(cursor);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.mIsFirst = true;
    }

    @Override
    protected long nextKey() {
        NodeCursor cursor = this.getCursor();
        if (this.mIsFirst) {
            this.mIsFirst = false;
            NodeKind kind = cursor.getKind();
            if (kind == NodeKind.ATTRIBUTE || kind == NodeKind.NAMESPACE) {
                return this.done();
            }
            if (cursor.hasParent()) {
                long startNodeKey = cursor.getNodeKey();
                cursor.moveToParent();
                cursor.moveToFirstChild();
                if (cursor.getNodeKey() == startNodeKey) {
                    return Fixed.NULL_NODE_KEY.getStandardProperty();
                }
                long key = cursor.getNodeKey();
                cursor.moveTo(startNodeKey);
                return key;
            }
        }
        if (cursor.hasRightSibling() && cursor.getRightSiblingKey() != this.getStartKey()) {
            return cursor.getRightSiblingKey();
        }
        return this.done();
    }
}

