/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.concurrent;

import io.sirix.api.Axis;
import io.sirix.settings.Fixed;
import io.sirix.utils.LogWrapper;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.LoggerFactory;

public class ConcurrentAxisHelper
implements Runnable {
    public static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(ConcurrentAxisHelper.class));
    private final Axis axis;
    private BlockingQueue<Long> results;

    public ConcurrentAxisHelper(Axis axis, @NonNull BlockingQueue<Long> results) {
        this.axis = Objects.requireNonNull(axis);
        this.results = Objects.requireNonNull(results);
    }

    @Override
    public void run() {
        while (this.axis.hasNext()) {
            long nodeKey = this.axis.nextLong();
            try {
                this.results.put(nodeKey);
            }
            catch (InterruptedException e) {
                LOGWRAPPER.error(e.getMessage(), e);
            }
        }
        try {
            this.results.put(Fixed.NULL_NODE_KEY.getStandardProperty());
        }
        catch (InterruptedException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }
}

