/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.concurrent;

import io.sirix.api.Axis;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.axis.AbstractAxis;
import io.sirix.axis.concurrent.ConcurrentAxis;
import io.sirix.axis.concurrent.Util;
import io.sirix.settings.Fixed;

public final class ConcurrentExceptAxis<R extends NodeCursor & NodeReadOnlyTrx>
extends AbstractAxis {
    private final ConcurrentAxis<R> op1;
    private final ConcurrentAxis<R> op2;
    private boolean first;
    private long currentResult1;
    private long currentResult2;

    public ConcurrentExceptAxis(R rtx, Axis operand1, Axis operand2) {
        super((NodeCursor)rtx);
        this.op1 = new ConcurrentAxis<R>(rtx, operand1);
        this.op2 = new ConcurrentAxis<R>(rtx, operand2);
        this.first = true;
        this.currentResult1 = Fixed.NULL_NODE_KEY.getStandardProperty();
        this.currentResult2 = Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public void reset(long pNodeKey) {
        super.reset(pNodeKey);
        if (this.op1 != null) {
            this.op1.reset(pNodeKey);
        }
        if (this.op2 != null) {
            this.op2.reset(pNodeKey);
        }
        this.first = true;
        this.currentResult1 = Fixed.NULL_NODE_KEY.getStandardProperty();
        this.currentResult2 = Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    protected long nextKey() {
        if (this.first) {
            this.first = false;
            this.currentResult1 = Util.getNext(this.op1);
            this.currentResult2 = Util.getNext(this.op2);
        }
        while (!this.op1.isFinished()) {
            while (!this.op2.isFinished() && !this.op1.isFinished()) {
                while (this.currentResult1 >= this.currentResult2 && !this.op1.isFinished() && !this.op2.isFinished()) {
                    while (this.currentResult1 == this.currentResult2 && !this.op1.isFinished() && !this.op2.isFinished()) {
                        this.currentResult1 = Util.getNext(this.op1);
                        this.currentResult2 = Util.getNext(this.op2);
                    }
                    while (this.currentResult1 > this.currentResult2 && !this.op1.isFinished() && !this.op2.isFinished()) {
                        this.currentResult2 = Util.getNext(this.op2);
                    }
                }
                if (this.op1.isFinished() || this.op2.isFinished()) continue;
                assert (this.currentResult1 < this.currentResult2);
                long nodeKey = this.currentResult1;
                if (Util.isValid(nodeKey)) {
                    this.currentResult1 = Util.getNext(this.op1);
                    return nodeKey;
                }
                throw new IllegalStateException(nodeKey + " is not valid!");
            }
            if (this.op1.isFinished()) continue;
            long nodeKey = this.currentResult1;
            if (Util.isValid(nodeKey)) {
                this.currentResult1 = Util.getNext(this.op1);
                return nodeKey;
            }
            throw new IllegalStateException(nodeKey + " is not valid!");
        }
        return this.done();
    }
}

