/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.filter;

import io.sirix.api.Axis;
import io.sirix.api.Filter;
import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.axis.AbstractAxis;
import java.util.ArrayList;
import java.util.List;

public final class FilterAxis<R extends NodeReadOnlyTrx & NodeCursor>
extends AbstractAxis {
    private final Axis axis;
    private final List<Filter<R>> axisFilter;

    @SafeVarargs
    public FilterAxis(Axis axis, Filter<R> firstAxisTest, Filter<R> ... axisTest) {
        super(axis.getCursor());
        this.axis = axis;
        this.axisFilter = new ArrayList<Filter<R>>();
        this.axisFilter.add(firstAxisTest);
        if (!this.axis.getCursor().equals(this.axisFilter.get(0).getTrx())) {
            throw new IllegalArgumentException("The filter must be bound to the same transaction as the axis!");
        }
        if (axisTest != null) {
            for (Filter<R> filter : axisTest) {
                this.axisFilter.add(filter);
                if (this.axis.getCursor().equals(this.axisFilter.get(this.axisFilter.size() - 1).getTrx())) continue;
                throw new IllegalArgumentException("The filter must be bound to the same transaction as the axis!");
            }
        }
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.axis != null) {
            this.axis.reset(nodeKey);
        }
    }

    @Override
    protected long nextKey() {
        while (this.axis.hasNext()) {
            long nodeKey = this.axis.nextLong();
            boolean filterResult = true;
            for (Filter<R> filter : this.axisFilter) {
                if (filterResult = filterResult && filter.filter()) continue;
                break;
            }
            if (!filterResult) continue;
            return nodeKey;
        }
        return this.done();
    }

    public Axis getAxis() {
        return this.axis;
    }
}

