/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.filter.xml;

import io.sirix.api.Filter;
import io.sirix.api.ResourceSession;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.api.xml.XmlNodeTrx;
import io.sirix.axis.AbstractTemporalAxis;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class TemporalXmlNodeReadFilterAxis<F extends Filter<XmlNodeReadOnlyTrx>>
extends AbstractTemporalAxis<XmlNodeReadOnlyTrx, XmlNodeTrx> {
    private final AbstractTemporalAxis<XmlNodeReadOnlyTrx, XmlNodeTrx> axis;
    private final List<F> axisFilter;

    @SafeVarargs
    public TemporalXmlNodeReadFilterAxis(AbstractTemporalAxis<XmlNodeReadOnlyTrx, XmlNodeTrx> axis, F firstAxisTest, F ... axisTest) {
        Objects.requireNonNull(firstAxisTest);
        this.axis = axis;
        this.axisFilter = new ArrayList<F>();
        this.axisFilter.add(firstAxisTest);
        if (axisTest != null) {
            int length = axisTest.length;
            for (int i = 0; i < length; ++i) {
                this.axisFilter.add(axisTest[i]);
            }
        }
    }

    protected XmlNodeReadOnlyTrx computeNext() {
        while (this.axis.hasNext()) {
            XmlNodeReadOnlyTrx rtx = (XmlNodeReadOnlyTrx)this.axis.next();
            boolean filterResult = this.doFilter(rtx);
            if (filterResult) {
                return rtx;
            }
            rtx.close();
        }
        return (XmlNodeReadOnlyTrx)this.endOfData();
    }

    private boolean doFilter(XmlNodeReadOnlyTrx rtx) {
        boolean filterResult = true;
        for (Filter filter : this.axisFilter) {
            filter.setTrx(rtx);
            if (filterResult = filterResult && filter.filter()) continue;
            break;
        }
        return filterResult;
    }

    public AbstractTemporalAxis<XmlNodeReadOnlyTrx, XmlNodeTrx> getAxis() {
        return this.axis;
    }

    @Override
    public ResourceSession<XmlNodeReadOnlyTrx, XmlNodeTrx> getResourceManager() {
        return this.axis.getResourceManager();
    }
}

