/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.temporal;

import io.sirix.api.NodeCursor;
import io.sirix.api.NodeReadOnlyTrx;
import io.sirix.api.NodeTrx;
import io.sirix.api.ResourceSession;
import io.sirix.axis.AbstractTemporalAxis;
import io.sirix.axis.IncludeSelf;
import java.util.Objects;

public final class PastAxis<R extends NodeReadOnlyTrx & NodeCursor, W extends NodeTrx & NodeCursor>
extends AbstractTemporalAxis<R, W> {
    private final ResourceSession<R, W> resourceSession;
    private int revision;
    private final long nodeKey;

    public PastAxis(ResourceSession<R, W> resourceSession, R rtx) {
        this(resourceSession, rtx, IncludeSelf.NO);
    }

    public PastAxis(ResourceSession<R, W> resourceSession, R rtx, IncludeSelf includeSelf) {
        this.resourceSession = Objects.requireNonNull(resourceSession);
        this.revision = 0;
        this.nodeKey = rtx.getNodeKey();
        this.revision = Objects.requireNonNull(includeSelf) == IncludeSelf.YES ? rtx.getRevisionNumber() : rtx.getRevisionNumber() - 1;
    }

    protected R computeNext() {
        if (this.revision > 0) {
            R rtx = this.resourceSession.beginNodeReadOnlyTrx(this.revision);
            --this.revision;
            if (rtx.moveTo(this.nodeKey)) {
                return rtx;
            }
            rtx.close();
            return (R)((NodeReadOnlyTrx)this.endOfData());
        }
        return (R)((NodeReadOnlyTrx)this.endOfData());
    }

    @Override
    public ResourceSession<R, W> getResourceManager() {
        return this.resourceSession;
    }
}

