/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.axis.visitor;

import io.sirix.api.NodeCursor;
import io.sirix.api.json.JsonNodeReadOnlyTrx;
import io.sirix.api.visitor.JsonNodeVisitor;
import io.sirix.api.visitor.NodeVisitor;
import io.sirix.api.visitor.VisitResult;
import io.sirix.api.visitor.VisitResultType;
import io.sirix.api.visitor.XmlNodeVisitor;
import io.sirix.api.xml.XmlNodeReadOnlyTrx;
import io.sirix.axis.AbstractAxis;
import io.sirix.axis.IncludeSelf;
import io.sirix.axis.visitor.LocalVisitResult;
import io.sirix.settings.Fixed;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class VisitorDescendantAxis
extends AbstractAxis {
    private Deque<Long> rightSiblingKeyStack;
    private NodeVisitor visitor;
    private boolean isFirstCall;

    public static Builder newBuilder(NodeCursor cursor) {
        return new Builder(cursor);
    }

    private VisitorDescendantAxis(Builder builder) {
        super(builder.rtx, builder.includeSelf);
        this.visitor = builder.visitor;
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        this.isFirstCall = true;
        this.rightSiblingKeyStack = new ArrayDeque<Long>();
    }

    @Override
    protected long nextKey() {
        VisitResult result = null;
        if (this.visitor != null) {
            if (this.getTrx() instanceof XmlNodeReadOnlyTrx) {
                result = this.asXmlNodeReadTrx().acceptVisitor((XmlNodeVisitor)this.visitor);
            } else if (this.getTrx() instanceof JsonNodeReadOnlyTrx) {
                result = this.asJsonNodeReadTrx().acceptVisitor((JsonNodeVisitor)this.visitor);
            } else {
                throw new AssertionError();
            }
        }
        this.resetToLastKey();
        if (VisitResultType.TERMINATE == result) {
            return Fixed.NULL_NODE_KEY.getStandardProperty();
        }
        NodeCursor cursor = this.getCursor();
        if (this.isFirstCall) {
            this.isFirstCall = false;
            return this.includeSelf() == IncludeSelf.YES ? cursor.getNodeKey() : cursor.getFirstChildKey();
        }
        if (LocalVisitResult.SKIPSUBTREEPOPSTACK == result) {
            this.rightSiblingKeyStack.pop();
        }
        if (result != VisitResultType.SKIPSUBTREE && result != LocalVisitResult.SKIPSUBTREEPOPSTACK && cursor.hasFirstChild()) {
            long key = cursor.getFirstChildKey();
            long rightSiblNodeKey = cursor.getRightSiblingKey();
            if (cursor.hasRightSibling() && (this.rightSiblingKeyStack.isEmpty() || this.rightSiblingKeyStack.peek() != rightSiblNodeKey)) {
                this.rightSiblingKeyStack.push(rightSiblNodeKey);
            }
            return key;
        }
        if (result != VisitResultType.SKIPSIBLINGS && cursor.hasRightSibling()) {
            long nextKey = cursor.getRightSiblingKey();
            return this.getNextNodeKey(nextKey, cursor.getNodeKey());
        }
        return this.nextSiblingNodeKeyIfAvailable(result, cursor);
    }

    private @Nullable long nextSiblingNodeKeyIfAvailable(VisitResult result, NodeCursor cursor) {
        if (!this.rightSiblingKeyStack.isEmpty()) {
            Long nextKey = this.rightSiblingKeyStack.pop();
            long nextNodeKey = this.getNextNodeKey(nextKey, cursor.getNodeKey());
            if (nextNodeKey == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                return nextNodeKey;
            }
            if (result == VisitResultType.SKIPSIBLINGS) {
                long nodeKey = cursor.getNodeKey();
                cursor.moveTo(nextKey);
                if (this.visitor != null) {
                    if (this.getTrx() instanceof XmlNodeReadOnlyTrx) {
                        result = this.asXmlNodeReadTrx().acceptVisitor((XmlNodeVisitor)this.visitor);
                    } else if (this.getTrx() instanceof JsonNodeReadOnlyTrx) {
                        result = this.asJsonNodeReadTrx().acceptVisitor((JsonNodeVisitor)this.visitor);
                    } else {
                        throw new AssertionError();
                    }
                }
                if (result == VisitResultType.SKIPSIBLINGS) {
                    return this.nextSiblingNodeKeyIfAvailable(result, cursor);
                }
                cursor.moveTo(nodeKey);
            }
            return nextNodeKey;
        }
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    private long getNextNodeKey(@NonNegative long nextKey, @NonNegative long currKey) {
        NodeCursor cursor = this.getCursor();
        cursor.moveTo(nextKey);
        if (cursor.getLeftSiblingKey() == this.getStartKey()) {
            return Fixed.NULL_NODE_KEY.getStandardProperty();
        }
        cursor.moveTo(currKey);
        return nextKey;
    }

    public static class Builder {
        private NodeVisitor visitor;
        private final NodeCursor rtx;
        private IncludeSelf includeSelf = IncludeSelf.NO;

        public Builder(NodeCursor rtx) {
            this.rtx = Objects.requireNonNull(rtx);
        }

        public Builder includeSelf() {
            this.includeSelf = IncludeSelf.YES;
            return this;
        }

        public Builder visitor(NodeVisitor visitor) {
            this.visitor = Objects.requireNonNull(visitor);
            return this;
        }

        public VisitorDescendantAxis build() {
            return new VisitorDescendantAxis(this);
        }
    }
}

