/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.cache;

import io.sirix.cache.BufferManager;
import io.sirix.cache.Cache;
import io.sirix.cache.NamesCache;
import io.sirix.cache.PageCache;
import io.sirix.cache.PathSummaryCache;
import io.sirix.cache.RBIndexKey;
import io.sirix.cache.RecordPageCache;
import io.sirix.cache.RedBlackTreeNodeCache;
import io.sirix.cache.RevisionRootPageCache;
import io.sirix.node.interfaces.Node;
import io.sirix.page.KeyValueLeafPage;
import io.sirix.page.PageReference;
import io.sirix.page.RevisionRootPage;
import io.sirix.page.interfaces.Page;

public final class BufferManagerImpl
implements BufferManager {
    private final PageCache pageCache;
    private final RecordPageCache recordPageCache;
    private final RevisionRootPageCache revisionRootPageCache;
    private final RedBlackTreeNodeCache redBlackTreeNodeCache;
    private final NamesCache namesCache;
    private final PathSummaryCache pathSummaryCache;

    public BufferManagerImpl(int maxPageCacheSize, int maxRecordPageCacheSize, int maxRevisionRootPageCache, int maxRBTreeNodeCache, int maxNamesCacheSize, int maxPathSummaryCacheSize) {
        this.pageCache = new PageCache(maxPageCacheSize);
        this.recordPageCache = new RecordPageCache(maxRecordPageCacheSize);
        this.revisionRootPageCache = new RevisionRootPageCache(maxRevisionRootPageCache);
        this.redBlackTreeNodeCache = new RedBlackTreeNodeCache(maxRBTreeNodeCache);
        this.namesCache = new NamesCache(maxNamesCacheSize);
        this.pathSummaryCache = new PathSummaryCache(maxPathSummaryCacheSize);
    }

    @Override
    public Cache<PageReference, Page> getPageCache() {
        return this.pageCache;
    }

    @Override
    public Cache<PageReference, KeyValueLeafPage> getRecordPageCache() {
        return this.recordPageCache;
    }

    @Override
    public Cache<Integer, RevisionRootPage> getRevisionRootPageCache() {
        return this.revisionRootPageCache;
    }

    @Override
    public Cache<RBIndexKey, Node> getIndexCache() {
        return this.redBlackTreeNodeCache;
    }

    public NamesCache getNamesCache() {
        return this.namesCache;
    }

    public PathSummaryCache getPathSummaryCache() {
        return this.pathSummaryCache;
    }

    @Override
    public void close() {
    }

    @Override
    public void clearAllCaches() {
        this.pageCache.clear();
        this.recordPageCache.clear();
        this.revisionRootPageCache.clear();
        this.redBlackTreeNodeCache.clear();
        this.namesCache.clear();
        this.pathSummaryCache.clear();
    }
}

