/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.cache;

import io.sirix.index.IndexType;
import org.checkerframework.checker.index.qual.NonNegative;

public final class IndexLogKey {
    private IndexType indexType;
    private long recordPageKey;
    private @NonNegative int indexNumber;
    private @NonNegative int revisionNumber;
    private int hash;

    public IndexLogKey(IndexType indexType, long recordPageKey, @NonNegative int indexNumber, @NonNegative int revisionNumber) {
        this.indexType = indexType;
        this.recordPageKey = recordPageKey;
        this.indexNumber = indexNumber;
        this.revisionNumber = revisionNumber;
    }

    public IndexLogKey setIndexType(IndexType indexType) {
        this.indexType = indexType;
        return this;
    }

    public IndexLogKey setRecordPageKey(long recordPageKey) {
        this.recordPageKey = recordPageKey;
        return this;
    }

    public IndexLogKey setIndexNumber(int indexNumber) {
        this.indexNumber = indexNumber;
        return this;
    }

    public IndexLogKey setRevisionNumber(int revisionNumber) {
        this.revisionNumber = revisionNumber;
        return this;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.indexType.getID() + Long.hashCode(this.recordPageKey) + this.indexNumber + this.revisionNumber;
        }
        return this.hash;
    }

    public long getRecordPageKey() {
        return this.recordPageKey;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public int getIndexNumber() {
        return this.indexNumber;
    }

    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IndexLogKey that = (IndexLogKey)obj;
        return this.indexType == that.indexType && this.recordPageKey == that.recordPageKey && this.indexNumber == that.indexNumber && this.revisionNumber == that.revisionNumber;
    }

    public String toString() {
        return "IndexLogKey[indexType=" + String.valueOf((Object)this.indexType) + ", recordPageKey=" + this.recordPageKey + ", indexNumber=" + this.indexNumber + ", revisionNumber=" + this.revisionNumber + "]";
    }
}

