/*
 * Decompiled with CFR 0.152.
 */
package io.sirix.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import io.sirix.cache.Cache;
import io.sirix.page.KeyValueLeafPage;
import io.sirix.page.PageReference;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class RecordPageCache
implements Cache<PageReference, KeyValueLeafPage> {
    private final com.github.benmanes.caffeine.cache.Cache<PageReference, KeyValueLeafPage> pageCache;

    public RecordPageCache(int maxSize) {
        RemovalListener removalListener = (key, value, cause) -> key.setPage(null);
        this.pageCache = Caffeine.newBuilder().maximumSize((long)maxSize).expireAfterAccess(5L, TimeUnit.MINUTES).scheduler(scheduler).removalListener(removalListener).build();
    }

    @Override
    public void clear() {
        this.pageCache.invalidateAll();
    }

    @Override
    public KeyValueLeafPage get(PageReference key) {
        KeyValueLeafPage keyValueLeafPage = (KeyValueLeafPage)this.pageCache.getIfPresent((Object)key);
        return keyValueLeafPage;
    }

    @Override
    public void put(PageReference key, @NonNull KeyValueLeafPage value) {
        this.pageCache.put((Object)key, (Object)value);
    }

    @Override
    public void putAll(Map<? extends PageReference, ? extends KeyValueLeafPage> map) {
        this.pageCache.putAll(map);
    }

    @Override
    public void toSecondCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<PageReference, KeyValueLeafPage> getAll(Iterable<? extends PageReference> keys) {
        return this.pageCache.getAllPresent(keys);
    }

    @Override
    public void remove(PageReference key) {
        this.pageCache.invalidate((Object)key);
    }

    @Override
    public void close() {
    }
}

